/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.task.meta;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.commons.pipe.task.meta.PipeType;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class PipeStaticMeta {
    private String pipeName;
    private long creationTime;
    private PipeParameters extractorParameters;
    private PipeParameters processorParameters;
    private PipeParameters connectorParameters;
    public static final String SYSTEM_PIPE_PREFIX = "__";
    public static final String SUBSCRIPTION_PIPE_PREFIX = "__subscription.";

    private PipeStaticMeta() {
    }

    public PipeStaticMeta(String pipeName, long creationTime, Map<String, String> extractorAttributes, Map<String, String> processorAttributes, Map<String, String> connectorAttributes) {
        this.pipeName = pipeName;
        this.creationTime = creationTime;
        this.extractorParameters = new PipeParameters(extractorAttributes);
        this.processorParameters = new PipeParameters(processorAttributes);
        this.connectorParameters = new PipeParameters(connectorAttributes);
    }

    public String getPipeName() {
        return this.pipeName;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public PipeParameters getExtractorParameters() {
        return this.extractorParameters;
    }

    public PipeParameters getProcessorParameters() {
        return this.processorParameters;
    }

    public PipeParameters getConnectorParameters() {
        return this.connectorParameters;
    }

    public PipeType getPipeType() {
        return PipeType.getPipeType(this.pipeName);
    }

    public ByteBuffer serialize() throws IOException {
        PublicBAOS byteArrayOutputStream = new PublicBAOS();
        DataOutputStream outputStream = new DataOutputStream(byteArrayOutputStream);
        this.serialize(outputStream);
        return ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
    }

    public void serialize(OutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write(this.pipeName, outputStream);
        ReadWriteIOUtils.write(this.creationTime, outputStream);
        ReadWriteIOUtils.write(this.extractorParameters.getAttribute().size(), outputStream);
        for (Map.Entry<String, String> entry : this.extractorParameters.getAttribute().entrySet()) {
            ReadWriteIOUtils.write(entry.getKey(), outputStream);
            ReadWriteIOUtils.write(entry.getValue(), outputStream);
        }
        ReadWriteIOUtils.write(this.processorParameters.getAttribute().size(), outputStream);
        for (Map.Entry<String, String> entry : this.processorParameters.getAttribute().entrySet()) {
            ReadWriteIOUtils.write(entry.getKey(), outputStream);
            ReadWriteIOUtils.write(entry.getValue(), outputStream);
        }
        ReadWriteIOUtils.write(this.connectorParameters.getAttribute().size(), outputStream);
        for (Map.Entry<String, String> entry : this.connectorParameters.getAttribute().entrySet()) {
            ReadWriteIOUtils.write(entry.getKey(), outputStream);
            ReadWriteIOUtils.write(entry.getValue(), outputStream);
        }
    }

    public static PipeStaticMeta deserialize(InputStream inputStream) throws IOException {
        String value;
        String key;
        int i;
        PipeStaticMeta pipeStaticMeta = new PipeStaticMeta();
        pipeStaticMeta.pipeName = ReadWriteIOUtils.readString(inputStream);
        pipeStaticMeta.creationTime = ReadWriteIOUtils.readLong(inputStream);
        pipeStaticMeta.extractorParameters = new PipeParameters(new HashMap<String, String>());
        pipeStaticMeta.processorParameters = new PipeParameters(new HashMap<String, String>());
        pipeStaticMeta.connectorParameters = new PipeParameters(new HashMap<String, String>());
        int size = ReadWriteIOUtils.readInt(inputStream);
        for (i = 0; i < size; ++i) {
            key = ReadWriteIOUtils.readString(inputStream);
            value = ReadWriteIOUtils.readString(inputStream);
            pipeStaticMeta.extractorParameters.getAttribute().put(key, value);
        }
        size = ReadWriteIOUtils.readInt(inputStream);
        for (i = 0; i < size; ++i) {
            key = ReadWriteIOUtils.readString(inputStream);
            value = ReadWriteIOUtils.readString(inputStream);
            pipeStaticMeta.processorParameters.getAttribute().put(key, value);
        }
        size = ReadWriteIOUtils.readInt(inputStream);
        for (i = 0; i < size; ++i) {
            key = ReadWriteIOUtils.readString(inputStream);
            value = ReadWriteIOUtils.readString(inputStream);
            pipeStaticMeta.connectorParameters.getAttribute().put(key, value);
        }
        return pipeStaticMeta;
    }

    public static PipeStaticMeta deserialize(ByteBuffer byteBuffer) {
        String value;
        String key;
        int i;
        PipeStaticMeta pipeStaticMeta = new PipeStaticMeta();
        pipeStaticMeta.pipeName = ReadWriteIOUtils.readString(byteBuffer);
        pipeStaticMeta.creationTime = ReadWriteIOUtils.readLong(byteBuffer);
        pipeStaticMeta.extractorParameters = new PipeParameters(new HashMap<String, String>());
        pipeStaticMeta.processorParameters = new PipeParameters(new HashMap<String, String>());
        pipeStaticMeta.connectorParameters = new PipeParameters(new HashMap<String, String>());
        int size = ReadWriteIOUtils.readInt(byteBuffer);
        for (i = 0; i < size; ++i) {
            key = ReadWriteIOUtils.readString(byteBuffer);
            value = ReadWriteIOUtils.readString(byteBuffer);
            pipeStaticMeta.extractorParameters.getAttribute().put(key, value);
        }
        size = ReadWriteIOUtils.readInt(byteBuffer);
        for (i = 0; i < size; ++i) {
            key = ReadWriteIOUtils.readString(byteBuffer);
            value = ReadWriteIOUtils.readString(byteBuffer);
            pipeStaticMeta.processorParameters.getAttribute().put(key, value);
        }
        size = ReadWriteIOUtils.readInt(byteBuffer);
        for (i = 0; i < size; ++i) {
            key = ReadWriteIOUtils.readString(byteBuffer);
            value = ReadWriteIOUtils.readString(byteBuffer);
            pipeStaticMeta.connectorParameters.getAttribute().put(key, value);
        }
        return pipeStaticMeta;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PipeStaticMeta that = (PipeStaticMeta)obj;
        return this.pipeName.equals(that.pipeName) && this.creationTime == that.creationTime && this.extractorParameters.equals(that.extractorParameters) && this.processorParameters.equals(that.processorParameters) && this.connectorParameters.equals(that.connectorParameters);
    }

    public int hashCode() {
        return Objects.hash(this.pipeName, this.creationTime, this.extractorParameters, this.processorParameters, this.connectorParameters);
    }

    public String toString() {
        return "PipeStaticMeta{pipeName='" + this.pipeName + "', creationTime=" + this.creationTime + ", extractorParameters=" + this.extractorParameters + ", processorParameters=" + this.processorParameters + ", connectorParameters=" + this.connectorParameters + "}";
    }

    public static String generateSubscriptionPipeName(String topicName, String consumerGroupId) {
        return SUBSCRIPTION_PIPE_PREFIX + topicName + "_" + consumerGroupId;
    }
}

