/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.task.meta;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeException;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeExceptionType;
import org.apache.iotdb.commons.pipe.task.meta.PipeRuntimeMetaVersion;
import org.apache.iotdb.commons.pipe.task.meta.PipeStatus;
import org.apache.iotdb.commons.pipe.task.meta.PipeTaskMeta;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class PipeRuntimeMeta {
    private final AtomicReference<PipeStatus> status = new AtomicReference<PipeStatus>(PipeStatus.STOPPED);
    private final ConcurrentMap<Integer, PipeTaskMeta> consensusGroupId2TaskMetaMap;
    private final ConcurrentMap<Integer, PipeRuntimeException> nodeId2PipeRuntimeExceptionMap = new ConcurrentHashMap<Integer, PipeRuntimeException>();
    private final AtomicLong exceptionsClearTime = new AtomicLong(Long.MIN_VALUE);
    private final AtomicBoolean isStoppedByRuntimeException = new AtomicBoolean(false);

    public PipeRuntimeMeta() {
        this.consensusGroupId2TaskMetaMap = new ConcurrentHashMap<Integer, PipeTaskMeta>();
    }

    public PipeRuntimeMeta(ConcurrentMap<Integer, PipeTaskMeta> consensusGroupId2TaskMetaMap) {
        this.consensusGroupId2TaskMetaMap = consensusGroupId2TaskMetaMap;
    }

    public AtomicReference<PipeStatus> getStatus() {
        return this.status;
    }

    public ConcurrentMap<Integer, PipeTaskMeta> getConsensusGroupId2TaskMetaMap() {
        return this.consensusGroupId2TaskMetaMap;
    }

    public ConcurrentMap<Integer, PipeRuntimeException> getNodeId2PipeRuntimeExceptionMap() {
        return this.nodeId2PipeRuntimeExceptionMap;
    }

    public long getExceptionsClearTime() {
        return this.exceptionsClearTime.get();
    }

    public void setExceptionsClearTime(long exceptionsClearTime) {
        if (exceptionsClearTime > this.getExceptionsClearTime()) {
            this.exceptionsClearTime.set(exceptionsClearTime);
        }
    }

    public boolean getIsStoppedByRuntimeException() {
        return this.isStoppedByRuntimeException.get();
    }

    public void setIsStoppedByRuntimeException(boolean isStoppedByRuntimeException) {
        this.isStoppedByRuntimeException.set(isStoppedByRuntimeException);
    }

    public ByteBuffer serialize() throws IOException {
        PublicBAOS byteArrayOutputStream = new PublicBAOS();
        DataOutputStream outputStream = new DataOutputStream(byteArrayOutputStream);
        this.serialize(outputStream);
        return ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
    }

    public void serialize(OutputStream outputStream) throws IOException {
        PipeRuntimeMetaVersion.VERSION_2.serialize(outputStream);
        ReadWriteIOUtils.write(this.status.get().getType(), outputStream);
        HashMap<Integer, PipeTaskMeta> consensusGroupId2TaskMetaMapView = new HashMap<Integer, PipeTaskMeta>(this.consensusGroupId2TaskMetaMap);
        ReadWriteIOUtils.write(consensusGroupId2TaskMetaMapView.size(), outputStream);
        for (Map.Entry entry : consensusGroupId2TaskMetaMapView.entrySet()) {
            ReadWriteIOUtils.write((int)((Integer)entry.getKey()), outputStream);
            ((PipeTaskMeta)entry.getValue()).serialize(outputStream);
        }
        HashMap<Integer, PipeRuntimeException> dataNodeId2PipeRuntimeExceptionMapView = new HashMap<Integer, PipeRuntimeException>(this.nodeId2PipeRuntimeExceptionMap);
        ReadWriteIOUtils.write(dataNodeId2PipeRuntimeExceptionMapView.size(), outputStream);
        for (Map.Entry entry : dataNodeId2PipeRuntimeExceptionMapView.entrySet()) {
            ReadWriteIOUtils.write((int)((Integer)entry.getKey()), outputStream);
            ((PipeRuntimeException)entry.getValue()).serialize(outputStream);
        }
        ReadWriteIOUtils.write(this.exceptionsClearTime.get(), outputStream);
        ReadWriteIOUtils.write((Boolean)this.isStoppedByRuntimeException.get(), outputStream);
    }

    public static PipeRuntimeMeta deserialize(InputStream inputStream) throws IOException {
        byte pipeRuntimeVersionByte = ReadWriteIOUtils.readByte(inputStream);
        PipeRuntimeMetaVersion pipeRuntimeMetaVersion = PipeRuntimeMetaVersion.deserialize(pipeRuntimeVersionByte);
        switch (pipeRuntimeMetaVersion) {
            case VERSION_1: {
                return PipeRuntimeMeta.deserializeVersion1(inputStream, pipeRuntimeVersionByte);
            }
            case VERSION_2: {
                return PipeRuntimeMeta.deserializeVersion2(inputStream);
            }
        }
        throw new UnsupportedOperationException("Unknown pipe runtime meta version: " + pipeRuntimeMetaVersion.getVersion());
    }

    private static PipeRuntimeMeta deserializeVersion1(InputStream inputStream, byte pipeStatusByte) throws IOException {
        PipeRuntimeMeta pipeRuntimeMeta = new PipeRuntimeMeta();
        pipeRuntimeMeta.status.set(PipeStatus.getPipeStatus(pipeStatusByte));
        int size = ReadWriteIOUtils.readInt(inputStream);
        for (int i = 0; i < size; ++i) {
            pipeRuntimeMeta.consensusGroupId2TaskMetaMap.put(ReadWriteIOUtils.readInt(inputStream), PipeTaskMeta.deserialize(PipeRuntimeMetaVersion.VERSION_1, inputStream));
        }
        return pipeRuntimeMeta;
    }

    private static PipeRuntimeMeta deserializeVersion2(InputStream inputStream) throws IOException {
        int i;
        PipeRuntimeMeta pipeRuntimeMeta = new PipeRuntimeMeta();
        pipeRuntimeMeta.status.set(PipeStatus.getPipeStatus(ReadWriteIOUtils.readByte(inputStream)));
        int size = ReadWriteIOUtils.readInt(inputStream);
        for (i = 0; i < size; ++i) {
            pipeRuntimeMeta.consensusGroupId2TaskMetaMap.put(ReadWriteIOUtils.readInt(inputStream), PipeTaskMeta.deserialize(PipeRuntimeMetaVersion.VERSION_2, inputStream));
        }
        size = ReadWriteIOUtils.readInt(inputStream);
        for (i = 0; i < size; ++i) {
            pipeRuntimeMeta.nodeId2PipeRuntimeExceptionMap.put(ReadWriteIOUtils.readInt(inputStream), PipeRuntimeExceptionType.deserializeFrom(PipeRuntimeMetaVersion.VERSION_2, inputStream));
        }
        pipeRuntimeMeta.exceptionsClearTime.set(ReadWriteIOUtils.readLong(inputStream));
        pipeRuntimeMeta.isStoppedByRuntimeException.set(ReadWriteIOUtils.readBool(inputStream));
        return pipeRuntimeMeta;
    }

    public static PipeRuntimeMeta deserialize(ByteBuffer byteBuffer) {
        byte pipeRuntimeVersionByte = ReadWriteIOUtils.readByte(byteBuffer);
        PipeRuntimeMetaVersion pipeRuntimeMetaVersion = PipeRuntimeMetaVersion.deserialize(pipeRuntimeVersionByte);
        switch (pipeRuntimeMetaVersion) {
            case VERSION_1: {
                return PipeRuntimeMeta.deserializeVersion1(byteBuffer, pipeRuntimeVersionByte);
            }
            case VERSION_2: {
                return PipeRuntimeMeta.deserializeVersion2(byteBuffer);
            }
        }
        throw new UnsupportedOperationException("Unknown pipe runtime meta version: " + pipeRuntimeMetaVersion.getVersion());
    }

    private static PipeRuntimeMeta deserializeVersion1(ByteBuffer byteBuffer, byte pipeRuntimeVersionByte) {
        PipeRuntimeMeta pipeRuntimeMeta = new PipeRuntimeMeta();
        pipeRuntimeMeta.status.set(PipeStatus.getPipeStatus(pipeRuntimeVersionByte));
        int size = ReadWriteIOUtils.readInt(byteBuffer);
        for (int i = 0; i < size; ++i) {
            pipeRuntimeMeta.consensusGroupId2TaskMetaMap.put(ReadWriteIOUtils.readInt(byteBuffer), PipeTaskMeta.deserialize(PipeRuntimeMetaVersion.VERSION_1, byteBuffer));
        }
        return pipeRuntimeMeta;
    }

    public static PipeRuntimeMeta deserializeVersion2(ByteBuffer byteBuffer) {
        int i;
        PipeRuntimeMeta pipeRuntimeMeta = new PipeRuntimeMeta();
        pipeRuntimeMeta.status.set(PipeStatus.getPipeStatus(ReadWriteIOUtils.readByte(byteBuffer)));
        int size = ReadWriteIOUtils.readInt(byteBuffer);
        for (i = 0; i < size; ++i) {
            pipeRuntimeMeta.consensusGroupId2TaskMetaMap.put(ReadWriteIOUtils.readInt(byteBuffer), PipeTaskMeta.deserialize(PipeRuntimeMetaVersion.VERSION_2, byteBuffer));
        }
        size = ReadWriteIOUtils.readInt(byteBuffer);
        for (i = 0; i < size; ++i) {
            pipeRuntimeMeta.nodeId2PipeRuntimeExceptionMap.put(ReadWriteIOUtils.readInt(byteBuffer), PipeRuntimeExceptionType.deserializeFrom(PipeRuntimeMetaVersion.VERSION_2, byteBuffer));
        }
        pipeRuntimeMeta.exceptionsClearTime.set(ReadWriteIOUtils.readLong(byteBuffer));
        pipeRuntimeMeta.isStoppedByRuntimeException.set(ReadWriteIOUtils.readBool(byteBuffer));
        return pipeRuntimeMeta;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PipeRuntimeMeta that = (PipeRuntimeMeta)o;
        return Objects.equals(this.status.get().getType(), that.status.get().getType()) && this.consensusGroupId2TaskMetaMap.equals(that.consensusGroupId2TaskMetaMap) && this.nodeId2PipeRuntimeExceptionMap.equals(that.nodeId2PipeRuntimeExceptionMap) && this.exceptionsClearTime.get() == that.exceptionsClearTime.get() && this.isStoppedByRuntimeException.get() == that.isStoppedByRuntimeException.get();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status.get(), this.consensusGroupId2TaskMetaMap, this.nodeId2PipeRuntimeExceptionMap, this.exceptionsClearTime.get(), this.isStoppedByRuntimeException.get()});
    }

    public String toString() {
        return "PipeRuntimeMeta{status=" + (Object)((Object)this.status.get()) + ", consensusGroupId2TaskMetaMap=" + this.consensusGroupId2TaskMetaMap + ", nodeId2PipeRuntimeExceptionMap=" + this.nodeId2PipeRuntimeExceptionMap + ", exceptionsClearTime=" + this.exceptionsClearTime.get() + ", isStoppedByRuntimeException=" + this.isStoppedByRuntimeException.get() + "}";
    }
}

