/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.plugin.builtin.processor.throwing;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iotdb.pipe.api.PipeProcessor;
import org.apache.iotdb.pipe.api.collector.EventCollector;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeProcessorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.event.dml.insertion.TsFileInsertionEvent;

public class ThrowingExceptionProcessor
implements PipeProcessor {
    private boolean throwInCustomize = false;
    private boolean throwInProcessTabletInsertionEvent = false;
    private boolean throwInProcessTsFileInsertionEvent = false;
    private boolean throwInProcessEvent = false;
    private boolean throwInClose = false;

    @Override
    public void validate(PipeParameterValidator validator) throws Exception {
        Set throwingStages = Arrays.stream(validator.getParameters().getStringOrDefault("stages", "").toLowerCase().split(",")).collect(Collectors.toSet());
        boolean throwInValidate = throwingStages.contains("validate");
        if (throwInValidate) {
            throw new Exception("Throwing exception in validate");
        }
        this.throwInCustomize = throwingStages.contains("customize");
        this.throwInProcessTabletInsertionEvent = throwingStages.contains("process-tablet-insertion-event");
        this.throwInProcessTsFileInsertionEvent = throwingStages.contains("process-tsfile-insertion-event");
        this.throwInProcessEvent = throwingStages.contains("process-event");
        this.throwInClose = throwingStages.contains("close");
    }

    @Override
    public void customize(PipeParameters parameters, PipeProcessorRuntimeConfiguration configuration) throws Exception {
        if (this.throwInCustomize) {
            throw new Exception("Throwing exception in customize");
        }
    }

    @Override
    public void process(TabletInsertionEvent tabletInsertionEvent, EventCollector eventCollector) throws Exception {
        if (this.throwInProcessTabletInsertionEvent) {
            throw new Exception("Throwing exception in process(TabletInsertionEvent, EventCollector)");
        }
    }

    @Override
    public void process(TsFileInsertionEvent tsFileInsertionEvent, EventCollector eventCollector) throws Exception {
        if (this.throwInProcessTsFileInsertionEvent) {
            throw new Exception("Throwing exception in process(TsFileInsertionEvent, EventCollector)");
        }
    }

    @Override
    public void process(Event event, EventCollector eventCollector) throws Exception {
        if (this.throwInProcessEvent) {
            throw new Exception("Throwing exception in process(Event, EventCollector)");
        }
    }

    @Override
    public void close() throws Exception {
        if (this.throwInClose) {
            throw new Exception("Throwing exception in close");
        }
    }
}

