/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.event;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.MinimumProgressIndex;
import org.apache.iotdb.commons.pipe.pattern.PipePattern;
import org.apache.iotdb.commons.pipe.progress.PipeEventCommitManager;
import org.apache.iotdb.commons.pipe.task.meta.PipeTaskMeta;
import org.apache.iotdb.pipe.api.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EnrichedEvent
implements Event {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnrichedEvent.class);
    protected final AtomicInteger referenceCount = new AtomicInteger(0);
    protected final AtomicBoolean isReleased = new AtomicBoolean(false);
    protected final String pipeName;
    protected final PipeTaskMeta pipeTaskMeta;
    protected String committerKey;
    public static final long NO_COMMIT_ID = -1L;
    protected long commitId = -1L;
    protected final PipePattern pipePattern;
    protected final long startTime;
    protected final long endTime;
    protected boolean isPatternParsed;
    protected boolean isTimeParsed;
    protected boolean shouldReportOnCommit = true;

    protected EnrichedEvent(String pipeName, PipeTaskMeta pipeTaskMeta, PipePattern pipePattern, long startTime, long endTime) {
        this.pipeName = pipeName;
        this.pipeTaskMeta = pipeTaskMeta;
        this.pipePattern = pipePattern;
        this.startTime = startTime;
        this.endTime = endTime;
        this.isPatternParsed = this.pipePattern == null || this.pipePattern.isRoot();
        this.isTimeParsed = Long.MIN_VALUE == startTime && Long.MAX_VALUE == endTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean increaseReferenceCount(String holderMessage) {
        boolean isSuccessful = true;
        EnrichedEvent enrichedEvent = this;
        synchronized (enrichedEvent) {
            if (this.isReleased.get()) {
                LOGGER.warn("re-increase reference count to event that has already been released: {}, stack trace: {}", (Object)this.coreReportMessage(), (Object)Thread.currentThread().getStackTrace());
                isSuccessful = false;
                this.referenceCount.incrementAndGet();
            } else {
                if (this.referenceCount.get() == 0) {
                    isSuccessful = this.internallyIncreaseResourceReferenceCount(holderMessage);
                }
                this.referenceCount.incrementAndGet();
            }
        }
        if (!isSuccessful) {
            LOGGER.warn("increase reference count failed, EnrichedEvent: {}", (Object)this.coreReportMessage());
        }
        return isSuccessful;
    }

    public abstract boolean internallyIncreaseResourceReferenceCount(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean decreaseReferenceCount(String holderMessage, boolean shouldReport) {
        boolean isSuccessful = true;
        EnrichedEvent enrichedEvent = this;
        synchronized (enrichedEvent) {
            int newReferenceCount;
            if (this.referenceCount.get() == 1 && !this.isReleased.get()) {
                isSuccessful = this.internallyDecreaseResourceReferenceCount(holderMessage);
                if (!shouldReport) {
                    this.shouldReportOnCommit = false;
                }
                PipeEventCommitManager.getInstance().commit(this, this.committerKey);
            }
            if ((newReferenceCount = this.referenceCount.decrementAndGet()) == 0) {
                this.isReleased.set(true);
            }
            if (newReferenceCount < 0) {
                LOGGER.warn("reference count is decreased to {}, event: {}, stack trace: {}", newReferenceCount, this.coreReportMessage(), Thread.currentThread().getStackTrace());
            }
        }
        if (!isSuccessful) {
            LOGGER.warn("decrease reference count failed, EnrichedEvent: {}", (Object)this.coreReportMessage());
        }
        return isSuccessful;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean clearReferenceCount(String holderMessage) {
        boolean isSuccessful = true;
        EnrichedEvent enrichedEvent = this;
        synchronized (enrichedEvent) {
            if (this.referenceCount.get() >= 1 && !this.isReleased.get()) {
                isSuccessful = this.internallyDecreaseResourceReferenceCount(holderMessage);
                this.isReleased.set(true);
            }
            this.referenceCount.set(0);
        }
        if (!isSuccessful) {
            LOGGER.warn("clear reference count failed, EnrichedEvent: {}", (Object)this.coreReportMessage());
        }
        return isSuccessful;
    }

    public abstract boolean internallyDecreaseResourceReferenceCount(String var1);

    protected void reportProgress() {
        if (this.pipeTaskMeta != null) {
            ProgressIndex progressIndex = this.getProgressIndex();
            this.pipeTaskMeta.updateProgressIndex(progressIndex == null ? MinimumProgressIndex.INSTANCE : progressIndex);
        }
    }

    public void skipReportOnCommit() {
        this.shouldReportOnCommit = false;
    }

    public void bindProgressIndex(ProgressIndex progressIndex) {
        throw new UnsupportedOperationException("This event does not support binding progressIndex.");
    }

    public abstract ProgressIndex getProgressIndex();

    public int getReferenceCount() {
        return this.referenceCount.get();
    }

    public final String getPipeName() {
        return this.pipeName;
    }

    public final String getPatternString() {
        return this.pipePattern != null ? this.pipePattern.getPattern() : null;
    }

    public final PipePattern getPipePattern() {
        return this.pipePattern;
    }

    public final long getStartTime() {
        return this.startTime;
    }

    public final long getEndTime() {
        return this.endTime;
    }

    public void skipParsingPattern() {
        this.isPatternParsed = true;
    }

    public void skipParsingTime() {
        this.isTimeParsed = true;
    }

    public boolean shouldParseTimeOrPattern() {
        return this.shouldParseTime() || this.shouldParsePattern();
    }

    public boolean shouldParsePattern() {
        return !this.isPatternParsed;
    }

    public boolean shouldParseTime() {
        return !this.isTimeParsed;
    }

    public abstract EnrichedEvent shallowCopySelfAndBindPipeTaskMetaForProgressReport(String var1, PipeTaskMeta var2, PipePattern var3, long var4, long var6);

    public PipeTaskMeta getPipeTaskMeta() {
        return this.pipeTaskMeta;
    }

    public abstract boolean isGeneratedByPipe();

    public boolean needToCommit() {
        return true;
    }

    public abstract boolean mayEventTimeOverlappedWithTimeRange();

    public void setCommitterKeyAndCommitId(String committerKey, long commitId) {
        this.committerKey = committerKey;
        this.commitId = commitId;
    }

    public String getCommitterKey() {
        return this.committerKey;
    }

    public long getCommitId() {
        return this.commitId;
    }

    public void onCommitted() {
        if (this.shouldReportOnCommit) {
            this.reportProgress();
        }
    }

    public boolean isReleased() {
        return this.isReleased.get();
    }

    public String toString() {
        return "EnrichedEvent{referenceCount=" + this.referenceCount.get() + ", isReleased=" + this.isReleased.get() + ", pipeName='" + this.pipeName + "', pipeTaskMeta=" + this.pipeTaskMeta + ", committerKey='" + this.committerKey + "', commitId=" + this.commitId + ", pattern='" + this.pipePattern + "', startTime=" + this.startTime + ", endTime=" + this.endTime + ", isPatternParsed=" + this.isPatternParsed + ", isTimeParsed=" + this.isTimeParsed + ", shouldReportOnCommit=" + this.shouldReportOnCommit + '}';
    }

    public String coreReportMessage() {
        return "EnrichedEvent{referenceCount=" + this.referenceCount.get() + ", isReleased=" + this.isReleased.get() + ", pipeName='" + this.pipeName + "', committerKey='" + this.committerKey + "', commitId=" + this.commitId + ", pattern='" + this.pipePattern + "', startTime=" + this.startTime + ", endTime=" + this.endTime + ", isPatternParsed=" + this.isPatternParsed + ", isTimeParsed=" + this.isTimeParsed + ", shouldReportOnCommit=" + this.shouldReportOnCommit + '}';
    }
}

