/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.connector.protocol;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.commons.pipe.connector.client.IoTDBSyncClient;
import org.apache.iotdb.commons.pipe.connector.client.IoTDBSyncClientManager;
import org.apache.iotdb.commons.pipe.connector.payload.thrift.request.PipeTransferFilePieceReq;
import org.apache.iotdb.commons.pipe.connector.payload.thrift.response.PipeTransferFilePieceResp;
import org.apache.iotdb.commons.pipe.connector.protocol.IoTDBConnector;
import org.apache.iotdb.commons.pipe.plugin.builtin.BuiltinPipePlugin;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeConnectorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.exception.PipeConnectionException;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IoTDBSslSyncConnector
extends IoTDBConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTDBSslSyncConnector.class);
    protected IoTDBSyncClientManager clientManager;

    @Override
    public void validate(PipeParameterValidator validator) throws Exception {
        super.validate(validator);
        PipeParameters parameters = validator.getParameters();
        String userSpecifiedConnectorName = parameters.getStringOrDefault(ImmutableList.of("connector", "sink"), BuiltinPipePlugin.IOTDB_THRIFT_CONNECTOR.getPipePluginName()).toLowerCase();
        validator.validate(args -> (Boolean)args[0] == false || (Boolean)args[1] != false && (Boolean)args[2] != false, String.format("When ssl transport is enabled, %s and %s must be specified", "sink.ssl.trust-store-path", "sink.ssl.trust-store-pwd"), BuiltinPipePlugin.IOTDB_THRIFT_SSL_CONNECTOR.getPipePluginName().equals(userSpecifiedConnectorName) || BuiltinPipePlugin.IOTDB_THRIFT_SSL_SINK.getPipePluginName().equals(userSpecifiedConnectorName) || parameters.getBooleanOrDefault("sink.ssl.enable", false), parameters.hasAttribute("sink.ssl.trust-store-path"), parameters.hasAttribute("sink.ssl.trust-store-pwd"));
    }

    @Override
    public void customize(PipeParameters parameters, PipeConnectorRuntimeConfiguration configuration) throws Exception {
        super.customize(parameters, configuration);
        String userSpecifiedConnectorName = parameters.getStringOrDefault(ImmutableList.of("connector", "sink"), BuiltinPipePlugin.IOTDB_THRIFT_CONNECTOR.getPipePluginName()).toLowerCase();
        boolean useSSL = BuiltinPipePlugin.IOTDB_THRIFT_SSL_CONNECTOR.getPipePluginName().equals(userSpecifiedConnectorName) || BuiltinPipePlugin.IOTDB_THRIFT_SSL_SINK.getPipePluginName().equals(userSpecifiedConnectorName) || parameters.getBooleanOrDefault("sink.ssl.enable", false);
        String trustStorePath = parameters.getString("sink.ssl.trust-store-path");
        String trustStorePwd = parameters.getString("sink.ssl.trust-store-pwd");
        boolean useLeaderCache = parameters.getBooleanOrDefault(Arrays.asList("sink.leader-cache.enable", "connector.leader-cache.enable"), true);
        this.clientManager = this.constructClient(this.nodeUrls, useSSL, trustStorePath, trustStorePwd, useLeaderCache, this.loadBalanceStrategy);
    }

    protected abstract IoTDBSyncClientManager constructClient(List<TEndPoint> var1, boolean var2, String var3, String var4, boolean var5, String var6);

    @Override
    public void handshake() throws Exception {
        this.clientManager.checkClientStatusAndTryReconstructIfNecessary();
    }

    @Override
    public void heartbeat() {
        try {
            this.handshake();
        }
        catch (Exception e) {
            LOGGER.warn("Failed to reconnect to target server, because: {}. Try to reconnect later.", (Object)e.getMessage(), (Object)e);
        }
    }

    protected void transferFilePieces(File file, Pair<IoTDBSyncClient, Boolean> clientAndStatus, boolean isMultiFile) throws PipeException, IOException {
        int readFileBufferSize = PipeConfig.getInstance().getPipeConnectorReadFileBufferSize();
        byte[] readBuffer = new byte[readFileBufferSize];
        long position = 0L;
        try (RandomAccessFile reader = new RandomAccessFile(file, "r");){
            int readLength;
            while ((readLength = reader.read(readBuffer)) != -1) {
                PipeTransferFilePieceResp resp;
                byte[] payLoad = readLength == readFileBufferSize ? readBuffer : Arrays.copyOfRange(readBuffer, 0, readLength);
                try {
                    resp = PipeTransferFilePieceResp.fromTPipeTransferResp(clientAndStatus.getLeft().pipeTransfer(isMultiFile ? this.getTransferMultiFilePieceReq(file.getName(), position, payLoad) : this.getTransferSingleFilePieceReq(file.getName(), position, payLoad)));
                }
                catch (Exception e) {
                    clientAndStatus.setRight(false);
                    throw new PipeConnectionException(String.format("Network error when transfer file %s, because %s.", file, e.getMessage()), e);
                }
                position += (long)readLength;
                TSStatus status = resp.getStatus();
                if (status.getCode() == TSStatusCode.PIPE_TRANSFER_FILE_OFFSET_RESET.getStatusCode()) {
                    position = resp.getEndWritingOffset();
                    reader.seek(position);
                    LOGGER.info("Redirect file position to {}.", (Object)position);
                    continue;
                }
                if (status.getCode() == TSStatusCode.PIPE_CONFIG_RECEIVER_HANDSHAKE_NEEDED.getStatusCode()) {
                    this.clientManager.sendHandshakeReq(clientAndStatus);
                }
                if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() || status.getCode() == TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()) continue;
                this.receiverStatusHandler.handle(resp.getStatus(), String.format("Transfer file %s error, result status %s.", file, resp.getStatus()), file.getName());
            }
        }
    }

    protected abstract PipeTransferFilePieceReq getTransferSingleFilePieceReq(String var1, long var2, byte[] var4) throws IOException;

    protected abstract PipeTransferFilePieceReq getTransferMultiFilePieceReq(String var1, long var2, byte[] var4) throws IOException;

    @Override
    public void close() {
        if (this.clientManager != null) {
            this.clientManager.close();
        }
    }
}

