/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.connector.payload.thrift.request;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import org.apache.iotdb.commons.pipe.connector.payload.thrift.request.IoTDBConnectorRequestVersion;
import org.apache.iotdb.commons.pipe.connector.payload.thrift.request.PipeRequestType;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public abstract class PipeTransferFilePieceReq
extends TPipeTransferReq {
    private transient String fileName;
    private transient long startWritingOffset;
    private transient byte[] filePiece;

    public final String getFileName() {
        return this.fileName;
    }

    public final long getStartWritingOffset() {
        return this.startWritingOffset;
    }

    public final byte[] getFilePiece() {
        return this.filePiece;
    }

    protected abstract PipeRequestType getPlanType();

    protected final PipeTransferFilePieceReq convertToTPipeTransferReq(String snapshotName, long startWritingOffset, byte[] snapshotPiece) throws IOException {
        this.fileName = snapshotName;
        this.startWritingOffset = startWritingOffset;
        this.filePiece = snapshotPiece;
        this.version = IoTDBConnectorRequestVersion.VERSION_1.getVersion();
        this.type = this.getPlanType().getType();
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();
             DataOutputStream outputStream = new DataOutputStream(byteArrayOutputStream);){
            ReadWriteIOUtils.write(snapshotName, (OutputStream)outputStream);
            ReadWriteIOUtils.write(startWritingOffset, (OutputStream)outputStream);
            ReadWriteIOUtils.write(new Binary(snapshotPiece), (OutputStream)outputStream);
            this.body = ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
        }
        return this;
    }

    protected final PipeTransferFilePieceReq translateFromTPipeTransferReq(TPipeTransferReq transferReq) {
        this.fileName = ReadWriteIOUtils.readString(transferReq.body);
        this.startWritingOffset = ReadWriteIOUtils.readLong(transferReq.body);
        this.filePiece = ReadWriteIOUtils.readBinary(transferReq.body).getValues();
        this.version = transferReq.version;
        this.type = transferReq.type;
        this.body = transferReq.body;
        return this;
    }

    protected final byte[] convertToTPipeTransferBytes(String snapshotName, long startWritingOffset, byte[] snapshotPiece) throws IOException {
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();){
            byte[] byArray;
            try (DataOutputStream outputStream = new DataOutputStream(byteArrayOutputStream);){
                ReadWriteIOUtils.write(IoTDBConnectorRequestVersion.VERSION_1.getVersion(), (OutputStream)outputStream);
                ReadWriteIOUtils.write(this.getPlanType().getType(), (OutputStream)outputStream);
                ReadWriteIOUtils.write(snapshotName, (OutputStream)outputStream);
                ReadWriteIOUtils.write(startWritingOffset, (OutputStream)outputStream);
                ReadWriteIOUtils.write(new Binary(snapshotPiece), (OutputStream)outputStream);
                byArray = byteArrayOutputStream.toByteArray();
            }
            return byArray;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PipeTransferFilePieceReq that = (PipeTransferFilePieceReq)obj;
        return this.fileName.equals(that.fileName) && this.startWritingOffset == that.startWritingOffset && Arrays.equals(this.filePiece, that.filePiece) && this.version == that.version && this.type == that.type && this.body.equals(that.body);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fileName, this.startWritingOffset, Arrays.hashCode(this.filePiece), this.version, this.type, this.body);
    }
}

