/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.connector.client;

import org.apache.iotdb.commons.client.ThriftClient;
import org.apache.iotdb.commons.client.property.ThriftClientProperty;
import org.apache.iotdb.rpc.DeepCopyRpcTransportFactory;
import org.apache.iotdb.rpc.TimeoutChangeableTransport;
import org.apache.iotdb.service.rpc.thrift.IClientRPCService;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class IoTDBSyncClient
extends IClientRPCService.Client
implements ThriftClient,
AutoCloseable {
    private final String ipAddress;
    private final int port;

    public IoTDBSyncClient(ThriftClientProperty property, String ipAddress, int port, boolean useSSL, String trustStore, String trustStorePwd) throws TTransportException {
        super(property.getProtocolFactory().getProtocol(useSSL ? DeepCopyRpcTransportFactory.INSTANCE.getTransport(ipAddress, port, property.getConnectionTimeoutMs(), trustStore, trustStorePwd) : DeepCopyRpcTransportFactory.INSTANCE.getTransport(ipAddress, port, property.getConnectionTimeoutMs())));
        this.ipAddress = ipAddress;
        this.port = port;
        TTransport transport = this.getInputProtocol().getTransport();
        if (!transport.isOpen()) {
            transport.open();
        }
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public int getPort() {
        return this.port;
    }

    public void setTimeout(int timeout) {
        ((TimeoutChangeableTransport)((Object)this.getInputProtocol().getTransport())).setTimeout(timeout);
    }

    @Override
    public void close() throws Exception {
        this.invalidate();
    }

    @Override
    public void invalidate() {
        if (this.getInputProtocol().getTransport().isOpen()) {
            this.getInputProtocol().getTransport().close();
        }
    }

    @Override
    public void invalidateAll() {
        this.invalidate();
    }

    @Override
    public boolean printLogWhenEncounterException() {
        return true;
    }
}

