/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.agent.plugin;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.iotdb.commons.pipe.plugin.meta.PipePluginMeta;
import org.apache.iotdb.commons.pipe.plugin.meta.PipePluginMetaKeeper;
import org.apache.iotdb.pipe.api.PipePlugin;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PipePluginConstructor {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipePluginConstructor.class);
    private final PipePluginMetaKeeper pluginMetaKeeper;
    protected final Map<String, Supplier<PipePlugin>> pluginConstructors = new HashMap<String, Supplier<PipePlugin>>();

    protected PipePluginConstructor(PipePluginMetaKeeper pluginMetaKeeper) {
        this.pluginMetaKeeper = pluginMetaKeeper;
        this.initConstructors();
    }

    protected PipePluginConstructor() {
        this(null);
    }

    protected abstract void initConstructors();

    public abstract PipePlugin reflectPlugin(PipeParameters var1);

    public PipePlugin reflectPluginByKey(String pluginKey) {
        return this.pluginConstructors.getOrDefault(pluginKey, () -> this.reflect(pluginKey)).get();
    }

    private PipePlugin reflect(String pluginName) {
        if (this.pluginMetaKeeper == null) {
            throw new PipeException("Failed to reflect PipePlugin instance, because PipePluginMetaKeeper is null.");
        }
        if (pluginName == null) {
            throw new PipeException("Failed to reflect PipePlugin instance, because plugin name is null.");
        }
        PipePluginMeta information = this.pluginMetaKeeper.getPipePluginMeta(pluginName);
        if (information == null) {
            String errorMessage = String.format("Failed to reflect PipePlugin instance, because PipePlugin %s has not been registered.", pluginName.toUpperCase());
            LOGGER.warn(errorMessage);
            throw new PipeException(errorMessage);
        }
        try {
            return (PipePlugin)this.pluginMetaKeeper.getPluginClass(pluginName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            String errorMessage = String.format("Failed to reflect PipePlugin %s(%s) instance, because %s", pluginName, information.getClassName(), e);
            LOGGER.warn(errorMessage, e);
            throw new PipeException(errorMessage);
        }
    }
}

