/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.consensus.index.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.ProgressIndexType;
import org.apache.iotdb.commons.consensus.index.impl.HybridProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.MinimumProgressIndex;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class MetaProgressIndex
extends ProgressIndex {
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private long index;

    public MetaProgressIndex(long index) {
        this.index = index;
    }

    private MetaProgressIndex() {
    }

    public long getIndex() {
        return this.index;
    }

    @Override
    public void serialize(ByteBuffer byteBuffer) {
        this.lock.readLock().lock();
        try {
            ProgressIndexType.META_PROGRESS_INDEX.serialize(byteBuffer);
            ReadWriteIOUtils.write(this.index, byteBuffer);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void serialize(OutputStream stream) throws IOException {
        this.lock.readLock().lock();
        try {
            ProgressIndexType.META_PROGRESS_INDEX.serialize(stream);
            ReadWriteIOUtils.write(this.index, stream);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAfter(@Nonnull ProgressIndex progressIndex) {
        this.lock.readLock().lock();
        try {
            if (progressIndex instanceof MinimumProgressIndex) {
                boolean bl = true;
                return bl;
            }
            if (progressIndex instanceof HybridProgressIndex) {
                boolean bl = ((HybridProgressIndex)progressIndex).isGivenProgressIndexAfterSelf(this);
                return bl;
            }
            if (!(progressIndex instanceof MetaProgressIndex)) {
                boolean bl = false;
                return bl;
            }
            MetaProgressIndex thisMetaProgressIndex = this;
            MetaProgressIndex thatMetaProgressIndex = (MetaProgressIndex)progressIndex;
            boolean bl = thatMetaProgressIndex.index < thisMetaProgressIndex.index;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(ProgressIndex progressIndex) {
        this.lock.readLock().lock();
        try {
            if (!(progressIndex instanceof MetaProgressIndex)) {
                boolean bl = false;
                return bl;
            }
            MetaProgressIndex thisMetaProgressIndex = this;
            MetaProgressIndex thatMetaProgressIndex = (MetaProgressIndex)progressIndex;
            boolean bl = thisMetaProgressIndex.index == thatMetaProgressIndex.index;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MetaProgressIndex)) {
            return false;
        }
        return this.equals((MetaProgressIndex)obj);
    }

    public int hashCode() {
        return 0;
    }

    @Override
    public ProgressIndex updateToMinimumEqualOrIsAfterProgressIndex(ProgressIndex progressIndex) {
        this.lock.writeLock().lock();
        try {
            if (!(progressIndex instanceof MetaProgressIndex)) {
                ProgressIndex progressIndex2 = ProgressIndex.blendProgressIndex(this, progressIndex);
                return progressIndex2;
            }
            this.index = Math.max(this.index, ((MetaProgressIndex)progressIndex).index);
            MetaProgressIndex metaProgressIndex = this;
            return metaProgressIndex;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public ProgressIndexType getType() {
        return ProgressIndexType.META_PROGRESS_INDEX;
    }

    @Override
    public ProgressIndex.TotalOrderSumTuple getTotalOrderSumTuple() {
        this.lock.readLock().lock();
        try {
            ProgressIndex.TotalOrderSumTuple totalOrderSumTuple = new ProgressIndex.TotalOrderSumTuple(this.index);
            return totalOrderSumTuple;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public static MetaProgressIndex deserializeFrom(ByteBuffer byteBuffer) {
        MetaProgressIndex metaProgressIndex = new MetaProgressIndex();
        metaProgressIndex.index = ReadWriteIOUtils.readLong(byteBuffer);
        return metaProgressIndex;
    }

    public static MetaProgressIndex deserializeFrom(InputStream stream) throws IOException {
        MetaProgressIndex metaProgressIndex = new MetaProgressIndex();
        metaProgressIndex.index = ReadWriteIOUtils.readLong(stream);
        return metaProgressIndex;
    }

    public String toString() {
        return "MetaProgressIndex{index=" + this.index + '}';
    }
}

