/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.trigger.executor;

import org.apache.iotdb.commons.trigger.TriggerInformation;
import org.apache.iotdb.commons.trigger.exception.TriggerExecutionException;
import org.apache.iotdb.trigger.api.Trigger;
import org.apache.iotdb.trigger.api.TriggerAttributes;
import org.apache.iotdb.trigger.api.enums.FailureStrategy;
import org.apache.iotdb.trigger.api.enums.TriggerEvent;
import org.apache.iotdb.tsfile.write.record.Tablet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriggerExecutor {
    private final TriggerInformation triggerInformation;
    private final Trigger trigger;
    private static final Logger LOGGER = LoggerFactory.getLogger(TriggerExecutor.class);

    public TriggerExecutor(TriggerInformation triggerInformation, Trigger trigger, boolean isRestoring) {
        this.triggerInformation = triggerInformation;
        this.trigger = trigger;
        this.onCreate();
        if (isRestoring && triggerInformation.isStateful()) {
            this.onRestore();
        }
    }

    private void onCreate() {
        try {
            TriggerAttributes attributes = new TriggerAttributes(this.triggerInformation.getAttributes());
            this.trigger.validate(attributes);
            this.trigger.onCreate(attributes);
        }
        catch (Exception e) {
            this.onTriggerExecutionError("validate/onCreate(TriggerAttributes)", e);
        }
    }

    public void onDrop() {
        try {
            this.trigger.onDrop();
        }
        catch (Exception e) {
            this.onTriggerExecutionError("drop", e);
        }
    }

    private void onRestore() {
        try {
            this.trigger.restore();
        }
        catch (Exception e) {
            this.onTriggerExecutionError("restore", e);
        }
    }

    public boolean fire(Tablet tablet, TriggerEvent event) throws TriggerExecutionException {
        if (event.equals((Object)this.triggerInformation.getEvent())) {
            try {
                return this.trigger.fire(tablet);
            }
            catch (Throwable t) {
                this.onTriggerExecutionError("fire(Tablet)", t);
            }
        } else {
            LOGGER.warn("Trigger {} was fired with wrong event {}", (Object)this.triggerInformation.getTriggerName(), (Object)this.triggerInformation.getEvent());
        }
        return true;
    }

    public FailureStrategy getFailureStrategy() {
        return this.trigger.getFailureStrategy();
    }

    private void onTriggerExecutionError(String methodName, Throwable t) throws TriggerExecutionException {
        String errorMessage = String.format("Error occurred during executing Trigger(%s)#%s: %s, please check whether the implementation of Trigger is correct according to the trigger-api description.", this.triggerInformation.getTriggerName(), methodName, System.lineSeparator()) + t;
        LOGGER.warn(errorMessage);
        throw new TriggerExecutionException(errorMessage);
    }

    public TriggerInformation getTriggerInformation() {
        return this.triggerInformation;
    }
}

