/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.snapshot;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.DiskSpaceInsufficientException;
import org.apache.iotdb.db.storageengine.StorageEngine;
import org.apache.iotdb.db.storageengine.dataregion.DataRegion;
import org.apache.iotdb.db.storageengine.dataregion.snapshot.SnapshotFileSet;
import org.apache.iotdb.db.storageengine.dataregion.snapshot.SnapshotLogAnalyzer;
import org.apache.iotdb.db.storageengine.rescon.disk.FolderManager;
import org.apache.iotdb.db.storageengine.rescon.disk.strategy.DirectoryStrategyType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotLoader {
    private Logger LOGGER = LoggerFactory.getLogger(SnapshotLoader.class);
    private String storageGroupName;
    private String snapshotPath;
    private String dataRegionId;
    private SnapshotLogAnalyzer logAnalyzer;

    public SnapshotLoader(String snapshotPath, String storageGroupName, String dataRegionId) {
        this.snapshotPath = snapshotPath;
        this.storageGroupName = storageGroupName;
        this.dataRegionId = dataRegionId;
    }

    private DataRegion loadSnapshot() {
        try {
            return new DataRegion(IoTDBDescriptor.getInstance().getConfig().getSystemDir() + File.separator + "databases" + File.separator + this.storageGroupName, this.dataRegionId, StorageEngine.getInstance().getFileFlushPolicy(), this.storageGroupName);
        }
        catch (Exception e) {
            this.LOGGER.error("Exception occurs while load snapshot from {}", (Object)this.snapshotPath, (Object)e);
            return null;
        }
    }

    private File getSnapshotLogFile() {
        File sourceDataDir = new File(this.snapshotPath);
        if (sourceDataDir.exists()) {
            Object[] files = sourceDataDir.listFiles((dir, name) -> name.equals("snapshot.log"));
            if (files == null || files.length == 0) {
                this.LOGGER.warn("Failed to find snapshot log file, cannot recover it");
            } else if (files.length > 1) {
                this.LOGGER.warn("Found more than one snapshot log file, cannot recover it. {}", (Object)Arrays.toString(files));
            } else {
                this.LOGGER.info("Reading snapshot log file {}", files[0]);
                return files[0];
            }
        }
        return null;
    }

    public DataRegion loadSnapshotForStateMachine() {
        this.LOGGER.info("Loading snapshot for {}-{}, source directory is {}", new Object[]{this.storageGroupName, this.dataRegionId, this.snapshotPath});
        File snapshotLogFile = this.getSnapshotLogFile();
        if (snapshotLogFile == null) {
            return this.loadSnapshotWithoutLog();
        }
        return this.loadSnapshotWithLog(snapshotLogFile);
    }

    private DataRegion loadSnapshotWithoutLog() {
        try {
            try {
                this.deleteAllFilesInDataDirs();
                this.LOGGER.info("Remove all data files in original data dir");
            }
            catch (IOException e) {
                this.LOGGER.error("Failed to remove origin data files", (Throwable)e);
                return null;
            }
            this.LOGGER.info("Moving snapshot file to data dirs");
            this.createLinksFromSnapshotDirToDataDirWithoutLog(new File(this.snapshotPath));
            return this.loadSnapshot();
        }
        catch (IOException | DiskSpaceInsufficientException e) {
            this.LOGGER.error("Exception occurs when loading snapshot for {}-{}", new Object[]{this.storageGroupName, this.dataRegionId, e});
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataRegion loadSnapshotWithLog(File logFile) {
        boolean snapshotComplete = false;
        try {
            this.logAnalyzer = new SnapshotLogAnalyzer(logFile);
            snapshotComplete = this.logAnalyzer.isSnapshotComplete();
        }
        catch (Exception e) {
            this.LOGGER.error("Exception occurs when reading snapshot file", (Throwable)e);
            return null;
        }
        if (!snapshotComplete) {
            this.LOGGER.error("This snapshot is not complete, cannot load it");
            return null;
        }
        try {
            this.deleteAllFilesInDataDirs();
            this.LOGGER.info("Remove all data files in original data dir");
            this.createLinksFromSnapshotDirToDataDirWithLog();
            DataRegion e = this.loadSnapshot();
            return e;
        }
        catch (IOException e) {
            this.LOGGER.error("Failed to remove origin data files", (Throwable)e);
            DataRegion dataRegion = null;
            return dataRegion;
        }
        finally {
            this.logAnalyzer.close();
        }
    }

    private void deleteAllFilesInDataDirs() throws IOException {
        String[] dataDirPaths = IoTDBDescriptor.getInstance().getConfig().getLocalDataDirs();
        ArrayList<File> timePartitions = new ArrayList<File>();
        for (String dataDirPath : dataDirPaths) {
            File[] files;
            File unseqDataDirForThisRegion;
            File[] files2;
            File seqDataDirForThisRegion = new File(dataDirPath + File.separator + "sequence" + File.separator + this.storageGroupName + File.separator + this.dataRegionId);
            if (seqDataDirForThisRegion.exists() && (files2 = seqDataDirForThisRegion.listFiles()) != null) {
                timePartitions.addAll(Arrays.asList(files2));
            }
            if (!(unseqDataDirForThisRegion = new File(dataDirPath + File.separator + "unsequence" + File.separator + this.storageGroupName + File.separator + this.dataRegionId)).exists() || (files = unseqDataDirForThisRegion.listFiles()) == null) continue;
            timePartitions.addAll(Arrays.asList(files));
        }
        try {
            for (File timePartition : timePartitions) {
                FileUtils.forceDelete((File)timePartition);
            }
        }
        catch (IOException e) {
            this.LOGGER.error("Exception occurs when deleting time partition directory for {}-{}", new Object[]{this.storageGroupName, this.dataRegionId, e});
            throw e;
        }
    }

    private void createLinksFromSnapshotDirToDataDirWithoutLog(File sourceDir) throws IOException, DiskSpaceInsufficientException {
        String targetSuffix;
        File[] files;
        File seqFileDir = new File(sourceDir, "sequence" + File.separator + this.storageGroupName + File.separator + this.dataRegionId);
        File unseqFileDir = new File(sourceDir, "unsequence" + File.separator + this.storageGroupName + File.separator + this.dataRegionId);
        if (!seqFileDir.exists() && !unseqFileDir.exists()) {
            throw new IOException(String.format("Cannot find %s or %s", seqFileDir.getAbsolutePath(), unseqFileDir.getAbsolutePath()));
        }
        FolderManager folderManager = new FolderManager(Arrays.asList(IoTDBDescriptor.getInstance().getConfig().getLocalDataDirs()), DirectoryStrategyType.SEQUENCE_STRATEGY);
        File[] timePartitionFolders = seqFileDir.listFiles();
        if (timePartitionFolders != null) {
            for (File timePartitionFolder : timePartitionFolders) {
                files = timePartitionFolder.listFiles();
                if (files == null || files.length == 0) continue;
                targetSuffix = "sequence" + File.separator + this.storageGroupName + File.separator + this.dataRegionId + File.separator + timePartitionFolder.getName();
                this.createLinksFromSnapshotToSourceDir(targetSuffix, files, folderManager);
            }
        }
        if ((timePartitionFolders = unseqFileDir.listFiles()) != null) {
            for (File timePartitionFolder : timePartitionFolders) {
                files = timePartitionFolder.listFiles();
                if (files == null || files.length == 0) continue;
                targetSuffix = "unsequence" + File.separator + this.storageGroupName + File.separator + this.dataRegionId + File.separator + timePartitionFolder.getName();
                this.createLinksFromSnapshotToSourceDir(targetSuffix, files, folderManager);
            }
        }
    }

    private void createLinksFromSnapshotToSourceDir(String targetSuffix, File[] files, FolderManager folderManager) throws DiskSpaceInsufficientException, IOException {
        HashMap<String, String> fileTarget = new HashMap<String, String>();
        for (File file : files) {
            String dataDir;
            String fileKey = file.getName().split("\\.")[0];
            if (fileTarget.containsKey(fileKey)) {
                dataDir = (String)fileTarget.get(fileKey);
            } else {
                dataDir = folderManager.getNextFolder();
                fileTarget.put(fileKey, dataDir);
            }
            File targetFile = new File(dataDir + File.separator + targetSuffix + File.separator + file.getName());
            if (!targetFile.getParentFile().exists() && !targetFile.getParentFile().mkdirs()) {
                throw new IOException(String.format("Cannot create directory %s", targetFile.getParentFile().getAbsolutePath()));
            }
            try {
                Files.createLink(targetFile.toPath(), file.toPath());
            }
            catch (IOException e) {
                this.LOGGER.info("Cannot create link from {} to {}, try to copy it", (Object)file, (Object)targetFile);
                Files.copy(file.toPath(), targetFile.toPath(), new CopyOption[0]);
            }
        }
    }

    private void createLinksFromSnapshotDirToDataDirWithLog() throws IOException {
        String snapshotId = this.logAnalyzer.getSnapshotId();
        int loggedFileNum = this.logAnalyzer.getTotalFileCountInSnapshot();
        Set<String> fileInfoSet = this.logAnalyzer.getFileInfoSet();
        String[] dataDirs = IoTDBDescriptor.getInstance().getConfig().getLocalDataDirs();
        int fileCnt = 0;
        for (String dataDir : dataDirs) {
            String snapshotDir = dataDir + File.separator + "snapshot" + File.separator + this.storageGroupName + "-" + this.dataRegionId + File.separator + snapshotId;
            fileCnt += this.takeHardLinksFromSnapshotToDataDir(dataDir, new File(snapshotDir), fileInfoSet);
        }
        if (fileCnt != loggedFileNum) {
            throw new IOException(String.format("The file num in log is %d, while file num in disk is %d", loggedFileNum, fileCnt));
        }
    }

    private int takeHardLinksFromSnapshotToDataDir(String dataDir, File snapshotFolder, Set<String> fileInfoSet) throws IOException {
        File unsequenceTimePartitionFolders;
        int cnt = 0;
        File sequenceTimePartitionFolders = new File(snapshotFolder.getAbsolutePath() + File.separator + "sequence" + File.separator + this.storageGroupName + File.separator + this.dataRegionId);
        File[] timePartitionFolders = sequenceTimePartitionFolders.listFiles();
        if (timePartitionFolders != null) {
            for (File timePartitionFolder : timePartitionFolders) {
                String timePartition = timePartitionFolder.getName();
                File[] sourceFiles = timePartitionFolder.listFiles();
                if (sourceFiles == null) continue;
                File targetDir = new File(dataDir + File.separator + "sequence" + File.separator + this.storageGroupName + File.separator + this.dataRegionId + File.separator + timePartition);
                this.createLinksFromSourceToTarget(targetDir, sourceFiles, fileInfoSet);
                cnt += sourceFiles.length;
            }
        }
        if ((timePartitionFolders = (unsequenceTimePartitionFolders = new File(snapshotFolder.getAbsolutePath() + File.separator + "unsequence" + File.separator + this.storageGroupName + File.separator + this.dataRegionId)).listFiles()) != null) {
            for (File timePartitionFolder : timePartitionFolders) {
                String timePartition = timePartitionFolder.getName();
                File[] sourceFiles = timePartitionFolder.listFiles();
                if (sourceFiles == null) continue;
                File targetDir = new File(dataDir + File.separator + "unsequence" + File.separator + this.storageGroupName + File.separator + this.dataRegionId + File.separator + timePartition);
                this.createLinksFromSourceToTarget(targetDir, sourceFiles, fileInfoSet);
                cnt += sourceFiles.length;
            }
        }
        return cnt;
    }

    private void createLinksFromSourceToTarget(File targetDir, File[] files, Set<String> fileInfoSet) throws IOException {
        for (File file : files) {
            String infoStr = this.getFileInfoString(file);
            if (!fileInfoSet.contains(infoStr)) {
                throw new IOException(String.format("File %s is not in the log file list", file.getAbsolutePath()));
            }
            File targetFile = new File(targetDir, file.getName());
            if (!targetFile.getParentFile().exists() && !targetFile.getParentFile().mkdirs()) {
                throw new IOException(String.format("Cannot create directory %s", targetFile.getParentFile().getAbsolutePath()));
            }
            Files.createLink(targetFile.toPath(), file.toPath());
        }
    }

    private String getFileInfoString(File file) {
        String[] splittedStr = file.getAbsolutePath().split(File.separator.equals("\\") ? "\\\\" : "/");
        int length = splittedStr.length;
        return splittedStr[length - 1] + " " + splittedStr[length - 2] + " " + splittedStr[length - 5];
    }

    public List<File> getSnapshotFileInfo() throws IOException {
        File snapshotLogFile = this.getSnapshotLogFile();
        if (snapshotLogFile == null) {
            return this.searchDataFilesRecursively(this.snapshotPath);
        }
        return this.getSnapshotFileWithLog(snapshotLogFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<File> getSnapshotFileWithLog(File logFile) throws IOException {
        try (SnapshotLogAnalyzer analyzer = new SnapshotLogAnalyzer(logFile);){
            String snapshotId = analyzer.getSnapshotId();
            String[] dataDirs = IoTDBDescriptor.getInstance().getConfig().getLocalDataDirs();
            LinkedList<File> fileList = new LinkedList<File>();
            for (String dataDir : dataDirs) {
                String snapshotDir = dataDir + File.separator + "snapshot" + File.separator + this.storageGroupName + "-" + this.dataRegionId + File.separator + snapshotId;
                fileList.addAll(this.searchDataFilesRecursively(snapshotDir));
            }
            LinkedList<File> linkedList = fileList;
            return linkedList;
        }
    }

    private List<File> searchDataFilesRecursively(String dir) throws IOException {
        final LinkedList<File> fileList = new LinkedList<File>();
        Files.walkFileTree(new File(dir).toPath(), (FileVisitor<? super Path>)new FileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (SnapshotFileSet.isDataFile(file.toFile())) {
                    fileList.add(file.toFile());
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }
        });
        return fileList;
    }
}

