/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.db.service.metrics.CompactionMetrics;
import org.apache.iotdb.db.storageengine.dataregion.compaction.io.CompactionTsFileInput;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.CompactionTaskManager;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.constant.CompactionIoDataType;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.constant.CompactionType;
import org.apache.iotdb.tsfile.file.IMetadataIndexEntry;
import org.apache.iotdb.tsfile.file.header.ChunkHeader;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.IDeviceID;
import org.apache.iotdb.tsfile.file.metadata.MetadataIndexNode;
import org.apache.iotdb.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.MetadataIndexNodeType;
import org.apache.iotdb.tsfile.read.TsFileDeviceIterator;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.read.reader.TsFileInput;
import org.apache.iotdb.tsfile.utils.Pair;

public class CompactionTsFileReader
extends TsFileSequenceReader {
    private AtomicLong readDataSize = new AtomicLong(0L);
    CompactionType compactionType;
    private volatile boolean readingAlignedSeries = false;

    public CompactionTsFileReader(String file, CompactionType compactionType) throws IOException {
        super(file);
        this.tsFileInput = new CompactionTsFileInput(this.tsFileInput);
        this.compactionType = compactionType;
    }

    protected ByteBuffer readData(long position, int totalSize) throws IOException {
        this.acquireReadDataSizeWithCompactionReadRateLimiter(totalSize);
        ByteBuffer buffer = super.readData(position, totalSize);
        this.readDataSize.addAndGet(totalSize);
        return buffer;
    }

    public void markStartOfAlignedSeries() {
        this.readingAlignedSeries = true;
    }

    public void markEndOfAlignedSeries() {
        this.readingAlignedSeries = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Chunk readMemChunk(ChunkMetadata metaData) throws IOException {
        CompactionTsFileReader compactionTsFileReader = this;
        synchronized (compactionTsFileReader) {
            long before = this.readDataSize.get();
            Chunk chunk = super.readMemChunk(metaData);
            long dataSize = this.readDataSize.get() - before;
            CompactionMetrics.getInstance().recordReadInfo(this.compactionType, this.readingAlignedSeries ? CompactionIoDataType.ALIGNED : CompactionIoDataType.NOT_ALIGNED, dataSize);
            return chunk;
        }
    }

    public ChunkHeader readChunkHeader(long position) throws IOException {
        return ChunkHeader.deserializeFrom((TsFileInput)this.tsFileInput, (long)position);
    }

    public InputStream wrapAsInputStream() throws IOException {
        return this.tsFileInput.wrapAsInputStream();
    }

    public ByteBuffer readPageWithoutUnCompressing(long startOffset, int pageSize) throws IOException {
        if (pageSize == 0) {
            return null;
        }
        return this.readData(startOffset, pageSize);
    }

    public TsFileDeviceIterator getAllDevicesIteratorWithIsAligned() throws IOException {
        long before = this.readDataSize.get();
        TsFileDeviceIterator iterator = super.getAllDevicesIteratorWithIsAligned();
        long dataSize = this.readDataSize.get() - before;
        CompactionMetrics.getInstance().recordReadInfo(this.compactionType, CompactionIoDataType.METADATA, dataSize);
        return iterator;
    }

    public List<IChunkMetadata> getChunkMetadataListByTimeseriesMetadataOffset(long startOffset, long endOffset) throws IOException {
        long before = this.readDataSize.get();
        List chunkMetadataList = super.getChunkMetadataListByTimeseriesMetadataOffset(startOffset, endOffset);
        long dataSize = this.readDataSize.get() - before;
        CompactionMetrics.getInstance().recordReadInfo(this.compactionType, CompactionIoDataType.METADATA, dataSize);
        return chunkMetadataList;
    }

    public void getDevicesAndEntriesOfOneLeafNode(Long startOffset, Long endOffset, Queue<Pair<IDeviceID, long[]>> measurementNodeOffsetQueue) throws IOException {
        long before = this.readDataSize.get();
        super.getDevicesAndEntriesOfOneLeafNode(startOffset, endOffset, measurementNodeOffsetQueue);
        long dataSize = this.readDataSize.get() - before;
        CompactionMetrics.getInstance().recordReadInfo(this.compactionType, CompactionIoDataType.METADATA, dataSize);
    }

    public MetadataIndexNode readMetadataIndexNode(long start, long end, boolean isDeviceLevel) throws IOException {
        long before = this.readDataSize.get();
        MetadataIndexNode metadataIndexNode = super.readMetadataIndexNode(start, end, isDeviceLevel);
        long dataSize = this.readDataSize.get() - before;
        CompactionMetrics.getInstance().recordReadInfo(this.compactionType, CompactionIoDataType.METADATA, dataSize);
        return metadataIndexNode;
    }

    public Map<String, Pair<List<IChunkMetadata>, Pair<Long, Long>>> getTimeseriesMetadataOffsetByDevice(MetadataIndexNode measurementNode, Set<String> excludedMeasurementIds, boolean needChunkMetadata) throws IOException {
        long before = this.readDataSize.get();
        Map result = super.getTimeseriesMetadataOffsetByDevice(measurementNode, excludedMeasurementIds, needChunkMetadata);
        long dataSize = this.readDataSize.get() - before;
        CompactionMetrics.getInstance().recordReadInfo(this.compactionType, CompactionIoDataType.METADATA, dataSize);
        return result;
    }

    public Map<String, Pair<TimeseriesMetadata, Pair<Long, Long>>> getTimeseriesMetadataAndOffsetByDevice(MetadataIndexNode measurementNode, Set<String> excludedMeasurementIds, boolean needChunkMetadata) throws IOException {
        long before = this.readDataSize.get();
        LinkedHashMap<String, Pair<TimeseriesMetadata, Pair<Long, Long>>> timeseriesMetadataOffsetMap = new LinkedHashMap<String, Pair<TimeseriesMetadata, Pair<Long, Long>>>();
        List childrenEntryList = measurementNode.getChildren();
        for (int i = 0; i < childrenEntryList.size(); ++i) {
            long startOffset = ((IMetadataIndexEntry)childrenEntryList.get(i)).getOffset();
            long endOffset = i == childrenEntryList.size() - 1 ? measurementNode.getEndOffset() : ((IMetadataIndexEntry)childrenEntryList.get(i + 1)).getOffset();
            ByteBuffer nextBuffer = this.readData(startOffset, endOffset);
            if (measurementNode.getNodeType().equals((Object)MetadataIndexNodeType.LEAF_MEASUREMENT)) {
                while (nextBuffer.hasRemaining()) {
                    int metadataStartOffset = nextBuffer.position();
                    TimeseriesMetadata timeseriesMetadata = TimeseriesMetadata.deserializeFrom((ByteBuffer)nextBuffer, excludedMeasurementIds, (boolean)needChunkMetadata);
                    timeseriesMetadataOffsetMap.put(timeseriesMetadata.getMeasurementId(), (Pair<TimeseriesMetadata, Pair<Long, Long>>)new Pair((Object)timeseriesMetadata, (Object)new Pair((Object)(startOffset + (long)metadataStartOffset), (Object)(startOffset + (long)nextBuffer.position()))));
                }
                continue;
            }
            MetadataIndexNode nextLayerMeasurementNode = MetadataIndexNode.deserializeFrom((ByteBuffer)nextBuffer, (boolean)false);
            timeseriesMetadataOffsetMap.putAll(this.getTimeseriesMetadataAndOffsetByDevice(nextLayerMeasurementNode, excludedMeasurementIds, needChunkMetadata));
        }
        long dataSize = this.readDataSize.get() - before;
        CompactionMetrics.getInstance().recordReadInfo(this.compactionType, CompactionIoDataType.METADATA, dataSize);
        return timeseriesMetadataOffsetMap;
    }

    public void getDeviceTimeseriesMetadata(List<TimeseriesMetadata> timeseriesMetadataList, MetadataIndexNode measurementNode, Set<String> excludedMeasurementIds, boolean needChunkMetadata) throws IOException {
        long before = this.readDataSize.get();
        super.getDeviceTimeseriesMetadata(timeseriesMetadataList, measurementNode, excludedMeasurementIds, needChunkMetadata);
        long dataSize = this.readDataSize.get() - before;
        CompactionMetrics.getInstance().recordReadInfo(this.compactionType, CompactionIoDataType.METADATA, dataSize);
    }

    private void acquireReadDataSizeWithCompactionReadRateLimiter(int readDataSize) {
        CompactionTaskManager.getInstance().getCompactionReadOperationRateLimiter().acquire(1);
        CompactionTaskManager.getInstance().getCompactionReadRateLimiter().acquire(readDataSize);
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

