/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.join;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.MultiChildProcessNode;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class InnerTimeJoinNode
extends MultiChildProcessNode {
    private final Ordering mergeOrder;
    private List<Long> timePartitions;
    private List<String> outputColumnNames;

    public InnerTimeJoinNode(PlanNodeId id, List<PlanNode> children, Ordering mergeOrder) {
        this(id, children, mergeOrder, null, null);
    }

    public InnerTimeJoinNode(PlanNodeId id, Ordering mergeOrder, List<Long> timePartitions, List<String> outputColumnNames) {
        super(id);
        this.mergeOrder = mergeOrder;
        this.timePartitions = timePartitions;
        this.outputColumnNames = outputColumnNames;
    }

    public InnerTimeJoinNode(PlanNodeId id, List<PlanNode> children, Ordering mergeOrder, List<Long> timePartitions, List<String> outputColumnNames) {
        super(id, children);
        this.mergeOrder = mergeOrder;
        this.timePartitions = timePartitions;
        this.outputColumnNames = outputColumnNames;
    }

    public Ordering getMergeOrder() {
        return this.mergeOrder;
    }

    @Override
    public PlanNodeType getType() {
        return PlanNodeType.INNER_TIME_JOIN;
    }

    @Override
    public PlanNode clone() {
        return new InnerTimeJoinNode(this.getPlanNodeId(), this.getMergeOrder(), this.timePartitions, this.outputColumnNames);
    }

    @Override
    public PlanNode createSubNode(int subNodeId, int startIndex, int endIndex) {
        return new InnerTimeJoinNode(new PlanNodeId(String.format("%s-%s", this.getPlanNodeId(), subNodeId)), new ArrayList<PlanNode>(this.children.subList(startIndex, endIndex)), this.getMergeOrder(), this.timePartitions, null);
    }

    @Override
    public List<String> getOutputColumnNames() {
        return this.outputColumnNames != null ? this.outputColumnNames : this.children.stream().map(PlanNode::getOutputColumnNames).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitInnerTimeJoin(this, context);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.INNER_TIME_JOIN.serialize(byteBuffer);
        ReadWriteIOUtils.write((int)this.mergeOrder.ordinal(), (ByteBuffer)byteBuffer);
        if (this.timePartitions == null) {
            ReadWriteIOUtils.write((Boolean)false, (ByteBuffer)byteBuffer);
        } else {
            ReadWriteIOUtils.write((Boolean)true, (ByteBuffer)byteBuffer);
            ReadWriteIOUtils.write((int)this.timePartitions.size(), (ByteBuffer)byteBuffer);
            for (Long timePartitionId : this.timePartitions) {
                ReadWriteIOUtils.write((long)timePartitionId, (ByteBuffer)byteBuffer);
            }
        }
        if (this.outputColumnNames == null) {
            ReadWriteIOUtils.write((Boolean)false, (ByteBuffer)byteBuffer);
        } else {
            ReadWriteIOUtils.write((Boolean)true, (ByteBuffer)byteBuffer);
            ReadWriteIOUtils.write((int)this.outputColumnNames.size(), (ByteBuffer)byteBuffer);
            for (String outputColumnName : this.outputColumnNames) {
                ReadWriteIOUtils.write((String)outputColumnName, (ByteBuffer)byteBuffer);
            }
        }
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.INNER_TIME_JOIN.serialize(stream);
        ReadWriteIOUtils.write((int)this.mergeOrder.ordinal(), (OutputStream)stream);
        if (this.timePartitions == null) {
            ReadWriteIOUtils.write((Boolean)false, (OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((Boolean)true, (OutputStream)stream);
            ReadWriteIOUtils.write((int)this.timePartitions.size(), (OutputStream)stream);
            for (Long timePartitionId : this.timePartitions) {
                ReadWriteIOUtils.write((long)timePartitionId, (OutputStream)stream);
            }
        }
        if (this.outputColumnNames == null) {
            ReadWriteIOUtils.write((Boolean)false, (OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((Boolean)true, (OutputStream)stream);
            ReadWriteIOUtils.write((int)this.outputColumnNames.size(), (OutputStream)stream);
            for (String outputColumnName : this.outputColumnNames) {
                ReadWriteIOUtils.write((String)outputColumnName, (OutputStream)stream);
            }
        }
    }

    public static InnerTimeJoinNode deserialize(ByteBuffer byteBuffer) {
        Ordering mergeOrder = Ordering.values()[ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer)];
        ArrayList<Long> timePartitionIds = null;
        boolean hasTimePartitionIds = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        if (hasTimePartitionIds) {
            int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
            timePartitionIds = new ArrayList<Long>(size);
            for (int i = 0; i < size; ++i) {
                timePartitionIds.add(ReadWriteIOUtils.readLong((ByteBuffer)byteBuffer));
            }
        }
        ArrayList<String> outputColumnNames = null;
        boolean hasOutputColumnNames = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        if (hasOutputColumnNames) {
            int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
            outputColumnNames = new ArrayList<String>(size);
            for (int i = 0; i < size; ++i) {
                outputColumnNames.add(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer));
            }
        }
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new InnerTimeJoinNode(planNodeId, new ArrayList<PlanNode>(), mergeOrder, timePartitionIds, outputColumnNames);
    }

    public String toString() {
        return "InnerTimeJoinNode-" + this.getPlanNodeId();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InnerTimeJoinNode that = (InnerTimeJoinNode)o;
        return this.mergeOrder == that.mergeOrder;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.mergeOrder});
    }

    public void setTimePartitions(List<Long> timePartitions) {
        this.timePartitions = timePartitions;
    }

    public Optional<List<Long>> getTimePartitions() {
        return Optional.ofNullable(this.timePartitions);
    }

    public void setOutputColumnNames(List<String> outputColumnNames) {
        this.outputColumnNames = outputColumnNames;
    }

    public boolean outputColumnNamesIsNull() {
        return this.outputColumnNames == null;
    }
}

