/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.read;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathDeserializeUtil;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.db.queryengine.common.header.ColumnHeader;
import org.apache.iotdb.db.queryengine.common.header.ColumnHeaderConstant;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.read.SchemaQueryScanNode;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class PathsUsingTemplateScanNode
extends SchemaQueryScanNode {
    private List<PartialPath> pathPatternList;
    private final int templateId;

    public PathsUsingTemplateScanNode(PlanNodeId id, List<PartialPath> pathPatternList, int templateId, PathPatternTree scope) {
        super(id);
        this.setScope(scope);
        this.pathPatternList = pathPatternList;
        this.templateId = templateId;
    }

    @Override
    public List<PartialPath> getPathPatternList() {
        return this.pathPatternList;
    }

    @Override
    public void setPathPatternList(List<PartialPath> pathPatternList) {
        this.pathPatternList = pathPatternList;
    }

    public int getTemplateId() {
        return this.templateId;
    }

    @Override
    public PlanNodeType getType() {
        return PlanNodeType.PATHS_USING_TEMPLATE_SCAN;
    }

    @Override
    public PlanNode clone() {
        return new PathsUsingTemplateScanNode(this.getPlanNodeId(), this.pathPatternList, this.templateId, this.scope);
    }

    @Override
    public List<String> getOutputColumnNames() {
        return ColumnHeaderConstant.showPathsUsingTemplateHeaders.stream().map(ColumnHeader::getColumnName).collect(Collectors.toList());
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.PATHS_USING_TEMPLATE_SCAN.serialize(byteBuffer);
        ReadWriteIOUtils.write((int)this.pathPatternList.size(), (ByteBuffer)byteBuffer);
        for (PartialPath pathPattern : this.pathPatternList) {
            pathPattern.serialize(byteBuffer);
        }
        this.scope.serialize(byteBuffer);
        ReadWriteIOUtils.write((int)this.templateId, (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.PATHS_USING_TEMPLATE_SCAN.serialize(stream);
        ReadWriteIOUtils.write((int)this.pathPatternList.size(), (OutputStream)stream);
        for (PartialPath pathPattern : this.pathPatternList) {
            pathPattern.serialize((OutputStream)stream);
        }
        this.scope.serialize(stream);
        ReadWriteIOUtils.write((int)this.templateId, (OutputStream)stream);
    }

    public static PathsUsingTemplateScanNode deserialize(ByteBuffer buffer) {
        int size = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        ArrayList<PartialPath> pathPatternList = new ArrayList<PartialPath>(size);
        for (int i = 0; i < size; ++i) {
            pathPatternList.add((PartialPath)PathDeserializeUtil.deserialize((ByteBuffer)buffer));
        }
        PathPatternTree scope = PathPatternTree.deserialize((ByteBuffer)buffer);
        int templateId = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        PlanNodeId planNodeId = PlanNodeId.deserialize(buffer);
        return new PathsUsingTemplateScanNode(planNodeId, pathPatternList, templateId, scope);
    }

    @Override
    public String toString() {
        return String.format("PathsUsingTemplateScanNode-%s:[DataRegion: %s]", this.getPlanNodeId(), this.getRegionReplicaSet());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PathsUsingTemplateScanNode that = (PathsUsingTemplateScanNode)o;
        return this.templateId == that.templateId && Objects.equals(this.pathPatternList, that.pathPatternList);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.pathPatternList, this.templateId);
    }
}

