/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.expression.visitor.cartesian;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.common.schematree.ISchemaTree;
import org.apache.iotdb.db.queryengine.plan.analyze.ExpressionUtils;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.ConstantOperand;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.TimestampOperand;
import org.apache.iotdb.db.queryengine.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.queryengine.plan.expression.visitor.cartesian.BindSchemaForExpressionVisitor;
import org.apache.iotdb.db.queryengine.plan.expression.visitor.cartesian.CartesianProductVisitor;
import org.apache.iotdb.db.utils.TypeInferenceUtils;

public class ConcatDeviceAndBindSchemaForExpressionVisitor
extends CartesianProductVisitor<Context> {
    @Override
    public List<Expression> visitFunctionExpression(FunctionExpression functionExpression, Context context) {
        ArrayList<List<Expression>> extendedExpressions = new ArrayList<List<Expression>>();
        for (Expression suffixExpression : functionExpression.getExpressions()) {
            List concatExpression = (List)this.process(suffixExpression, context);
            if (concatExpression != null && !concatExpression.isEmpty()) {
                extendedExpressions.add(concatExpression);
            }
            if (!"count_if".equalsIgnoreCase(functionExpression.getFunctionName())) continue;
            List<Expression> children = functionExpression.getExpressions();
            TypeInferenceUtils.bindTypeForBuiltinAggregationNonSeriesInputExpressions(functionExpression.getFunctionName(), children, extendedExpressions);
            break;
        }
        if ("count_time".equalsIgnoreCase(functionExpression.getFunctionName())) {
            List<Expression> usedExpressions = extendedExpressions.stream().flatMap(Collection::stream).collect(Collectors.toList());
            FunctionExpression countTimeExpression = new FunctionExpression("count_time", new LinkedHashMap<String, String>(), Collections.singletonList(new TimestampOperand()), usedExpressions);
            return Collections.singletonList(countTimeExpression);
        }
        ArrayList<List<Expression>> childExpressionsList = new ArrayList<List<Expression>>();
        ExpressionUtils.cartesianProduct(extendedExpressions, childExpressionsList, 0, new ArrayList());
        return ExpressionUtils.reconstructFunctionExpressions(functionExpression, childExpressionsList);
    }

    @Override
    public List<Expression> visitTimeSeriesOperand(TimeSeriesOperand timeSeriesOperand, Context context) {
        PartialPath measurement = timeSeriesOperand.getPath();
        PartialPath concatPath = context.getDevicePath().concatPath(measurement);
        List actualPaths = (List)context.getSchemaTree().searchMeasurementPaths((PartialPath)concatPath).left;
        if (actualPaths.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<MeasurementPath> nonViewActualPaths = new ArrayList<MeasurementPath>();
        ArrayList<MeasurementPath> viewPaths = new ArrayList<MeasurementPath>();
        for (MeasurementPath measurementPath : actualPaths) {
            if (measurementPath.getMeasurementSchema().isLogicalView()) {
                viewPaths.add(measurementPath);
                continue;
            }
            nonViewActualPaths.add(measurementPath);
        }
        List<Expression> reconstructTimeSeriesOperands = ExpressionUtils.reconstructTimeSeriesOperands(timeSeriesOperand, nonViewActualPaths);
        for (MeasurementPath measurementPath : viewPaths) {
            Expression replacedExpression = BindSchemaForExpressionVisitor.transformViewPath(measurementPath, context.getSchemaTree());
            if (!(replacedExpression instanceof TimeSeriesOperand)) {
                throw new SemanticException("Only writable view timeseries are supported in ALIGN BY DEVICE queries.");
            }
            replacedExpression.setViewPath((PartialPath)measurementPath);
            reconstructTimeSeriesOperands.add(replacedExpression);
        }
        return reconstructTimeSeriesOperands;
    }

    @Override
    public List<Expression> visitTimeStampOperand(TimestampOperand timestampOperand, Context context) {
        return Collections.singletonList(timestampOperand);
    }

    @Override
    public List<Expression> visitConstantOperand(ConstantOperand constantOperand, Context context) {
        return Collections.singletonList(constantOperand);
    }

    public static class Context {
        private final PartialPath devicePath;
        private final ISchemaTree schemaTree;

        public Context(PartialPath devicePath, ISchemaTree schemaTree) {
            this.devicePath = devicePath;
            this.schemaTree = schemaTree;
        }

        public PartialPath getDevicePath() {
            return this.devicePath;
        }

        public ISchemaTree getSchemaTree() {
            return this.schemaTree;
        }
    }
}

