/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.execution.config.sys.pipe;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.confignode.rpc.thrift.TShowPipeInfo;
import org.apache.iotdb.db.queryengine.common.header.ColumnHeader;
import org.apache.iotdb.db.queryengine.common.header.ColumnHeaderConstant;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeader;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeaderFactory;
import org.apache.iotdb.db.queryengine.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.queryengine.plan.execution.config.IConfigTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.executor.IConfigTaskExecutor;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.pipe.ShowPipesStatement;
import org.apache.iotdb.db.utils.DateTimeUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.utils.Binary;

public class ShowPipeTask
implements IConfigTask {
    private final ShowPipesStatement showPipesStatement;

    public ShowPipeTask(ShowPipesStatement showPipesStatement) {
        this.showPipesStatement = showPipesStatement;
    }

    @Override
    public ListenableFuture<ConfigTaskResult> execute(IConfigTaskExecutor configTaskExecutor) throws InterruptedException {
        return configTaskExecutor.showPipes(this.showPipesStatement);
    }

    public static void buildTSBlock(List<TShowPipeInfo> pipeInfoList, SettableFuture<ConfigTaskResult> future) {
        List outputDataTypes = ColumnHeaderConstant.showPipeColumnHeaders.stream().map(ColumnHeader::getColumnType).collect(Collectors.toList());
        TsBlockBuilder builder = new TsBlockBuilder(outputDataTypes);
        for (TShowPipeInfo tPipeInfo : pipeInfoList) {
            builder.getTimeColumnBuilder().writeLong(0L);
            builder.getColumnBuilder(0).writeBinary(new Binary(tPipeInfo.getId(), TSFileConfig.STRING_CHARSET));
            builder.getColumnBuilder(1).writeBinary(new Binary(DateTimeUtils.convertLongToDate(tPipeInfo.getCreationTime(), "ms"), TSFileConfig.STRING_CHARSET));
            builder.getColumnBuilder(2).writeBinary(new Binary(tPipeInfo.getState(), TSFileConfig.STRING_CHARSET));
            builder.getColumnBuilder(3).writeBinary(new Binary(tPipeInfo.getPipeExtractor(), TSFileConfig.STRING_CHARSET));
            builder.getColumnBuilder(4).writeBinary(new Binary(tPipeInfo.getPipeProcessor(), TSFileConfig.STRING_CHARSET));
            builder.getColumnBuilder(5).writeBinary(new Binary(tPipeInfo.getPipeConnector(), TSFileConfig.STRING_CHARSET));
            builder.getColumnBuilder(6).writeBinary(new Binary(tPipeInfo.getExceptionMessage(), TSFileConfig.STRING_CHARSET));
            builder.declarePosition();
        }
        DatasetHeader datasetHeader = DatasetHeaderFactory.getShowPipeHeader();
        future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS, builder.build(), datasetHeader));
    }
}

