/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.fill.constant;

import java.util.Optional;
import org.apache.iotdb.db.queryengine.execution.operator.process.fill.IFill;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.IntColumn;
import org.apache.iotdb.tsfile.read.common.block.column.RunLengthEncodedColumn;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumn;

public class IntConstantFill
implements IFill {
    private final int value;
    private final int[] valueArray;

    public IntConstantFill(int value) {
        this.value = value;
        this.valueArray = new int[]{value};
    }

    @Override
    public Column fill(TimeColumn timeColumn, Column valueColumn) {
        int size = valueColumn.getPositionCount();
        if (!valueColumn.mayHaveNull() || size == 0) {
            return valueColumn;
        }
        if (valueColumn instanceof RunLengthEncodedColumn) {
            return new RunLengthEncodedColumn((Column)new IntColumn(1, Optional.empty(), this.valueArray), size);
        }
        int[] array = new int[size];
        for (int i = 0; i < size; ++i) {
            array[i] = valueColumn.isNull(i) ? this.value : valueColumn.getInt(i);
        }
        return new IntColumn(size, Optional.empty(), array);
    }
}

