/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.exchange.sink;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Optional;
import org.apache.commons.lang3.Validate;
import org.apache.iotdb.db.queryengine.execution.exchange.MPPDataExchangeManager;
import org.apache.iotdb.db.queryengine.execution.exchange.SharedTsBlockQueue;
import org.apache.iotdb.db.queryengine.execution.exchange.sink.ISinkChannel;
import org.apache.iotdb.db.queryengine.metric.DataExchangeCostMetricSet;
import org.apache.iotdb.mpp.rpc.thrift.TFragmentInstanceId;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalSinkChannel
implements ISinkChannel {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalSinkChannel.class);
    private TFragmentInstanceId localFragmentInstanceId;
    private final MPPDataExchangeManager.SinkListener sinkListener;
    private final SharedTsBlockQueue queue;
    private volatile ListenableFuture<Void> blocked;
    private boolean aborted = false;
    private boolean closed = false;
    private boolean invokedOnFinished = false;
    private static final DataExchangeCostMetricSet DATA_EXCHANGE_COST_METRIC_SET = DataExchangeCostMetricSet.getInstance();

    public LocalSinkChannel(SharedTsBlockQueue queue, MPPDataExchangeManager.SinkListener sinkListener) {
        this.sinkListener = (MPPDataExchangeManager.SinkListener)Validate.notNull((Object)sinkListener, (String)"sinkListener can not be null.", (Object[])new Object[0]);
        this.queue = (SharedTsBlockQueue)Validate.notNull((Object)queue, (String)"queue can not be null.", (Object[])new Object[0]);
        this.queue.setSinkChannel(this);
        this.blocked = queue.getCanAddTsBlock();
    }

    public LocalSinkChannel(TFragmentInstanceId localFragmentInstanceId, SharedTsBlockQueue queue, MPPDataExchangeManager.SinkListener sinkListener) {
        this.localFragmentInstanceId = (TFragmentInstanceId)Validate.notNull((Object)localFragmentInstanceId, (String)"localFragmentInstanceId can not be null.", (Object[])new Object[0]);
        this.sinkListener = (MPPDataExchangeManager.SinkListener)Validate.notNull((Object)sinkListener, (String)"sinkListener can not be null.", (Object[])new Object[0]);
        this.queue = (SharedTsBlockQueue)Validate.notNull((Object)queue, (String)"queue can not be null.", (Object[])new Object[0]);
        this.queue.setSinkChannel(this);
        this.blocked = queue.getCanAddTsBlock();
    }

    @Override
    public TFragmentInstanceId getLocalFragmentInstanceId() {
        return this.localFragmentInstanceId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getBufferRetainedSizeInBytes() {
        SharedTsBlockQueue sharedTsBlockQueue = this.queue;
        synchronized (sharedTsBlockQueue) {
            return this.queue.getBufferRetainedSizeInBytes();
        }
    }

    @Override
    public synchronized ListenableFuture<?> isFull() {
        this.checkState();
        if (this.closed) {
            return Futures.immediateVoidFuture();
        }
        return Futures.nonCancellationPropagating(this.blocked);
    }

    @Override
    public boolean isAborted() {
        return this.aborted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFinished() {
        SharedTsBlockQueue sharedTsBlockQueue = this.queue;
        synchronized (sharedTsBlockQueue) {
            return this.queue.hasNoMoreTsBlocks() && this.queue.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkAndInvokeOnFinished() {
        SharedTsBlockQueue sharedTsBlockQueue = this.queue;
        synchronized (sharedTsBlockQueue) {
            if (this.isFinished()) {
                LocalSinkChannel localSinkChannel = this;
                synchronized (localSinkChannel) {
                    if (!this.invokedOnFinished) {
                        this.sinkListener.onFinish(this);
                        this.invokedOnFinished = true;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(TsBlock tsBlock) {
        long startTime = System.nanoTime();
        try {
            Validate.notNull((Object)tsBlock, (String)"tsBlocks is null", (Object[])new Object[0]);
            Object object = this;
            synchronized (object) {
                block18: {
                    this.checkState();
                    if (!this.closed) break block18;
                    return;
                }
                if (!this.blocked.isDone()) {
                    throw new IllegalStateException("Sink handle is blocked.");
                }
            }
            object = this.queue;
            synchronized (object) {
                block19: {
                    if (!this.queue.hasNoMoreTsBlocks()) break block19;
                    return;
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("[StartSendTsBlockOnLocal]");
                }
                LocalSinkChannel localSinkChannel = this;
                synchronized (localSinkChannel) {
                    this.blocked = this.queue.add(tsBlock);
                }
            }
        }
        finally {
            DATA_EXCHANGE_COST_METRIC_SET.recordDataExchangeCost("sink_handle_send_tsblock_local", System.nanoTime() - startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNoMoreTsBlocks() {
        SharedTsBlockQueue sharedTsBlockQueue = this.queue;
        synchronized (sharedTsBlockQueue) {
            LocalSinkChannel localSinkChannel = this;
            synchronized (localSinkChannel) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("[StartSetNoMoreTsBlocksOnLocal]");
                }
                if (this.aborted || this.closed) {
                    return;
                }
                this.queue.setNoMoreTsBlocks(true);
                this.sinkListener.onEndOfBlocks(this);
            }
        }
        this.checkAndInvokeOnFinished();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("[EndSetNoMoreTsBlocksOnLocal]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("[StartAbortLocalSinkChannel]");
        }
        SharedTsBlockQueue sharedTsBlockQueue = this.queue;
        synchronized (sharedTsBlockQueue) {
            LocalSinkChannel localSinkChannel = this;
            synchronized (localSinkChannel) {
                if (this.aborted || this.closed) {
                    return;
                }
                this.aborted = true;
                Optional<Throwable> t = this.sinkListener.onAborted(this);
                if (t.isPresent()) {
                    this.queue.abort(t.get());
                } else {
                    this.queue.abort();
                }
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("[EndAbortLocalSinkChannel]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("[StartCloseLocalSinkChannel]");
        }
        SharedTsBlockQueue sharedTsBlockQueue = this.queue;
        synchronized (sharedTsBlockQueue) {
            LocalSinkChannel localSinkChannel = this;
            synchronized (localSinkChannel) {
                if (this.aborted || this.closed) {
                    return;
                }
                this.closed = true;
                this.queue.close();
                if (!this.invokedOnFinished) {
                    this.sinkListener.onFinish(this);
                    this.invokedOnFinished = true;
                }
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("[EndCloseLocalSinkChannel]");
        }
    }

    public SharedTsBlockQueue getSharedTsBlockQueue() {
        return this.queue;
    }

    private void checkState() {
        if (this.aborted) {
            throw new IllegalStateException("LocalSinkChannel is aborted.");
        }
    }

    @Override
    public void setMaxBytesCanReserve(long maxBytesCanReserve) {
        if (maxBytesCanReserve < this.queue.getMaxBytesCanReserve()) {
            this.queue.setMaxBytesCanReserve(maxBytesCanReserve);
        }
    }

    @Override
    public void open() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isNoMoreTsBlocks() {
        SharedTsBlockQueue sharedTsBlockQueue = this.queue;
        synchronized (sharedTsBlockQueue) {
            return this.queue.hasNoMoreTsBlocks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumOfBufferedTsBlocks() {
        SharedTsBlockQueue sharedTsBlockQueue = this.queue;
        synchronized (sharedTsBlockQueue) {
            return this.queue.getNumOfBufferedTsBlocks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isClosed() {
        SharedTsBlockQueue sharedTsBlockQueue = this.queue;
        synchronized (sharedTsBlockQueue) {
            return this.queue.isClosed();
        }
    }
}

