/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.aggregation;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.apache.iotdb.db.queryengine.execution.aggregation.Accumulator;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.BitMap;
import org.apache.iotdb.tsfile.utils.BytesUtils;

public class VarianceAccumulator
implements Accumulator {
    private final TSDataType seriesDataType;
    private final VarianceType varianceType;
    private long count;
    private double mean;
    private double m2;

    public VarianceAccumulator(TSDataType seriesDataType, VarianceType varianceType) {
        this.seriesDataType = seriesDataType;
        this.varianceType = varianceType;
    }

    @Override
    public void addInput(Column[] columns, BitMap bitMap) {
        switch (this.seriesDataType) {
            case INT32: {
                this.addIntInput(columns, bitMap);
                return;
            }
            case INT64: {
                this.addLongInput(columns, bitMap);
                return;
            }
            case FLOAT: {
                this.addFloatInput(columns, bitMap);
                return;
            }
            case DOUBLE: {
                this.addDoubleInput(columns, bitMap);
                return;
            }
        }
        throw new UnSupportedDataTypeException(String.format("Unsupported data type in aggregation variance : %s", this.seriesDataType));
    }

    @Override
    public void addIntermediate(Column[] partialResult) {
        Preconditions.checkArgument((partialResult.length == 1 ? 1 : 0) != 0, (Object)"partialResult of variance should be 1");
        if (partialResult[0].isNull(0)) {
            return;
        }
        byte[] bytes = partialResult[0].getBinary(0).getValues();
        long intermediateCount = BytesUtils.bytesToLong((byte[])bytes, (int)8);
        double intermediateMean = BytesUtils.bytesToDouble((byte[])bytes, (int)8);
        double intermediateM2 = BytesUtils.bytesToDouble((byte[])bytes, (int)16);
        long newCount = this.count + intermediateCount;
        double newMean = ((double)intermediateCount * intermediateMean + (double)this.count * this.mean) / (double)newCount;
        double delta = intermediateMean - this.mean;
        this.m2 = this.m2 + intermediateM2 + delta * delta * (double)intermediateCount * (double)this.count / (double)newCount;
        this.count = newCount;
        this.mean = newMean;
    }

    @Override
    public void removeIntermediate(Column[] input) {
        Preconditions.checkArgument((input.length == 1 ? 1 : 0) != 0, (Object)"Input of variance should be 1");
        if (input[0].isNull(0)) {
            return;
        }
        byte[] bytes = input[0].getBinary(0).getValues();
        long intermediateCount = BytesUtils.bytesToLong((byte[])bytes, (int)8);
        double intermediateMean = BytesUtils.bytesToDouble((byte[])bytes, (int)8);
        double intermediateM2 = BytesUtils.bytesToDouble((byte[])bytes, (int)16);
        long newCount = this.count - intermediateCount;
        double newMean = ((double)this.count * this.mean - (double)intermediateCount * intermediateMean) / (double)newCount;
        double delta = intermediateMean - this.mean;
        this.m2 = this.m2 - intermediateM2 - delta * delta * (double)intermediateCount * (double)this.count / (double)newCount;
        this.count = newCount;
        this.mean = newMean;
    }

    @Override
    public void addStatistics(Statistics statistics) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void setFinal(Column finalResult) {
        double value;
        this.reset();
        if (finalResult.isNull(0)) {
            return;
        }
        this.count = 1L;
        this.mean = value = finalResult.getDouble(0);
        this.m2 = value * value;
    }

    @Override
    public void outputIntermediate(ColumnBuilder[] columnBuilders) {
        Preconditions.checkArgument((columnBuilders.length == 1 ? 1 : 0) != 0, (Object)"partialResult of variance should be 1");
        if (this.count == 0L) {
            columnBuilders[0].appendNull();
        } else {
            byte[] bytes = this.serialize();
            columnBuilders[0].writeBinary(new Binary(bytes));
        }
    }

    private byte[] serialize() {
        byte[] countBytes = BytesUtils.longToBytes((long)this.count);
        byte[] meanBytes = BytesUtils.doubleToBytes((double)this.mean);
        byte[] m2Bytes = BytesUtils.doubleToBytes((double)this.m2);
        return BytesUtils.concatByteArrayList(Arrays.asList(countBytes, meanBytes, m2Bytes));
    }

    @Override
    public void outputFinal(ColumnBuilder columnBuilder) {
        switch (this.varianceType) {
            case STDDEV_POP: {
                if (this.count == 0L) {
                    columnBuilder.appendNull();
                    break;
                }
                columnBuilder.writeDouble(Math.sqrt(this.m2 / (double)this.count));
                break;
            }
            case STDDEV_SAMP: {
                if (this.count < 2L) {
                    columnBuilder.appendNull();
                    break;
                }
                columnBuilder.writeDouble(Math.sqrt(this.m2 / (double)(this.count - 1L)));
                break;
            }
            case VAR_POP: {
                if (this.count == 0L) {
                    columnBuilder.appendNull();
                    break;
                }
                columnBuilder.writeDouble(this.m2 / (double)this.count);
                break;
            }
            case VAR_SAMP: {
                if (this.count < 2L) {
                    columnBuilder.appendNull();
                    break;
                }
                columnBuilder.writeDouble(this.m2 / (double)(this.count - 1L));
                break;
            }
            default: {
                throw new EnumConstantNotPresentException(VarianceType.class, this.varianceType.name());
            }
        }
    }

    @Override
    public void reset() {
        this.count = 0L;
        this.mean = 0.0;
        this.m2 = 0.0;
    }

    @Override
    public boolean hasFinalResult() {
        return false;
    }

    @Override
    public TSDataType[] getIntermediateType() {
        return new TSDataType[]{TSDataType.TEXT};
    }

    @Override
    public TSDataType getFinalType() {
        return TSDataType.DOUBLE;
    }

    private void addIntInput(Column[] columns, BitMap bitmap) {
        int size = columns[0].getPositionCount();
        for (int i = 0; i < size; ++i) {
            if (bitmap != null && !bitmap.isMarked(i) || columns[1].isNull(i)) continue;
            int value = columns[1].getInt(i);
            ++this.count;
            double delta = (double)value - this.mean;
            this.mean += delta / (double)this.count;
            this.m2 += delta * ((double)value - this.mean);
        }
    }

    private void addLongInput(Column[] columns, BitMap bitmap) {
        int size = columns[0].getPositionCount();
        for (int i = 0; i < size; ++i) {
            if (bitmap != null && !bitmap.isMarked(i) || columns[1].isNull(i)) continue;
            long value = columns[1].getLong(i);
            ++this.count;
            double delta = (double)value - this.mean;
            this.mean += delta / (double)this.count;
            this.m2 += delta * ((double)value - this.mean);
        }
    }

    private void addFloatInput(Column[] columns, BitMap bitmap) {
        int size = columns[0].getPositionCount();
        for (int i = 0; i < size; ++i) {
            if (bitmap != null && !bitmap.isMarked(i) || columns[1].isNull(i)) continue;
            float value = columns[1].getFloat(i);
            ++this.count;
            double delta = (double)value - this.mean;
            this.mean += delta / (double)this.count;
            this.m2 += delta * ((double)value - this.mean);
        }
    }

    private void addDoubleInput(Column[] columns, BitMap bitmap) {
        int size = columns[0].getPositionCount();
        for (int i = 0; i < size; ++i) {
            if (bitmap != null && !bitmap.isMarked(i) || columns[1].isNull(i)) continue;
            double value = columns[1].getDouble(i);
            ++this.count;
            double delta = value - this.mean;
            this.mean += delta / (double)this.count;
            this.m2 += delta * (value - this.mean);
        }
    }

    public static enum VarianceType {
        STDDEV_POP,
        STDDEV_SAMP,
        VAR_POP,
        VAR_SAMP;

    }
}

