/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.task.connection;

import java.util.Deque;
import java.util.function.Consumer;
import org.apache.iotdb.db.pipe.metric.PipeDataRegionEventCounter;
import org.apache.iotdb.pipe.api.event.Event;

public class EnrichedDeque<E extends Event> {
    private final PipeDataRegionEventCounter eventCounter = new PipeDataRegionEventCounter();
    protected final Deque<E> deque;

    protected EnrichedDeque(Deque<E> deque) {
        this.deque = deque;
    }

    public boolean offer(E event) {
        boolean offered = this.deque.offer(event);
        if (offered) {
            this.eventCounter.increaseEventCount((Event)event);
        }
        return offered;
    }

    public E poll() {
        Event event = (Event)this.deque.poll();
        this.eventCounter.decreaseEventCount(event);
        return (E)event;
    }

    public void clear() {
        this.deque.clear();
        this.eventCounter.reset();
    }

    public int size() {
        return this.deque.size();
    }

    public void forEach(Consumer<? super E> action) {
        this.deque.forEach(action);
    }

    public E peek() {
        return (E)((Event)this.deque.peek());
    }

    public E peekLast() {
        return (E)((Event)this.deque.peekLast());
    }

    public boolean isEmpty() {
        return this.deque.isEmpty();
    }

    public int getTabletInsertionEventCount() {
        return this.eventCounter.getTabletInsertionEventCount();
    }

    public int getTsFileInsertionEventCount() {
        return this.eventCounter.getTsFileInsertionEventCount();
    }

    public int getPipeHeartbeatEventCount() {
        return this.eventCounter.getPipeHeartbeatEventCount();
    }
}

