/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.enumerated.ServerState;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class RedundantServerDataType
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=853");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=854");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=855");
    private final String serverId;
    private final UByte serviceLevel;
    private final ServerState serverState;

    public RedundantServerDataType(String serverId, UByte serviceLevel, ServerState serverState) {
        this.serverId = serverId;
        this.serviceLevel = serviceLevel;
        this.serverState = serverState;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    public String getServerId() {
        return this.serverId;
    }

    public UByte getServiceLevel() {
        return this.serviceLevel;
    }

    public ServerState getServerState() {
        return this.serverState;
    }

    protected RedundantServerDataType(RedundantServerDataTypeBuilder<?, ?> b) {
        super(b);
        this.serverId = ((RedundantServerDataTypeBuilder)b).serverId;
        this.serviceLevel = ((RedundantServerDataTypeBuilder)b).serviceLevel;
        this.serverState = ((RedundantServerDataTypeBuilder)b).serverState;
    }

    public static RedundantServerDataTypeBuilder<?, ?> builder() {
        return new RedundantServerDataTypeBuilderImpl();
    }

    public RedundantServerDataTypeBuilder<?, ?> toBuilder() {
        return new RedundantServerDataTypeBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RedundantServerDataType)) {
            return false;
        }
        RedundantServerDataType other = (RedundantServerDataType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$serverId = this.getServerId();
        String other$serverId = other.getServerId();
        if (this$serverId == null ? other$serverId != null : !this$serverId.equals(other$serverId)) {
            return false;
        }
        UByte this$serviceLevel = this.getServiceLevel();
        UByte other$serviceLevel = other.getServiceLevel();
        if (this$serviceLevel == null ? other$serviceLevel != null : !((Object)this$serviceLevel).equals(other$serviceLevel)) {
            return false;
        }
        ServerState this$serverState = this.getServerState();
        ServerState other$serverState = other.getServerState();
        return !(this$serverState == null ? other$serverState != null : !this$serverState.equals(other$serverState));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RedundantServerDataType;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $serverId = this.getServerId();
        result = result * 59 + ($serverId == null ? 43 : $serverId.hashCode());
        UByte $serviceLevel = this.getServiceLevel();
        result = result * 59 + ($serviceLevel == null ? 43 : ((Object)$serviceLevel).hashCode());
        ServerState $serverState = this.getServerState();
        result = result * 59 + ($serverState == null ? 43 : $serverState.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "RedundantServerDataType(serverId=" + this.getServerId() + ", serviceLevel=" + this.getServiceLevel() + ", serverState=" + this.getServerState() + ")";
    }

    private static final class RedundantServerDataTypeBuilderImpl
    extends RedundantServerDataTypeBuilder<RedundantServerDataType, RedundantServerDataTypeBuilderImpl> {
        private RedundantServerDataTypeBuilderImpl() {
        }

        @Override
        protected RedundantServerDataTypeBuilderImpl self() {
            return this;
        }

        @Override
        public RedundantServerDataType build() {
            return new RedundantServerDataType(this);
        }
    }

    public static abstract class RedundantServerDataTypeBuilder<C extends RedundantServerDataType, B extends RedundantServerDataTypeBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private String serverId;
        private UByte serviceLevel;
        private ServerState serverState;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            RedundantServerDataTypeBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(RedundantServerDataType instance, RedundantServerDataTypeBuilder<?, ?> b) {
            b.serverId(instance.serverId);
            b.serviceLevel(instance.serviceLevel);
            b.serverState(instance.serverState);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B serverId(String serverId) {
            this.serverId = serverId;
            return (B)this.self();
        }

        public B serviceLevel(UByte serviceLevel) {
            this.serviceLevel = serviceLevel;
            return (B)this.self();
        }

        public B serverState(ServerState serverState) {
            this.serverState = serverState;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "RedundantServerDataType.RedundantServerDataTypeBuilder(super=" + super.toString() + ", serverId=" + this.serverId + ", serviceLevel=" + this.serviceLevel + ", serverState=" + this.serverState + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<RedundantServerDataType> {
        @Override
        public Class<RedundantServerDataType> getType() {
            return RedundantServerDataType.class;
        }

        @Override
        public RedundantServerDataType decode(SerializationContext context, UaDecoder decoder) {
            String serverId = decoder.readString("ServerId");
            UByte serviceLevel = decoder.readByte("ServiceLevel");
            ServerState serverState = decoder.readEnum("ServerState", ServerState.class);
            return new RedundantServerDataType(serverId, serviceLevel, serverState);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, RedundantServerDataType value) {
            encoder.writeString("ServerId", value.getServerId());
            encoder.writeByte("ServiceLevel", value.getServiceLevel());
            encoder.writeEnum("ServerState", value.getServerState());
        }
    }
}

