/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.session.subscription;

import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.rpc.subscription.config.ConsumerConfig;
import org.apache.iotdb.rpc.subscription.payload.response.PipeSubscribeHandshakeResp;
import org.apache.iotdb.session.subscription.SubscriptionSession;
import org.apache.iotdb.session.subscription.SubscriptionSessionConnection;
import org.apache.thrift.TException;

final class SubscriptionProvider
extends SubscriptionSession {
    private String consumerId;
    private String consumerGroupId;
    private final AtomicBoolean isClosed = new AtomicBoolean(true);
    private final AtomicBoolean isAvailable = new AtomicBoolean(false);
    private final TEndPoint endPoint;
    private int dataNodeId;

    SubscriptionProvider(TEndPoint endPoint, String username, String password, String consumerId, String consumerGroupId) {
        super(endPoint.ip, endPoint.port, username, password);
        this.endPoint = endPoint;
        this.consumerId = consumerId;
        this.consumerGroupId = consumerGroupId;
    }

    synchronized void handshake() throws IoTDBConnectionException, TException, IOException, StatementExecutionException {
        if (!this.isClosed.get()) {
            return;
        }
        super.open();
        HashMap<String, String> consumerAttributes = new HashMap<String, String>();
        consumerAttributes.put("group-id", this.consumerGroupId);
        consumerAttributes.put("consumer-id", this.consumerId);
        PipeSubscribeHandshakeResp resp = this.getSessionConnection().handshake(new ConsumerConfig(consumerAttributes));
        this.dataNodeId = resp.getDataNodeId();
        this.consumerId = resp.getConsumerId();
        this.consumerGroupId = resp.getConsumerGroupId();
        this.isClosed.set(false);
        this.setAvailable();
    }

    @Override
    public synchronized void close() throws IoTDBConnectionException {
        if (this.isClosed.get()) {
            return;
        }
        try {
            this.getSessionConnection().closeConsumer();
        }
        catch (StatementExecutionException | TException e) {
            throw new IoTDBConnectionException(e);
        }
        finally {
            super.close();
            this.setUnavailable();
            this.isClosed.set(true);
        }
    }

    SubscriptionSessionConnection getSessionConnection() {
        return (SubscriptionSessionConnection)this.defaultSessionConnection;
    }

    boolean isAvailable() {
        return this.isAvailable.get();
    }

    void setAvailable() {
        this.isAvailable.set(true);
    }

    void setUnavailable() {
        this.isAvailable.set(false);
    }

    int getDataNodeId() {
        return this.dataNodeId;
    }

    String getConsumerId() {
        return this.consumerId;
    }

    String getConsumerGroupId() {
        return this.consumerGroupId;
    }

    TEndPoint getEndPoint() {
        return this.endPoint;
    }

    public String toString() {
        return "SubscriptionProvider{endPoint=" + this.endPoint + ", dataNodeId=" + this.dataNodeId + ", consumerId=" + this.consumerId + ", consumerGroupId=" + this.consumerGroupId + ", isAvailable=" + this.isAvailable + ", isClosed=" + this.isClosed + "}";
    }
}

