/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.udf.api.utils;

import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.type.Binary;
import org.apache.iotdb.udf.api.type.Type;

public class RowImpl
implements Row {
    private final TSDataType[] dataTypes;
    private final int size;
    private Object[] rowRecord;

    public RowImpl(TSDataType[] dataTypes) {
        this.dataTypes = dataTypes;
        this.size = dataTypes.length;
    }

    @Override
    public long getTime() {
        return (Long)this.rowRecord[this.size - 1];
    }

    @Override
    public int getInt(int columnIndex) {
        return (Integer)this.rowRecord[columnIndex];
    }

    @Override
    public long getLong(int columnIndex) {
        return (Long)this.rowRecord[columnIndex];
    }

    @Override
    public float getFloat(int columnIndex) {
        return ((Float)this.rowRecord[columnIndex]).floatValue();
    }

    @Override
    public double getDouble(int columnIndex) {
        return (Double)this.rowRecord[columnIndex];
    }

    @Override
    public boolean getBoolean(int columnIndex) {
        return (Boolean)this.rowRecord[columnIndex];
    }

    @Override
    public Binary getBinary(int columnIndex) {
        return RowImpl.transformToUDFBinary((org.apache.iotdb.tsfile.utils.Binary)this.rowRecord[columnIndex]);
    }

    @Override
    public String getString(int columnIndex) {
        return this.rowRecord[columnIndex].toString();
    }

    @Override
    public Type getDataType(int columnIndex) {
        return RowImpl.transformToUDFDataType(this.dataTypes[columnIndex]);
    }

    @Override
    public boolean isNull(int columnIndex) {
        return this.rowRecord[columnIndex] == null;
    }

    @Override
    public int size() {
        return this.size;
    }

    public void setRowRecord(Object[] rowRecord) {
        this.rowRecord = rowRecord;
    }

    public static Binary transformToUDFBinary(org.apache.iotdb.tsfile.utils.Binary binary) {
        return binary == null ? null : new Binary(binary.getValues());
    }

    private static Type transformToUDFDataType(TSDataType tsDataType) {
        if (tsDataType == null) {
            return null;
        }
        byte type = tsDataType.getType();
        switch (type) {
            case 0: {
                return Type.BOOLEAN;
            }
            case 1: {
                return Type.INT32;
            }
            case 2: {
                return Type.INT64;
            }
            case 3: {
                return Type.FLOAT;
            }
            case 4: {
                return Type.DOUBLE;
            }
            case 5: {
                return Type.TEXT;
            }
        }
        throw new IllegalArgumentException("Invalid input: " + type);
    }
}

