/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.subscription.topic;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.subscription.meta.topic.TopicMeta;
import org.apache.iotdb.confignode.consensus.request.write.subscription.topic.CreateTopicPlan;
import org.apache.iotdb.confignode.consensus.request.write.subscription.topic.DropTopicPlan;
import org.apache.iotdb.confignode.persistence.subscription.SubscriptionInfo;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.impl.subscription.AbstractOperateSubscriptionProcedure;
import org.apache.iotdb.confignode.procedure.impl.subscription.SubscriptionOperation;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.apache.iotdb.confignode.rpc.thrift.TCreateTopicReq;
import org.apache.iotdb.consensus.exception.ConsensusException;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.rpc.subscription.exception.SubscriptionException;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateTopicProcedure
extends AbstractOperateSubscriptionProcedure {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateTopicProcedure.class);
    private TCreateTopicReq createTopicReq;
    private TopicMeta topicMeta;

    public CreateTopicProcedure() {
    }

    public CreateTopicProcedure(TCreateTopicReq createTopicReq) throws SubscriptionException {
        this.createTopicReq = createTopicReq;
    }

    @Override
    protected SubscriptionOperation getOperation() {
        return SubscriptionOperation.CREATE_TOPIC;
    }

    @Override
    protected void executeFromValidate(ConfigNodeProcedureEnv env) throws SubscriptionException {
        LOGGER.info("CreateTopicProcedure: executeFromValidate");
        ((SubscriptionInfo)this.subscriptionInfo.get()).validateBeforeCreatingTopic(this.createTopicReq);
        this.topicMeta = new TopicMeta(this.createTopicReq.getTopicName(), System.currentTimeMillis(), this.createTopicReq.getTopicAttributes());
    }

    @Override
    protected void executeFromOperateOnConfigNodes(ConfigNodeProcedureEnv env) throws SubscriptionException {
        TSStatus response;
        LOGGER.info("CreateTopicProcedure: executeFromOperateOnConfigNodes({})", (Object)this.topicMeta.getTopicName());
        try {
            response = env.getConfigManager().getConsensusManager().write(new CreateTopicPlan(this.topicMeta));
        }
        catch (ConsensusException e) {
            LOGGER.warn("Failed in the write API executing the consensus layer due to: ", (Throwable)e);
            response = new TSStatus(TSStatusCode.CREATE_TOPIC_ERROR.getStatusCode()).setMessage(e.getMessage());
        }
        if (response.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new SubscriptionException(String.format("Failed to create topic %s on config nodes, because %s", this.topicMeta, response));
        }
    }

    @Override
    protected void executeFromOperateOnDataNodes(ConfigNodeProcedureEnv env) throws SubscriptionException {
        LOGGER.info("CreateTopicProcedure: executeFromOperateOnDataNodes({})", (Object)this.topicMeta.getTopicName());
        try {
            List<TSStatus> statuses = env.pushSingleTopicOnDataNode(this.topicMeta.serialize());
            if (RpcUtils.squashResponseStatusList(statuses).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                throw new SubscriptionException(String.format("Failed to create topic %s on data nodes, because %s", this.topicMeta, statuses));
            }
        }
        catch (IOException e) {
            LOGGER.warn("Failed to serialize the topic meta due to: ", (Throwable)e);
            throw new SubscriptionException(String.format("Failed to create topic %s on data nodes, because %s", this.topicMeta, e.getMessage()));
        }
    }

    @Override
    protected void rollbackFromValidate(ConfigNodeProcedureEnv env) {
        LOGGER.info("CreateTopicProcedure: rollbackFromValidate({})", (Object)this.topicMeta.getTopicName());
    }

    @Override
    protected void rollbackFromOperateOnConfigNodes(ConfigNodeProcedureEnv env) {
        TSStatus response;
        LOGGER.info("CreateTopicProcedure: rollbackFromCreateOnConfigNodes({})", (Object)this.topicMeta.getTopicName());
        try {
            response = env.getConfigManager().getConsensusManager().write(new DropTopicPlan(this.topicMeta.getTopicName()));
        }
        catch (ConsensusException e) {
            LOGGER.warn("Failed in the write API executing the consensus layer due to: ", (Throwable)e);
            response = new TSStatus(TSStatusCode.DROP_TOPIC_ERROR.getStatusCode()).setMessage(e.getMessage());
        }
        if (response.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new SubscriptionException(String.format("Failed to rollback topic %s on config nodes, because %s", this.topicMeta, response));
        }
    }

    @Override
    protected void rollbackFromOperateOnDataNodes(ConfigNodeProcedureEnv env) {
        LOGGER.info("CreateTopicProcedure: rollbackFromCreateOnDataNodes({})", (Object)this.topicMeta.getTopicName());
        List<TSStatus> statuses = env.dropSingleTopicOnDataNode(this.topicMeta.getTopicName());
        if (RpcUtils.squashResponseStatusList(statuses).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new SubscriptionException(String.format("Failed to rollback topic %s on data nodes, because %s", this.topicMeta, statuses));
        }
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeShort(ProcedureType.CREATE_TOPIC_PROCEDURE.getTypeCode());
        super.serialize(stream);
        ReadWriteIOUtils.write((String)this.createTopicReq.getTopicName(), (OutputStream)stream);
        int size = this.createTopicReq.getTopicAttributesSize();
        ReadWriteIOUtils.write((int)size, (OutputStream)stream);
        if (size != 0) {
            for (Map.Entry entry : this.createTopicReq.getTopicAttributes().entrySet()) {
                ReadWriteIOUtils.write((String)((String)entry.getKey()), (OutputStream)stream);
                ReadWriteIOUtils.write((String)((String)entry.getValue()), (OutputStream)stream);
            }
        }
        ReadWriteIOUtils.write((Boolean)(this.topicMeta != null ? 1 : 0), (OutputStream)stream);
        if (this.topicMeta != null) {
            this.topicMeta.serialize((OutputStream)stream);
        }
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        super.deserialize(byteBuffer);
        this.createTopicReq = new TCreateTopicReq();
        this.createTopicReq.setTopicName(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer));
        int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        for (int i = 0; i < size; ++i) {
            this.createTopicReq.putToTopicAttributes(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer), ReadWriteIOUtils.readString((ByteBuffer)byteBuffer));
        }
        if (ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer)) {
            this.topicMeta = TopicMeta.deserialize((ByteBuffer)byteBuffer);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateTopicProcedure that = (CreateTopicProcedure)o;
        return Objects.equals(this.getProcId(), that.getProcId()) && Objects.equals(this.getCurrentState(), that.getCurrentState()) && this.getCycles() == that.getCycles() && Objects.equals(this.createTopicReq, that.createTopicReq) && Objects.equals(this.topicMeta, that.topicMeta);
    }

    public int hashCode() {
        return Objects.hash(this.getProcId(), this.getCurrentState(), this.getCycles(), this.createTopicReq, this.topicMeta);
    }
}

