/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.subscription;

import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.concurrent.threadpool.ScheduledExecutorUtil;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.manager.ProcedureManager;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionMetaSyncer {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscriptionMetaSyncer.class);
    private static final ScheduledExecutorService SYNC_EXECUTOR = IoTDBThreadPoolFactory.newSingleThreadScheduledExecutor((String)ThreadName.SUBSCRIPTION_RUNTIME_META_SYNCER.getName());
    private static final long INITIAL_SYNC_DELAY_MINUTES = PipeConfig.getInstance().getPipeMetaSyncerInitialSyncDelayMinutes();
    private static final long SYNC_INTERVAL_MINUTES = PipeConfig.getInstance().getPipeMetaSyncerSyncIntervalMinutes();
    private final ConfigManager configManager;
    private Future<?> metaSyncFuture;
    private boolean isLastSubscriptionSyncSuccessful = false;

    SubscriptionMetaSyncer(ConfigManager configManager) {
        this.configManager = configManager;
    }

    public synchronized void start() {
        if (this.metaSyncFuture == null) {
            this.metaSyncFuture = ScheduledExecutorUtil.safelyScheduleWithFixedDelay((ScheduledExecutorService)SYNC_EXECUTOR, this::sync, (long)INITIAL_SYNC_DELAY_MINUTES, (long)SYNC_INTERVAL_MINUTES, (TimeUnit)TimeUnit.MINUTES);
            LOGGER.info("SubscriptionMetaSyncer is started successfully.");
        }
    }

    private synchronized void sync() {
        if (this.isLastSubscriptionSyncSuccessful && this.configManager.getSubscriptionManager().getSubscriptionCoordinator().canSkipNextSync()) {
            return;
        }
        this.isLastSubscriptionSyncSuccessful = false;
        if (this.configManager.getSubscriptionManager().getSubscriptionCoordinator().isLocked()) {
            LOGGER.warn("SubscriptionCoordinatorLock is held by another thread, skip this round of sync to avoid procedure and rpc accumulation as much as possible");
            return;
        }
        ProcedureManager procedureManager = this.configManager.getProcedureManager();
        TSStatus consumerGroupMetaSyncStatus = procedureManager.consumerGroupMetaSync();
        TSStatus topicMetaSyncStatus = procedureManager.topicMetaSync();
        if (consumerGroupMetaSyncStatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() && topicMetaSyncStatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            LOGGER.info("After this successful sync, if SubscriptionInfo is empty during this sync and has not been modified afterwards, all subsequent syncs will be skipped");
            this.isLastSubscriptionSyncSuccessful = true;
        } else {
            if (consumerGroupMetaSyncStatus.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                LOGGER.warn("Failed to sync consumer group meta. Result status: {}.", (Object)consumerGroupMetaSyncStatus);
            }
            if (topicMetaSyncStatus.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                LOGGER.warn("Failed to sync topic meta. Result status: {}.", (Object)topicMetaSyncStatus);
            }
        }
    }

    public synchronized void stop() {
        if (this.metaSyncFuture != null) {
            this.metaSyncFuture.cancel(false);
            this.metaSyncFuture = null;
            LOGGER.info("SubscriptionMetaSyncer is stopped successfully.");
        }
    }
}

