/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.pipe.connector.protocol;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.pipe.connector.client.IoTDBSyncClient;
import org.apache.iotdb.commons.pipe.connector.client.IoTDBSyncClientManager;
import org.apache.iotdb.commons.pipe.connector.payload.thrift.request.PipeTransferFilePieceReq;
import org.apache.iotdb.commons.pipe.connector.protocol.IoTDBSslSyncConnector;
import org.apache.iotdb.confignode.manager.pipe.connector.client.IoTDBConfigNodeSyncClientManager;
import org.apache.iotdb.confignode.manager.pipe.connector.payload.PipeTransferConfigPlanReq;
import org.apache.iotdb.confignode.manager.pipe.connector.payload.PipeTransferConfigSnapshotPieceReq;
import org.apache.iotdb.confignode.manager.pipe.connector.payload.PipeTransferConfigSnapshotSealReq;
import org.apache.iotdb.confignode.manager.pipe.event.PipeConfigRegionSnapshotEvent;
import org.apache.iotdb.confignode.manager.pipe.event.PipeConfigRegionWritePlanEvent;
import org.apache.iotdb.db.pipe.event.common.heartbeat.PipeHeartbeatEvent;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.event.dml.insertion.TsFileInsertionEvent;
import org.apache.iotdb.pipe.api.exception.PipeConnectionException;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferResp;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBConfigRegionConnector
extends IoTDBSslSyncConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTDBConfigRegionConnector.class);

    protected IoTDBSyncClientManager constructClient(List<TEndPoint> nodeUrls, boolean useSSL, String trustStorePath, String trustStorePwd, boolean useLeaderCache, String loadBalanceStrategy) {
        return new IoTDBConfigNodeSyncClientManager(nodeUrls, useSSL, trustStorePath, trustStorePwd, loadBalanceStrategy);
    }

    protected PipeTransferFilePieceReq getTransferSingleFilePieceReq(String fileName, long position, byte[] payLoad) {
        throw new UnsupportedOperationException("The config region connector does not support transferring single file piece req.");
    }

    protected PipeTransferFilePieceReq getTransferMultiFilePieceReq(String fileName, long position, byte[] payLoad) throws IOException {
        return PipeTransferConfigSnapshotPieceReq.toTPipeTransferReq(fileName, position, payLoad);
    }

    public void transfer(TabletInsertionEvent tabletInsertionEvent) throws Exception {
        throw new UnsupportedOperationException("IoTDBConfigRegionConnector can't transfer TabletInsertionEvent.");
    }

    public void transfer(TsFileInsertionEvent tsFileInsertionEvent) throws Exception {
        throw new UnsupportedOperationException("IoTDBConfigRegionConnector can't transfer TsFileInsertionEvent.");
    }

    public void transfer(Event event) throws Exception {
        if (event instanceof PipeConfigRegionWritePlanEvent) {
            this.doTransferWrapper((PipeConfigRegionWritePlanEvent)event);
        } else if (event instanceof PipeConfigRegionSnapshotEvent) {
            this.doTransferWrapper((PipeConfigRegionSnapshotEvent)event);
        } else if (!(event instanceof PipeHeartbeatEvent)) {
            LOGGER.warn("IoTDBConfigRegionConnector does not support transferring generic event: {}.", (Object)event);
        }
    }

    private void doTransferWrapper(PipeConfigRegionWritePlanEvent pipeConfigRegionWritePlanEvent) throws PipeException {
        try {
            if (!pipeConfigRegionWritePlanEvent.increaseReferenceCount(IoTDBConfigRegionConnector.class.getName())) {
                return;
            }
            this.doTransfer(pipeConfigRegionWritePlanEvent);
        }
        finally {
            pipeConfigRegionWritePlanEvent.decreaseReferenceCount(IoTDBConfigRegionConnector.class.getName(), false);
        }
    }

    private void doTransfer(PipeConfigRegionWritePlanEvent pipeConfigRegionWritePlanEvent) throws PipeException {
        TPipeTransferResp resp;
        Pair clientAndStatus = this.clientManager.getClient();
        try {
            resp = ((IoTDBSyncClient)clientAndStatus.getLeft()).pipeTransfer((TPipeTransferReq)PipeTransferConfigPlanReq.toTPipeTransferReq(pipeConfigRegionWritePlanEvent.getConfigPhysicalPlan()));
        }
        catch (Exception e) {
            clientAndStatus.setRight((Object)false);
            throw new PipeConnectionException(String.format("Network error when transfer config region write plan %s, because %s.", new Object[]{pipeConfigRegionWritePlanEvent.getConfigPhysicalPlan().getType(), e.getMessage()}), (Throwable)e);
        }
        TSStatus status = resp.getStatus();
        if (status.getCode() == TSStatusCode.PIPE_CONFIG_RECEIVER_HANDSHAKE_NEEDED.getStatusCode()) {
            this.clientManager.sendHandshakeReq(clientAndStatus);
        }
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode() && status.getCode() != TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()) {
            this.receiverStatusHandler.handle(status, String.format("Transfer config region write plan %s error, result status %s.", new Object[]{pipeConfigRegionWritePlanEvent.getConfigPhysicalPlan().getType(), status}), pipeConfigRegionWritePlanEvent.getConfigPhysicalPlan().toString());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Successfully transferred config event {}.", (Object)pipeConfigRegionWritePlanEvent);
        }
    }

    private void doTransferWrapper(PipeConfigRegionSnapshotEvent pipeConfigRegionSnapshotEvent) throws PipeException, IOException {
        try {
            if (!pipeConfigRegionSnapshotEvent.increaseReferenceCount(IoTDBConfigRegionConnector.class.getName())) {
                return;
            }
            this.doTransfer(pipeConfigRegionSnapshotEvent);
        }
        finally {
            pipeConfigRegionSnapshotEvent.decreaseReferenceCount(IoTDBConfigRegionConnector.class.getName(), false);
        }
    }

    private void doTransfer(PipeConfigRegionSnapshotEvent snapshotEvent) throws PipeException, IOException {
        TPipeTransferResp resp;
        File snapshotFile = snapshotEvent.getSnapshotFile();
        File templateFile = snapshotEvent.getTemplateFile();
        Pair clientAndStatus = this.clientManager.getClient();
        this.transferFilePieces(snapshotFile, clientAndStatus, true);
        if (Objects.nonNull(templateFile)) {
            this.transferFilePieces(templateFile, clientAndStatus, true);
        }
        try {
            resp = ((IoTDBSyncClient)clientAndStatus.getLeft()).pipeTransfer((TPipeTransferReq)PipeTransferConfigSnapshotSealReq.toTPipeTransferReq(snapshotFile.getName(), snapshotFile.length(), Objects.nonNull(templateFile) ? templateFile.getName() : null, Objects.nonNull(templateFile) ? templateFile.length() : 0L, snapshotEvent.getFileType(), snapshotEvent.toSealTypeString()));
        }
        catch (Exception e) {
            clientAndStatus.setRight((Object)false);
            throw new PipeConnectionException(String.format("Network error when seal config region snapshot %s, because %s.", snapshotFile, e.getMessage()), (Throwable)e);
        }
        TSStatus status = resp.getStatus();
        if (status.getCode() == TSStatusCode.PIPE_CONFIG_RECEIVER_HANDSHAKE_NEEDED.getStatusCode()) {
            this.clientManager.sendHandshakeReq(clientAndStatus);
        }
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode() && status.getCode() != TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()) {
            this.receiverStatusHandler.handle(status, String.format("Seal config region snapshot file %s error, result status %s.", snapshotFile, resp.getStatus()), snapshotFile.toString());
        }
        LOGGER.info("Successfully transferred config region snapshot {}.", (Object)snapshotFile);
    }
}

