/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.cache.node;

import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.confignode.manager.load.cache.AbstractHeartbeatSample;
import org.apache.iotdb.confignode.rpc.thrift.TConfigNodeHeartbeatResp;
import org.apache.iotdb.mpp.rpc.thrift.TDataNodeHeartbeatResp;
import org.apache.iotdb.mpp.rpc.thrift.TLoadSample;

public class NodeHeartbeatSample
extends AbstractHeartbeatSample {
    private final NodeStatus status;
    private final String statusReason;
    private final TLoadSample loadSample;

    public NodeHeartbeatSample(NodeStatus status) {
        super(System.nanoTime());
        this.status = status;
        this.statusReason = null;
        this.loadSample = null;
    }

    public NodeHeartbeatSample(long sampleNanoTimestamp, NodeStatus status) {
        super(sampleNanoTimestamp);
        this.status = status;
        this.statusReason = null;
        this.loadSample = null;
    }

    public NodeHeartbeatSample(TDataNodeHeartbeatResp heartbeatResp) {
        super(heartbeatResp.getHeartbeatTimestamp());
        this.status = NodeStatus.parse((String)heartbeatResp.getStatus());
        this.statusReason = heartbeatResp.isSetStatusReason() ? heartbeatResp.getStatusReason() : null;
        this.loadSample = heartbeatResp.isSetLoadSample() ? heartbeatResp.getLoadSample() : null;
    }

    public NodeHeartbeatSample(TConfigNodeHeartbeatResp heartbeatResp) {
        super(heartbeatResp.getTimestamp());
        this.status = NodeStatus.Running;
        this.statusReason = null;
        this.loadSample = null;
    }

    public NodeStatus getStatus() {
        return this.status;
    }

    public String getStatusReason() {
        return this.statusReason;
    }

    public boolean isSetLoadSample() {
        return this.loadSample != null;
    }

    public TLoadSample getLoadSample() {
        return this.loadSample;
    }
}

