/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TConfigNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeConfiguration;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TFlushReq;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.common.rpc.thrift.TSchemaNode;
import org.apache.iotdb.common.rpc.thrift.TSeriesPartitionSlot;
import org.apache.iotdb.common.rpc.thrift.TSetSpaceQuotaReq;
import org.apache.iotdb.common.rpc.thrift.TSetThrottleQuotaReq;
import org.apache.iotdb.commons.auth.AuthException;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.commons.cluster.NodeType;
import org.apache.iotdb.commons.conf.CommonConfig;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.path.PathPatternUtil;
import org.apache.iotdb.commons.pipe.connector.payload.airgap.AirGapPseudoTPipeTransferRequest;
import org.apache.iotdb.commons.schema.SchemaConstant;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.commons.utils.AuthUtils;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.iotdb.commons.utils.StatusUtils;
import org.apache.iotdb.confignode.conf.ConfigNodeConfig;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.conf.SystemPropertiesUtils;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.iotdb.confignode.consensus.request.auth.AuthorPlan;
import org.apache.iotdb.confignode.consensus.request.read.database.CountDatabasePlan;
import org.apache.iotdb.confignode.consensus.request.read.database.GetDatabasePlan;
import org.apache.iotdb.confignode.consensus.request.read.datanode.GetDataNodeConfigurationPlan;
import org.apache.iotdb.confignode.consensus.request.read.partition.GetDataPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.read.partition.GetNodePathsPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.read.partition.GetOrCreateDataPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.read.partition.GetOrCreateSchemaPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.read.partition.GetSchemaPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.read.region.GetRegionInfoListPlan;
import org.apache.iotdb.confignode.consensus.request.write.confignode.RemoveConfigNodePlan;
import org.apache.iotdb.confignode.consensus.request.write.database.DatabaseSchemaPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.SetDataReplicationFactorPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.SetSchemaReplicationFactorPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.SetTTLPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.SetTimePartitionIntervalPlan;
import org.apache.iotdb.confignode.consensus.request.write.datanode.RemoveDataNodePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.CreateSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.response.auth.PermissionInfoResp;
import org.apache.iotdb.confignode.consensus.response.database.CountDatabaseResp;
import org.apache.iotdb.confignode.consensus.response.database.DatabaseSchemaResp;
import org.apache.iotdb.confignode.consensus.response.datanode.ConfigurationResp;
import org.apache.iotdb.confignode.consensus.response.datanode.DataNodeConfigurationResp;
import org.apache.iotdb.confignode.consensus.response.datanode.DataNodeRegisterResp;
import org.apache.iotdb.confignode.consensus.response.datanode.DataNodeToStatusResp;
import org.apache.iotdb.confignode.consensus.response.partition.DataPartitionResp;
import org.apache.iotdb.confignode.consensus.response.partition.RegionInfoListResp;
import org.apache.iotdb.confignode.consensus.response.partition.SchemaNodeManagementResp;
import org.apache.iotdb.confignode.consensus.response.partition.SchemaPartitionResp;
import org.apache.iotdb.confignode.consensus.response.template.TemplateSetInfoResp;
import org.apache.iotdb.confignode.consensus.statemachine.ConfigRegionStateMachine;
import org.apache.iotdb.confignode.manager.ClusterManager;
import org.apache.iotdb.confignode.manager.ClusterQuotaManager;
import org.apache.iotdb.confignode.manager.IManager;
import org.apache.iotdb.confignode.manager.PermissionManager;
import org.apache.iotdb.confignode.manager.ProcedureManager;
import org.apache.iotdb.confignode.manager.RetryFailedTasksThread;
import org.apache.iotdb.confignode.manager.TriggerManager;
import org.apache.iotdb.confignode.manager.UDFManager;
import org.apache.iotdb.confignode.manager.consensus.ConsensusManager;
import org.apache.iotdb.confignode.manager.cq.CQManager;
import org.apache.iotdb.confignode.manager.load.LoadManager;
import org.apache.iotdb.confignode.manager.load.cache.node.NodeHeartbeatSample;
import org.apache.iotdb.confignode.manager.node.ClusterNodeStartUtils;
import org.apache.iotdb.confignode.manager.node.NodeManager;
import org.apache.iotdb.confignode.manager.node.NodeMetrics;
import org.apache.iotdb.confignode.manager.partition.PartitionManager;
import org.apache.iotdb.confignode.manager.partition.PartitionMetrics;
import org.apache.iotdb.confignode.manager.pipe.agent.PipeConfigNodeAgent;
import org.apache.iotdb.confignode.manager.pipe.coordinator.PipeManager;
import org.apache.iotdb.confignode.manager.schema.ClusterSchemaManager;
import org.apache.iotdb.confignode.manager.schema.ClusterSchemaQuotaStatistics;
import org.apache.iotdb.confignode.manager.subscription.SubscriptionManager;
import org.apache.iotdb.confignode.persistence.AuthorInfo;
import org.apache.iotdb.confignode.persistence.ClusterInfo;
import org.apache.iotdb.confignode.persistence.ProcedureInfo;
import org.apache.iotdb.confignode.persistence.TriggerInfo;
import org.apache.iotdb.confignode.persistence.UDFInfo;
import org.apache.iotdb.confignode.persistence.cq.CQInfo;
import org.apache.iotdb.confignode.persistence.executor.ConfigPlanExecutor;
import org.apache.iotdb.confignode.persistence.node.NodeInfo;
import org.apache.iotdb.confignode.persistence.partition.PartitionInfo;
import org.apache.iotdb.confignode.persistence.pipe.PipeInfo;
import org.apache.iotdb.confignode.persistence.quota.QuotaInfo;
import org.apache.iotdb.confignode.persistence.schema.ClusterSchemaInfo;
import org.apache.iotdb.confignode.persistence.subscription.SubscriptionInfo;
import org.apache.iotdb.confignode.rpc.thrift.TAlterLogicalViewReq;
import org.apache.iotdb.confignode.rpc.thrift.TAlterPipeReq;
import org.apache.iotdb.confignode.rpc.thrift.TAlterSchemaTemplateReq;
import org.apache.iotdb.confignode.rpc.thrift.TAuthizedPatternTreeResp;
import org.apache.iotdb.confignode.rpc.thrift.TCloseConsumerReq;
import org.apache.iotdb.confignode.rpc.thrift.TClusterParameters;
import org.apache.iotdb.confignode.rpc.thrift.TConfigNodeRegisterReq;
import org.apache.iotdb.confignode.rpc.thrift.TConfigNodeRegisterResp;
import org.apache.iotdb.confignode.rpc.thrift.TCountTimeSlotListReq;
import org.apache.iotdb.confignode.rpc.thrift.TCountTimeSlotListResp;
import org.apache.iotdb.confignode.rpc.thrift.TCreateCQReq;
import org.apache.iotdb.confignode.rpc.thrift.TCreateConsumerReq;
import org.apache.iotdb.confignode.rpc.thrift.TCreateFunctionReq;
import org.apache.iotdb.confignode.rpc.thrift.TCreatePipePluginReq;
import org.apache.iotdb.confignode.rpc.thrift.TCreatePipeReq;
import org.apache.iotdb.confignode.rpc.thrift.TCreateSchemaTemplateReq;
import org.apache.iotdb.confignode.rpc.thrift.TCreateTopicReq;
import org.apache.iotdb.confignode.rpc.thrift.TCreateTriggerReq;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeRegisterReq;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeRestartReq;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeRestartResp;
import org.apache.iotdb.confignode.rpc.thrift.TDataPartitionTableResp;
import org.apache.iotdb.confignode.rpc.thrift.TDatabaseSchema;
import org.apache.iotdb.confignode.rpc.thrift.TDeactivateSchemaTemplateReq;
import org.apache.iotdb.confignode.rpc.thrift.TDeleteDatabasesReq;
import org.apache.iotdb.confignode.rpc.thrift.TDeleteLogicalViewReq;
import org.apache.iotdb.confignode.rpc.thrift.TDeleteTimeSeriesReq;
import org.apache.iotdb.confignode.rpc.thrift.TDropCQReq;
import org.apache.iotdb.confignode.rpc.thrift.TDropTriggerReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetAllPipeInfoResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetAllSubscriptionInfoResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetAllTemplatesResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetAllTopicInfoResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetDataNodeLocationsResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetDatabaseReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetJarInListReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetJarInListResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetLocationForTriggerResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetPathsSetTemplatesReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetPathsSetTemplatesResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetPipePluginTableResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetRegionIdReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetRegionIdResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetSeriesSlotListReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetSeriesSlotListResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetTemplateResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetTimeSlotListReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetTimeSlotListResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetTriggerTableResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetUDFTableResp;
import org.apache.iotdb.confignode.rpc.thrift.TMigrateRegionReq;
import org.apache.iotdb.confignode.rpc.thrift.TNodeVersionInfo;
import org.apache.iotdb.confignode.rpc.thrift.TPermissionInfoResp;
import org.apache.iotdb.confignode.rpc.thrift.TPipeConfigTransferReq;
import org.apache.iotdb.confignode.rpc.thrift.TPipeConfigTransferResp;
import org.apache.iotdb.confignode.rpc.thrift.TRegionRouteMapResp;
import org.apache.iotdb.confignode.rpc.thrift.TSchemaNodeManagementResp;
import org.apache.iotdb.confignode.rpc.thrift.TSchemaPartitionTableResp;
import org.apache.iotdb.confignode.rpc.thrift.TSetDataNodeStatusReq;
import org.apache.iotdb.confignode.rpc.thrift.TSetSchemaTemplateReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowCQResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowClusterResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowConfigNodesResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowDataNodesResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowDatabaseResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowPipeReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowPipeResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowSubscriptionReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowSubscriptionResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowThrottleReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowTopicReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowTopicResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowVariablesResp;
import org.apache.iotdb.confignode.rpc.thrift.TSpaceQuotaResp;
import org.apache.iotdb.confignode.rpc.thrift.TSubscribeReq;
import org.apache.iotdb.confignode.rpc.thrift.TThrottleQuotaResp;
import org.apache.iotdb.confignode.rpc.thrift.TTimeSlotList;
import org.apache.iotdb.confignode.rpc.thrift.TUnsetSchemaTemplateReq;
import org.apache.iotdb.confignode.rpc.thrift.TUnsubscribeReq;
import org.apache.iotdb.consensus.common.DataSet;
import org.apache.iotdb.consensus.exception.ConsensusException;
import org.apache.iotdb.db.schemaengine.template.Template;
import org.apache.iotdb.db.schemaengine.template.TemplateAlterOperationType;
import org.apache.iotdb.db.schemaengine.template.alter.TemplateAlterOperationUtil;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferResp;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigManager
implements IManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigManager.class);
    private static final ConfigNodeConfig CONF = ConfigNodeDescriptor.getInstance().getConf();
    private static final CommonConfig COMMON_CONF = CommonDescriptor.getInstance().getConfig();
    private final AtomicReference<ConsensusManager> consensusManager = new AtomicReference();
    private final ClusterManager clusterManager;
    private final NodeManager nodeManager;
    private final ClusterSchemaManager clusterSchemaManager;
    private final PartitionManager partitionManager;
    private final PermissionManager permissionManager;
    private final LoadManager loadManager;
    private final ProcedureManager procedureManager;
    private final UDFManager udfManager;
    private final TriggerManager triggerManager;
    private final CQManager cqManager;
    private final PipeManager pipeManager;
    private final ClusterQuotaManager clusterQuotaManager;
    private final SubscriptionManager subscriptionManager;
    private final ConfigRegionStateMachine stateMachine;
    private final RetryFailedTasksThread retryFailedTasksThread;
    private static final String DATABASE = "\tDatabase=";

    public ConfigManager() throws IOException {
        ClusterInfo clusterInfo = new ClusterInfo();
        NodeInfo nodeInfo = new NodeInfo();
        ClusterSchemaInfo clusterSchemaInfo = new ClusterSchemaInfo();
        PartitionInfo partitionInfo = new PartitionInfo();
        AuthorInfo authorInfo = new AuthorInfo();
        ProcedureInfo procedureInfo = new ProcedureInfo(this);
        UDFInfo udfInfo = new UDFInfo();
        TriggerInfo triggerInfo = new TriggerInfo();
        CQInfo cqInfo = new CQInfo();
        PipeInfo pipeInfo = new PipeInfo();
        QuotaInfo quotaInfo = new QuotaInfo();
        SubscriptionInfo subscriptionInfo = new SubscriptionInfo();
        ConfigPlanExecutor executor = new ConfigPlanExecutor(clusterInfo, nodeInfo, clusterSchemaInfo, partitionInfo, authorInfo, procedureInfo, udfInfo, triggerInfo, cqInfo, pipeInfo, subscriptionInfo, quotaInfo);
        this.stateMachine = new ConfigRegionStateMachine(this, executor);
        this.clusterManager = new ClusterManager(this, clusterInfo);
        this.nodeManager = new NodeManager(this, nodeInfo);
        this.clusterSchemaManager = new ClusterSchemaManager(this, clusterSchemaInfo, new ClusterSchemaQuotaStatistics(COMMON_CONF.getSeriesLimitThreshold(), COMMON_CONF.getDeviceLimitThreshold()));
        this.partitionManager = new PartitionManager(this, partitionInfo);
        this.permissionManager = new PermissionManager(this, authorInfo);
        this.procedureManager = new ProcedureManager(this, procedureInfo);
        this.udfManager = new UDFManager(this, udfInfo);
        this.triggerManager = new TriggerManager(this, triggerInfo);
        this.cqManager = new CQManager(this);
        this.pipeManager = new PipeManager(this, pipeInfo);
        this.subscriptionManager = new SubscriptionManager(this, subscriptionInfo);
        this.loadManager = new LoadManager(this);
        this.retryFailedTasksThread = new RetryFailedTasksThread(this);
        this.clusterQuotaManager = new ClusterQuotaManager(this, quotaInfo);
    }

    public void initConsensusManager() throws IOException {
        this.consensusManager.set(new ConsensusManager(this, this.stateMachine));
        this.consensusManager.get().start();
    }

    public void close() throws IOException {
        if (this.consensusManager.get() != null) {
            this.consensusManager.get().close();
        }
        if (this.partitionManager != null) {
            this.partitionManager.getRegionMaintainer().shutdown();
        }
        if (this.procedureManager != null) {
            this.procedureManager.stopExecutor();
        }
    }

    @Override
    public DataSet getSystemConfiguration() {
        ConfigurationResp dataSet;
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() || ConfigNodeDescriptor.getInstance().isSeedConfigNode() || SystemPropertiesUtils.isSeedConfigNode()) {
            dataSet = (ConfigurationResp)this.nodeManager.getSystemConfiguration();
        } else {
            dataSet = new ConfigurationResp();
            dataSet.setStatus(status);
        }
        return dataSet;
    }

    @Override
    public DataSet registerDataNode(TDataNodeRegisterReq req) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() && (status = ClusterNodeStartUtils.confirmNodeRegistration(NodeType.DataNode, req.getClusterName(), req.getDataNodeConfiguration().getLocation(), this)).getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.nodeManager.registerDataNode(req);
        }
        DataNodeRegisterResp resp = new DataNodeRegisterResp();
        resp.setStatus(status);
        resp.setConfigNodeList(this.getNodeManager().getRegisteredConfigNodes());
        return resp;
    }

    @Override
    public TDataNodeRestartResp restartDataNode(TDataNodeRestartReq req) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() && (status = ClusterNodeStartUtils.confirmNodeRestart(NodeType.DataNode, req.getClusterName(), req.getDataNodeConfiguration().getLocation().getDataNodeId(), req.getDataNodeConfiguration().getLocation(), this)).getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.nodeManager.updateDataNodeIfNecessary(req);
        }
        return new TDataNodeRestartResp().setStatus(status).setConfigNodeList(this.getNodeManager().getRegisteredConfigNodes());
    }

    @Override
    public DataSet removeDataNode(RemoveDataNodePlan removeDataNodePlan) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.nodeManager.removeDataNode(removeDataNodePlan);
        }
        DataNodeToStatusResp dataSet = new DataNodeToStatusResp();
        dataSet.setStatus(status);
        return dataSet;
    }

    @Override
    public TSStatus reportDataNodeShutdown(TDataNodeLocation dataNodeLocation) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            this.getLoadManager().forceUpdateNodeCache(NodeType.DataNode, dataNodeLocation.getDataNodeId(), new NodeHeartbeatSample(NodeStatus.Unknown));
            LOGGER.info("[ShutdownHook] The DataNode-{} will be shutdown soon, mark it as Unknown", (Object)dataNodeLocation.getDataNodeId());
        }
        return status;
    }

    @Override
    public DataSet getDataNodeConfiguration(GetDataNodeConfigurationPlan getDataNodeConfigurationPlan) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.nodeManager.getDataNodeConfiguration(getDataNodeConfigurationPlan);
        }
        DataNodeConfigurationResp dataSet = new DataNodeConfigurationResp();
        dataSet.setStatus(status);
        return dataSet;
    }

    @Override
    public TShowClusterResp showCluster() {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            List<TConfigNodeLocation> configNodeLocations = this.getNodeManager().getRegisteredConfigNodes();
            configNodeLocations.sort(Comparator.comparingInt(TConfigNodeLocation::getConfigNodeId));
            List<TDataNodeLocation> dataNodeLocations = this.getNodeManager().getRegisteredDataNodes().stream().map(TDataNodeConfiguration::getLocation).sorted(Comparator.comparingInt(TDataNodeLocation::getDataNodeId)).collect(Collectors.toList());
            Map<Integer, TNodeVersionInfo> nodeVersionInfo = this.getNodeManager().getNodeVersionInfo();
            Map<Integer, String> nodeStatus = this.getLoadManager().getNodeStatusWithReason();
            configNodeLocations.forEach(configNodeLocation -> nodeStatus.putIfAbsent(configNodeLocation.getConfigNodeId(), NodeStatus.Unknown.toString()));
            dataNodeLocations.forEach(dataNodeLocation -> nodeStatus.putIfAbsent(dataNodeLocation.getDataNodeId(), NodeStatus.Unknown.toString()));
            return new TShowClusterResp(status, configNodeLocations, dataNodeLocations, nodeStatus, nodeVersionInfo);
        }
        return new TShowClusterResp(status, new ArrayList(), new ArrayList(), new HashMap(), new HashMap());
    }

    @Override
    public TShowVariablesResp showVariables() {
        TSStatus status = this.confirmLeader();
        TShowVariablesResp resp = new TShowVariablesResp();
        resp.setStatus(status);
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            resp.setClusterParameters(this.getClusterParameters());
        }
        return resp;
    }

    public TClusterParameters getClusterParameters() {
        TClusterParameters clusterParameters = new TClusterParameters();
        clusterParameters.setClusterName(CONF.getClusterName());
        clusterParameters.setConfigNodeConsensusProtocolClass(CONF.getConfigNodeConsensusProtocolClass());
        clusterParameters.setDataRegionConsensusProtocolClass(CONF.getDataRegionConsensusProtocolClass());
        clusterParameters.setSchemaRegionConsensusProtocolClass(CONF.getSchemaRegionConsensusProtocolClass());
        clusterParameters.setSeriesPartitionSlotNum(CONF.getSeriesSlotNum());
        clusterParameters.setSeriesPartitionExecutorClass(CONF.getSeriesPartitionExecutorClass());
        clusterParameters.setDefaultTTL(COMMON_CONF.getDefaultTTLInMs());
        clusterParameters.setTimePartitionInterval(COMMON_CONF.getTimePartitionInterval());
        clusterParameters.setDataReplicationFactor(CONF.getDataReplicationFactor());
        clusterParameters.setSchemaReplicationFactor(CONF.getSchemaReplicationFactor());
        clusterParameters.setDataRegionPerDataNode(CONF.getDataRegionPerDataNode());
        clusterParameters.setSchemaRegionPerDataNode(CONF.getSchemaRegionPerDataNode());
        clusterParameters.setDiskSpaceWarningThreshold(COMMON_CONF.getDiskSpaceWarningThreshold());
        clusterParameters.setReadConsistencyLevel(CONF.getReadConsistencyLevel());
        clusterParameters.setTimestampPrecision(COMMON_CONF.getTimestampPrecision());
        clusterParameters.setSchemaEngineMode(COMMON_CONF.getSchemaEngineMode());
        clusterParameters.setTagAttributeTotalSize(COMMON_CONF.getTagAttributeTotalSize());
        clusterParameters.setDatabaseLimitThreshold(COMMON_CONF.getDatabaseLimitThreshold());
        return clusterParameters;
    }

    @Override
    public TSStatus setTTL(SetTTLPlan setTTLPlan) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.clusterSchemaManager.setTTL(setTTLPlan, false);
        }
        return status;
    }

    @Override
    public TSStatus setSchemaReplicationFactor(SetSchemaReplicationFactorPlan setSchemaReplicationFactorPlan) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.clusterSchemaManager.setSchemaReplicationFactor(setSchemaReplicationFactorPlan);
        }
        return status;
    }

    @Override
    public TSStatus setDataReplicationFactor(SetDataReplicationFactorPlan setDataReplicationFactorPlan) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.clusterSchemaManager.setDataReplicationFactor(setDataReplicationFactorPlan);
        }
        return status;
    }

    @Override
    public TSStatus setTimePartitionInterval(SetTimePartitionIntervalPlan setTimePartitionIntervalPlan) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.clusterSchemaManager.setTimePartitionInterval(setTimePartitionIntervalPlan);
        }
        return status;
    }

    @Override
    public DataSet countMatchedDatabases(CountDatabasePlan countDatabasePlan) {
        TSStatus status = this.confirmLeader();
        CountDatabaseResp result = new CountDatabaseResp();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.clusterSchemaManager.countMatchedDatabases(countDatabasePlan);
        }
        result.setStatus(status);
        return result;
    }

    @Override
    public DataSet getMatchedDatabaseSchemas(GetDatabasePlan getDatabaseReq) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.clusterSchemaManager.getMatchedDatabaseSchema(getDatabaseReq);
        }
        DatabaseSchemaResp dataSet = new DatabaseSchemaResp();
        dataSet.setStatus(status);
        return dataSet;
    }

    @Override
    public TSStatus setDatabase(DatabaseSchemaPlan databaseSchemaPlan) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.clusterSchemaManager.setDatabase(databaseSchemaPlan, false);
        }
        return status;
    }

    @Override
    public TSStatus alterDatabase(DatabaseSchemaPlan databaseSchemaPlan) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.clusterSchemaManager.alterDatabase(databaseSchemaPlan, false);
        }
        return status;
    }

    @Override
    public synchronized TSStatus deleteDatabases(TDeleteDatabasesReq tDeleteReq) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            List deletedPaths = tDeleteReq.getPrefixPathList();
            Map<String, TDatabaseSchema> deleteDatabaseSchemaMap = this.getClusterSchemaManager().getMatchedDatabaseSchemasByName(deletedPaths);
            if (deleteDatabaseSchemaMap.isEmpty()) {
                return RpcUtils.getStatus((int)TSStatusCode.PATH_NOT_EXIST.getStatusCode(), (String)String.format("Path %s does not exist", Arrays.toString(deletedPaths.toArray())));
            }
            ArrayList<TDatabaseSchema> parsedDeleteDatabases = new ArrayList<TDatabaseSchema>(deleteDatabaseSchemaMap.values());
            return this.procedureManager.deleteDatabases(parsedDeleteDatabases, tDeleteReq.isSetIsGeneratedByPipe() && tDeleteReq.isIsGeneratedByPipe());
        }
        return status;
    }

    private List<TSeriesPartitionSlot> calculateRelatedSlot(PartialPath path, PartialPath database) {
        if (path.getFullPath().contains("**")) {
            return new ArrayList<TSeriesPartitionSlot>();
        }
        List innerPathList = path.alterPrefixPath(database);
        if (innerPathList.isEmpty()) {
            return new ArrayList<TSeriesPartitionSlot>();
        }
        PartialPath innerPath = (PartialPath)innerPathList.get(0);
        if (innerPath.getDevice().contains("*")) {
            return new ArrayList<TSeriesPartitionSlot>();
        }
        return Collections.singletonList(this.getPartitionManager().getSeriesPartitionSlot(innerPath.getDevice()));
    }

    @Override
    public TSchemaPartitionTableResp getSchemaPartition(PathPatternTree patternTree) {
        TSchemaPartitionTableResp resp = new TSchemaPartitionTableResp();
        TSStatus status = this.confirmLeader();
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return resp.setStatus(status);
        }
        HashMap<String, Set> partitionSlotsMap = new HashMap<String, Set>();
        List relatedPaths = patternTree.getAllPathPatterns();
        List<String> allDatabases = this.getClusterSchemaManager().getDatabaseNames();
        ArrayList<PartialPath> allDatabasePaths = new ArrayList<PartialPath>();
        for (String string : allDatabases) {
            try {
                allDatabasePaths.add(new PartialPath(string));
            }
            catch (IllegalPathException e2) {
                throw new RuntimeException(e2);
            }
        }
        HashMap<String, Boolean> scanAllRegions = new HashMap<String, Boolean>();
        for (PartialPath path : relatedPaths) {
            for (int i = 0; i < allDatabases.size(); ++i) {
                String database = allDatabases.get(i);
                PartialPath databasePath = (PartialPath)allDatabasePaths.get(i);
                if (!path.overlapWithFullPathPrefix(databasePath) || scanAllRegions.containsKey(database)) continue;
                List<TSeriesPartitionSlot> relatedSlot = this.calculateRelatedSlot(path, databasePath);
                if (relatedSlot.isEmpty()) {
                    scanAllRegions.put(database, true);
                    partitionSlotsMap.put(database, new HashSet());
                    continue;
                }
                partitionSlotsMap.computeIfAbsent(database, k -> new HashSet()).addAll(relatedSlot);
            }
        }
        if (partitionSlotsMap.isEmpty()) {
            return resp.setStatus(StatusUtils.OK).setSchemaPartitionTable(new HashMap());
        }
        GetSchemaPartitionPlan getSchemaPartitionPlan = new GetSchemaPartitionPlan(partitionSlotsMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new ArrayList((Collection)e.getValue()))));
        SchemaPartitionResp queryResult = this.partitionManager.getSchemaPartition(getSchemaPartitionPlan);
        resp = queryResult.convertToRpcSchemaPartitionTableResp();
        LOGGER.debug("GetSchemaPartition receive paths: {}, return: {}", (Object)relatedPaths, (Object)resp);
        return resp;
    }

    @Override
    public TSchemaPartitionTableResp getOrCreateSchemaPartition(PathPatternTree patternTree) {
        TSchemaPartitionTableResp resp = new TSchemaPartitionTableResp();
        TSStatus status = this.confirmLeader();
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return resp.setStatus(status);
        }
        List devicePaths = patternTree.getAllDevicePatterns();
        List<String> databases = this.getClusterSchemaManager().getDatabaseNames();
        HashMap<String, List<TSeriesPartitionSlot>> partitionSlotsMap = new HashMap<String, List<TSeriesPartitionSlot>>();
        block0: for (String devicePath : devicePaths) {
            for (String database : databases) {
                if (!PathUtils.isStartWith((String)devicePath, (String)database)) continue;
                partitionSlotsMap.computeIfAbsent(database, key -> new ArrayList()).add(this.getPartitionManager().getSeriesPartitionSlot(devicePath));
                continue block0;
            }
        }
        GetOrCreateSchemaPartitionPlan getOrCreateSchemaPartitionPlan = new GetOrCreateSchemaPartitionPlan(partitionSlotsMap);
        SchemaPartitionResp queryResult = this.partitionManager.getOrCreateSchemaPartition(getOrCreateSchemaPartitionPlan);
        resp = queryResult.convertToRpcSchemaPartitionTableResp();
        if (CONF.isEnablePrintingNewlyCreatedPartition()) {
            this.printNewCreatedSchemaPartition(devicePaths, resp);
        }
        return resp;
    }

    private void printNewCreatedSchemaPartition(List<String> devicePaths, TSchemaPartitionTableResp resp) {
        String lineSeparator = System.lineSeparator();
        StringBuilder devicePathString = new StringBuilder("{");
        for (String devicePath : devicePaths) {
            devicePathString.append(lineSeparator).append("\t").append(devicePath).append(",");
        }
        devicePathString.append(lineSeparator).append("}");
        StringBuilder schemaPartitionRespString = new StringBuilder("{");
        schemaPartitionRespString.append(lineSeparator).append("\tTSStatus=").append(resp.getStatus().getCode()).append(",");
        Map schemaPartitionTable = resp.getSchemaPartitionTable();
        for (Map.Entry databaseEntry : schemaPartitionTable.entrySet()) {
            String database = (String)databaseEntry.getKey();
            schemaPartitionRespString.append(lineSeparator).append(DATABASE).append(database).append(": {");
            for (Map.Entry slotEntry : ((Map)databaseEntry.getValue()).entrySet()) {
                schemaPartitionRespString.append(lineSeparator).append("\t\t").append(slotEntry.getKey()).append(", ").append(slotEntry.getValue()).append(",");
            }
            schemaPartitionRespString.append(lineSeparator).append("\t},");
        }
        schemaPartitionRespString.append(lineSeparator).append("}");
        LOGGER.debug("[GetOrCreateSchemaPartition]:{}Receive PathPatternTree: {}, Return TSchemaPartitionTableResp: {}", new Object[]{lineSeparator, devicePathString, schemaPartitionRespString});
    }

    @Override
    public TSchemaNodeManagementResp getNodePathsPartition(PartialPath partialPath, PathPatternTree scope, Integer level) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            GetNodePathsPartitionPlan getNodePathsPartitionPlan = new GetNodePathsPartitionPlan();
            getNodePathsPartitionPlan.setPartialPath(partialPath);
            getNodePathsPartitionPlan.setScope(scope);
            if (null != level) {
                getNodePathsPartitionPlan.setLevel(level);
            }
            SchemaNodeManagementResp resp = this.partitionManager.getNodePathsPartition(getNodePathsPartitionPlan);
            TSchemaNodeManagementResp result = resp.convertToRpcSchemaNodeManagementPartitionResp(this.getLoadManager().getRegionPriorityMap());
            this.printNodePathsPartition(partialPath, scope, level, result);
            return result;
        }
        return new TSchemaNodeManagementResp().setStatus(status);
    }

    private void printNodePathsPartition(PartialPath partialPath, PathPatternTree scope, Integer level, TSchemaNodeManagementResp resp) {
        String lineSeparator = System.lineSeparator();
        StringBuilder devicePathString = new StringBuilder("{");
        for (String devicePath : scope.getAllDevicePatterns()) {
            devicePathString.append(lineSeparator).append("\t").append(devicePath).append(",");
        }
        devicePathString.append(lineSeparator).append("}");
        StringBuilder schemaNodeManagementRespString = new StringBuilder("{");
        schemaNodeManagementRespString.append(lineSeparator).append("\tTSStatus=").append(resp.getStatus().getCode()).append(",");
        Map schemaRegionMap = resp.getSchemaRegionMap();
        for (Map.Entry databaseEntry : schemaRegionMap.entrySet()) {
            String database = (String)databaseEntry.getKey();
            schemaNodeManagementRespString.append(lineSeparator).append(DATABASE).append(database).append(": {");
            for (Map.Entry regionEntry : ((Map)databaseEntry.getValue()).entrySet()) {
                schemaNodeManagementRespString.append(lineSeparator).append("\t\tSeriesSlot: ").append(regionEntry.getKey()).append(", RegionGroup: {").append("id: ").append(((TRegionReplicaSet)regionEntry.getValue()).getRegionId().getId()).append(", DataNodes: ").append(((TRegionReplicaSet)regionEntry.getValue()).getDataNodeLocations().stream().map(TDataNodeLocation::getDataNodeId).collect(Collectors.toList())).append("}");
            }
            schemaNodeManagementRespString.append(lineSeparator).append("\t},");
        }
        schemaNodeManagementRespString.append("matchedNode: {");
        for (TSchemaNode matchedNode : resp.getMatchedNode()) {
            schemaNodeManagementRespString.append(lineSeparator).append("\t\t").append(matchedNode);
        }
        schemaNodeManagementRespString.append(lineSeparator).append("\t}");
        schemaNodeManagementRespString.append(lineSeparator).append("}");
        LOGGER.info("[GetNodePathsPartition]:{}Received PartialPath: {}, Level: {}, PathPatternTree: {}, Resp: {}", new Object[]{lineSeparator, partialPath, level, devicePathString, schemaNodeManagementRespString});
    }

    @Override
    public TDataPartitionTableResp getDataPartition(GetDataPartitionPlan getDataPartitionPlan) {
        TDataPartitionTableResp resp = new TDataPartitionTableResp();
        TSStatus status = this.confirmLeader();
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return resp.setStatus(status);
        }
        DataPartitionResp queryResult = this.partitionManager.getDataPartition(getDataPartitionPlan);
        resp = queryResult.convertToTDataPartitionTableResp();
        LOGGER.debug("GetDataPartition interface receive PartitionSlotsMap: {}, return: {}", getDataPartitionPlan.getPartitionSlotsMap(), (Object)resp);
        return resp;
    }

    @Override
    public TDataPartitionTableResp getOrCreateDataPartition(GetOrCreateDataPartitionPlan getOrCreateDataPartitionPlan) {
        TDataPartitionTableResp resp = new TDataPartitionTableResp();
        TSStatus status = this.confirmLeader();
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return resp.setStatus(status);
        }
        DataPartitionResp queryResult = this.partitionManager.getOrCreateDataPartition(getOrCreateDataPartitionPlan);
        resp = queryResult.convertToTDataPartitionTableResp();
        if (CONF.isEnablePrintingNewlyCreatedPartition()) {
            this.printNewCreatedDataPartition(getOrCreateDataPartitionPlan, resp);
        }
        return resp;
    }

    private void printNewCreatedDataPartition(GetOrCreateDataPartitionPlan getOrCreateDataPartitionPlan, TDataPartitionTableResp resp) {
        String lineSeparator = System.lineSeparator();
        StringBuilder partitionSlotsMapString = new StringBuilder("{");
        for (Map.Entry<String, Map<TSeriesPartitionSlot, TTimeSlotList>> databaseEntry : getOrCreateDataPartitionPlan.getPartitionSlotsMap().entrySet()) {
            String database = databaseEntry.getKey();
            partitionSlotsMapString.append(lineSeparator).append(DATABASE).append(database).append(": {");
            for (Map.Entry<TSeriesPartitionSlot, TTimeSlotList> slotEntry : databaseEntry.getValue().entrySet()) {
                partitionSlotsMapString.append(lineSeparator).append("\t\t").append(slotEntry.getKey()).append(",").append(slotEntry.getValue());
            }
            partitionSlotsMapString.append(lineSeparator).append("\t},");
        }
        partitionSlotsMapString.append(lineSeparator).append("}");
        StringBuilder dataPartitionRespString = new StringBuilder("{");
        dataPartitionRespString.append(lineSeparator).append("\tTSStatus=").append(resp.getStatus().getCode()).append(",");
        Map dataPartitionTable = resp.getDataPartitionTable();
        for (Map.Entry databaseEntry : dataPartitionTable.entrySet()) {
            String database = (String)databaseEntry.getKey();
            dataPartitionRespString.append(lineSeparator).append(DATABASE).append(database).append(": {");
            for (Map.Entry seriesSlotEntry : ((Map)databaseEntry.getValue()).entrySet()) {
                dataPartitionRespString.append(lineSeparator).append("\t\t").append(seriesSlotEntry.getKey()).append(": {");
                for (Map.Entry timeSlotEntry : ((Map)seriesSlotEntry.getValue()).entrySet()) {
                    dataPartitionRespString.append(lineSeparator).append("\t\t\t").append(timeSlotEntry.getKey()).append(", ").append(timeSlotEntry.getValue()).append(",");
                }
                dataPartitionRespString.append(lineSeparator).append("\t\t},");
            }
            dataPartitionRespString.append(lineSeparator).append("\t}");
        }
        dataPartitionRespString.append(lineSeparator).append("}");
        LOGGER.info("[GetOrCreateDataPartition]:{}Receive PartitionSlotsMap: {}, Return TDataPartitionTableResp: {}", new Object[]{lineSeparator, partitionSlotsMapString, dataPartitionRespString});
    }

    private TSStatus confirmLeader() {
        if (this.getConsensusManager() == null) {
            return new TSStatus(TSStatusCode.CONSENSUS_NOT_INITIALIZED.getStatusCode()).setMessage("ConsensusManager of target-ConfigNode is not initialized, please make sure the target-ConfigNode has been started successfully.");
        }
        return this.getConsensusManager().confirmLeader();
    }

    @Override
    public ClusterManager getClusterManager() {
        return this.clusterManager;
    }

    @Override
    public NodeManager getNodeManager() {
        return this.nodeManager;
    }

    @Override
    public ClusterSchemaManager getClusterSchemaManager() {
        return this.clusterSchemaManager;
    }

    @Override
    public ConsensusManager getConsensusManager() {
        return this.consensusManager.get();
    }

    @Override
    public PartitionManager getPartitionManager() {
        return this.partitionManager;
    }

    @Override
    public PermissionManager getPermissionManager() {
        return this.permissionManager;
    }

    @Override
    public LoadManager getLoadManager() {
        return this.loadManager;
    }

    @Override
    public TriggerManager getTriggerManager() {
        return this.triggerManager;
    }

    @Override
    public PipeManager getPipeManager() {
        return this.pipeManager;
    }

    @Override
    public SubscriptionManager getSubscriptionManager() {
        return this.subscriptionManager;
    }

    @Override
    public TSStatus operatePermission(AuthorPlan authorPlan) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.permissionManager.operatePermission(authorPlan, false);
        }
        return status;
    }

    @Override
    public DataSet queryPermission(AuthorPlan authorPlan) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.permissionManager.queryPermission(authorPlan);
        }
        PermissionInfoResp dataSet = new PermissionInfoResp();
        dataSet.setStatus(status);
        return dataSet;
    }

    @Override
    public TPermissionInfoResp login(String username, String password) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.permissionManager.login(username, password);
        }
        TPermissionInfoResp resp = AuthUtils.generateEmptyPermissionInfoResp();
        resp.setStatus(status);
        return resp;
    }

    @Override
    public TPermissionInfoResp checkUserPrivileges(String username, List<PartialPath> paths, int permission) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.permissionManager.checkUserPrivileges(username, paths, permission);
        }
        TPermissionInfoResp resp = AuthUtils.generateEmptyPermissionInfoResp();
        resp.setStatus(status);
        return resp;
    }

    public TAuthizedPatternTreeResp fetchAuthizedPatternTree(String username, int permission) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            try {
                return this.permissionManager.fetchAuthizedPTree(username, permission);
            }
            catch (AuthException e) {
                TAuthizedPatternTreeResp resp = new TAuthizedPatternTreeResp();
                status.setCode(e.getCode().getStatusCode()).setMessage(e.getMessage());
                resp.setStatus(status);
                return resp;
            }
        }
        TAuthizedPatternTreeResp resp = new TAuthizedPatternTreeResp();
        resp.setStatus(status);
        return resp;
    }

    public void checkUserPathPrivilege() {
        this.permissionManager.checkUserPathPrivilege();
    }

    public TPermissionInfoResp checkUserPrivilegeGrantOpt(String username, List<PartialPath> paths, int permission) {
        TSStatus status = this.confirmLeader();
        TPermissionInfoResp resp = new TPermissionInfoResp();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            try {
                resp = this.permissionManager.checkUserPrivilegeGrantOpt(username, paths, permission);
            }
            catch (AuthException e) {
                status.setCode(e.getCode().getStatusCode()).setMessage(e.getMessage());
                resp.setStatus(status);
                return resp;
            }
        } else {
            resp.setStatus(status);
        }
        return resp;
    }

    public TPermissionInfoResp checkRoleOfUser(String username, String rolename) {
        TSStatus status = this.confirmLeader();
        TPermissionInfoResp resp = new TPermissionInfoResp();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            try {
                resp = this.permissionManager.checkRoleOfUser(username, rolename);
            }
            catch (AuthException e) {
                status.setCode(e.getCode().getStatusCode()).setMessage(e.getMessage());
                resp.setStatus(status);
                return resp;
            }
        } else {
            resp.setStatus(status);
        }
        return resp;
    }

    @Override
    public TConfigNodeRegisterResp registerConfigNode(TConfigNodeRegisterReq req) {
        int ERROR_STATUS_NODE_ID = -1;
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() && (status = this.checkConfigNodeGlobalConfig(req)) == null && (status = ClusterNodeStartUtils.confirmNodeRegistration(NodeType.ConfigNode, req.getClusterParameters().getClusterName(), req.getConfigNodeLocation(), this)).getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.nodeManager.registerConfigNode(req);
        }
        return new TConfigNodeRegisterResp().setStatus(status).setConfigNodeId(-1);
    }

    @Override
    public TSStatus checkConfigNodeGlobalConfig(TConfigNodeRegisterReq req) {
        String errorPrefix = "Reject register, please ensure that the parameter ";
        String errorSuffix = " is consistent with the Seed-ConfigNode.";
        TSStatus errorStatus = new TSStatus(TSStatusCode.CONFIGURATION_ERROR.getStatusCode());
        TClusterParameters clusterParameters = req.getClusterParameters();
        if (!clusterParameters.getConfigNodeConsensusProtocolClass().equals(CONF.getConfigNodeConsensusProtocolClass())) {
            return errorStatus.setMessage("Reject register, please ensure that the parameter config_node_consensus_protocol_class is consistent with the Seed-ConfigNode.");
        }
        if (!clusterParameters.getDataRegionConsensusProtocolClass().equals(CONF.getDataRegionConsensusProtocolClass())) {
            return errorStatus.setMessage("Reject register, please ensure that the parameter data_region_consensus_protocol_class is consistent with the Seed-ConfigNode.");
        }
        if (!clusterParameters.getSchemaRegionConsensusProtocolClass().equals(CONF.getSchemaRegionConsensusProtocolClass())) {
            return errorStatus.setMessage("Reject register, please ensure that the parameter schema_region_consensus_protocol_class is consistent with the Seed-ConfigNode.");
        }
        if (clusterParameters.getSeriesPartitionSlotNum() != CONF.getSeriesSlotNum()) {
            return errorStatus.setMessage("Reject register, please ensure that the parameter series_slot_num is consistent with the Seed-ConfigNode.");
        }
        if (!clusterParameters.getSeriesPartitionExecutorClass().equals(CONF.getSeriesPartitionExecutorClass())) {
            return errorStatus.setMessage("Reject register, please ensure that the parameter series_partition_executor_class is consistent with the Seed-ConfigNode.");
        }
        if (clusterParameters.getDefaultTTL() != CommonDescriptor.getInstance().getConfig().getDefaultTTLInMs()) {
            return errorStatus.setMessage("Reject register, please ensure that the parameter default_ttl is consistent with the Seed-ConfigNode.");
        }
        if (clusterParameters.getTimePartitionInterval() != COMMON_CONF.getTimePartitionInterval()) {
            return errorStatus.setMessage("Reject register, please ensure that the parameter time_partition_interval is consistent with the Seed-ConfigNode.");
        }
        if (clusterParameters.getSchemaReplicationFactor() != CONF.getSchemaReplicationFactor()) {
            return errorStatus.setMessage("Reject register, please ensure that the parameter schema_replication_factor is consistent with the Seed-ConfigNode.");
        }
        if (clusterParameters.getDataReplicationFactor() != CONF.getDataReplicationFactor()) {
            return errorStatus.setMessage("Reject register, please ensure that the parameter data_replication_factor is consistent with the Seed-ConfigNode.");
        }
        if (clusterParameters.getSchemaRegionPerDataNode() != CONF.getSchemaRegionPerDataNode()) {
            return errorStatus.setMessage("Reject register, please ensure that the parameter schema_region_per_data_node is consistent with the Seed-ConfigNode.");
        }
        if (clusterParameters.getDataRegionPerDataNode() != CONF.getDataRegionPerDataNode()) {
            return errorStatus.setMessage("Reject register, please ensure that the parameter data_region_per_data_node is consistent with the Seed-ConfigNode.");
        }
        if (!clusterParameters.getReadConsistencyLevel().equals(CONF.getReadConsistencyLevel())) {
            return errorStatus.setMessage("Reject register, please ensure that the parameter read_consistency_level is consistent with the Seed-ConfigNode.");
        }
        if (clusterParameters.getDiskSpaceWarningThreshold() != COMMON_CONF.getDiskSpaceWarningThreshold()) {
            return errorStatus.setMessage("Reject register, please ensure that the parameter disk_space_warning_threshold is consistent with the Seed-ConfigNode.");
        }
        if (!clusterParameters.getTimestampPrecision().equals(COMMON_CONF.getTimestampPrecision())) {
            return errorStatus.setMessage("Reject register, please ensure that the parameter timestamp_precision is consistent with the Seed-ConfigNode.");
        }
        if (!clusterParameters.getSchemaEngineMode().equals(COMMON_CONF.getSchemaEngineMode())) {
            return errorStatus.setMessage("Reject register, please ensure that the parameter schema_engine_mode is consistent with the Seed-ConfigNode.");
        }
        if (clusterParameters.getTagAttributeTotalSize() != COMMON_CONF.getTagAttributeTotalSize()) {
            return errorStatus.setMessage("Reject register, please ensure that the parameter tag_attribute_total_size is consistent with the Seed-ConfigNode.");
        }
        if (clusterParameters.getDatabaseLimitThreshold() != COMMON_CONF.getDatabaseLimitThreshold()) {
            return errorStatus.setMessage("Reject register, please ensure that the parameter database_limit_threshold is consistent with the Seed-ConfigNode.");
        }
        return null;
    }

    @Override
    public TSStatus createPeerForConsensusGroup(List<TConfigNodeLocation> configNodeLocations) {
        long rpcTimeoutInMS = COMMON_CONF.getConnectionTimeoutInMS();
        long retryIntervalInMS = 1000L;
        int i = 0;
        while ((long)i < rpcTimeoutInMS / 1000L) {
            try {
                if (this.consensusManager.get() != null && this.consensusManager.get().isInitialized()) {
                    this.consensusManager.get().createPeerForConsensusGroup(Collections.emptyList());
                    return StatusUtils.OK;
                }
                TimeUnit.MILLISECONDS.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOGGER.warn("Unexpected interruption during retry creating peer for consensus group");
            }
            catch (ConsensusException e) {
                LOGGER.error("Failed to create peer for consensus group", (Throwable)e);
                break;
            }
            ++i;
        }
        return StatusUtils.INTERNAL_ERROR;
    }

    @Override
    public TSStatus removeConfigNode(RemoveConfigNodePlan removeConfigNodePlan) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() && (status = this.nodeManager.checkConfigNodeBeforeRemove(removeConfigNodePlan)).getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            this.procedureManager.removeConfigNode(removeConfigNodePlan);
        }
        return status;
    }

    @Override
    public TSStatus reportConfigNodeShutdown(TConfigNodeLocation configNodeLocation) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            this.getLoadManager().forceUpdateNodeCache(NodeType.ConfigNode, configNodeLocation.getConfigNodeId(), new NodeHeartbeatSample(NodeStatus.Unknown));
            LOGGER.info("[ShutdownHook] The ConfigNode-{} will be shutdown soon, mark it as Unknown", (Object)configNodeLocation.getConfigNodeId());
        }
        return status;
    }

    @Override
    public TSStatus createFunction(TCreateFunctionReq req) {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.udfManager.createFunction(req) : status;
    }

    @Override
    public TSStatus dropFunction(String udfName) {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.udfManager.dropFunction(udfName) : status;
    }

    @Override
    public TGetUDFTableResp getUDFTable() {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.udfManager.getUDFTable() : new TGetUDFTableResp(status, Collections.emptyList());
    }

    @Override
    public TGetJarInListResp getUDFJar(TGetJarInListReq req) {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.udfManager.getUDFJar(req) : new TGetJarInListResp(status, Collections.emptyList());
    }

    @Override
    public TSStatus createTrigger(TCreateTriggerReq req) {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.triggerManager.createTrigger(req) : status;
    }

    @Override
    public TSStatus dropTrigger(TDropTriggerReq req) {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.triggerManager.dropTrigger(req) : status;
    }

    @Override
    public TGetTriggerTableResp getTriggerTable() {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.triggerManager.getTriggerTable(false) : new TGetTriggerTableResp(status, Collections.emptyList());
    }

    @Override
    public TGetTriggerTableResp getStatefulTriggerTable() {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.triggerManager.getTriggerTable(true) : new TGetTriggerTableResp(status, Collections.emptyList());
    }

    @Override
    public TGetLocationForTriggerResp getLocationOfStatefulTrigger(String triggerName) {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.triggerManager.getLocationOfStatefulTrigger(triggerName) : new TGetLocationForTriggerResp(status);
    }

    @Override
    public TGetJarInListResp getTriggerJar(TGetJarInListReq req) {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.triggerManager.getTriggerJar(req) : new TGetJarInListResp(status, Collections.emptyList());
    }

    @Override
    public TSStatus createPipePlugin(TCreatePipePluginReq req) {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.pipeManager.getPipePluginCoordinator().createPipePlugin(req) : status;
    }

    @Override
    public TSStatus dropPipePlugin(String pipePluginName) {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.pipeManager.getPipePluginCoordinator().dropPipePlugin(pipePluginName) : status;
    }

    @Override
    public TGetPipePluginTableResp getPipePluginTable() {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.pipeManager.getPipePluginCoordinator().getPipePluginTable() : new TGetPipePluginTableResp(status, Collections.emptyList());
    }

    @Override
    public TGetJarInListResp getPipePluginJar(TGetJarInListReq req) {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.pipeManager.getPipePluginCoordinator().getPipePluginJar(req) : new TGetJarInListResp(status, Collections.emptyList());
    }

    @Override
    public TSStatus merge() {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? RpcUtils.squashResponseStatusList(this.nodeManager.merge()) : status;
    }

    @Override
    public TSStatus flush(TFlushReq req) {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? RpcUtils.squashResponseStatusList(this.nodeManager.flush(req)) : status;
    }

    @Override
    public TSStatus clearCache() {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? RpcUtils.squashResponseStatusList(this.nodeManager.clearCache()) : status;
    }

    @Override
    public TSStatus startRepairData() {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? RpcUtils.squashResponseStatusList(this.nodeManager.startRpairData()) : status;
    }

    @Override
    public TSStatus stopRepairData() {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? RpcUtils.squashResponseStatusList(this.nodeManager.stopRepairData()) : status;
    }

    @Override
    public TSStatus loadConfiguration() {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? RpcUtils.squashResponseStatusList(this.nodeManager.loadConfiguration()) : status;
    }

    @Override
    public TSStatus setSystemStatus(String systemStatus) {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? RpcUtils.squashResponseStatusList(this.nodeManager.setSystemStatus(systemStatus)) : status;
    }

    @Override
    public TSStatus setDataNodeStatus(TSetDataNodeStatusReq req) {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.nodeManager.setDataNodeStatus(req) : status;
    }

    @Override
    public TSStatus killQuery(String queryId, int dataNodeId) {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.nodeManager.killQuery(queryId, dataNodeId) : status;
    }

    @Override
    public TGetDataNodeLocationsResp getRunningDataNodeLocations() {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? new TGetDataNodeLocationsResp(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()), this.nodeManager.filterDataNodeThroughStatus(NodeStatus.Running).stream().map(TDataNodeConfiguration::getLocation).collect(Collectors.toList())) : new TGetDataNodeLocationsResp(status, Collections.emptyList());
    }

    @Override
    public TRegionRouteMapResp getLatestRegionRouteMap() {
        long retryIntervalInMS = 100L;
        TSStatus status = this.confirmLeader();
        TRegionRouteMapResp resp = new TRegionRouteMapResp(status);
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            int retry = 0;
            while ((long)retry < CONF.getHeartbeatIntervalInMs() * 4L / 100L) {
                AtomicBoolean containsAllRegionGroups = new AtomicBoolean(true);
                Map<TConsensusGroupId, TRegionReplicaSet> regionPriorityMap = this.getLoadManager().getRegionPriorityMap();
                this.getPartitionManager().getAllReplicaSets().forEach(replicaSet -> {
                    if (!regionPriorityMap.containsKey(replicaSet.getRegionId())) {
                        containsAllRegionGroups.set(false);
                    }
                });
                if (containsAllRegionGroups.get()) break;
                try {
                    TimeUnit.MILLISECONDS.sleep(100L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    LOGGER.warn("Unexpected interruption during retry getting latest region route map");
                }
                ++retry;
            }
            resp.setTimestamp(System.currentTimeMillis());
            resp.setRegionRouteMap(this.getLoadManager().getRegionPriorityMap());
        }
        return resp;
    }

    @Override
    public UDFManager getUDFManager() {
        return this.udfManager;
    }

    @Override
    public RegionInfoListResp showRegion(GetRegionInfoListPlan getRegionInfoListPlan) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.partitionManager.getRegionInfoList(getRegionInfoListPlan);
        }
        RegionInfoListResp regionResp = new RegionInfoListResp();
        regionResp.setStatus(status);
        return regionResp;
    }

    @Override
    public TShowDataNodesResp showDataNodes() {
        TSStatus status = this.confirmLeader();
        TShowDataNodesResp resp = new TShowDataNodesResp();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return resp.setDataNodesInfoList(this.nodeManager.getRegisteredDataNodeInfoList()).setStatus(StatusUtils.OK);
        }
        return resp.setStatus(status);
    }

    @Override
    public TShowConfigNodesResp showConfigNodes() {
        TSStatus status = this.confirmLeader();
        TShowConfigNodesResp resp = new TShowConfigNodesResp();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return resp.setConfigNodesInfoList(this.nodeManager.getRegisteredConfigNodeInfoList()).setStatus(StatusUtils.OK);
        }
        return resp.setStatus(status);
    }

    @Override
    public TShowDatabaseResp showDatabase(TGetDatabaseReq req) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            PathPatternTree scope = req.getScopePatternTree() == null ? SchemaConstant.ALL_MATCH_SCOPE : PathPatternTree.deserialize((ByteBuffer)ByteBuffer.wrap(req.getScopePatternTree()));
            GetDatabasePlan getDatabasePlan = new GetDatabasePlan(req.getDatabasePathPattern(), scope);
            return this.getClusterSchemaManager().showDatabase(getDatabasePlan);
        }
        return new TShowDatabaseResp().setStatus(status);
    }

    @Override
    public ProcedureManager getProcedureManager() {
        return this.procedureManager;
    }

    @Override
    public CQManager getCQManager() {
        return this.cqManager;
    }

    @Override
    public ClusterQuotaManager getClusterQuotaManager() {
        return this.clusterQuotaManager;
    }

    @Override
    public RetryFailedTasksThread getRetryFailedTasksThread() {
        return this.retryFailedTasksThread;
    }

    @Override
    public void addMetrics() {
        MetricService.getInstance().addMetricSet((IMetricSet)new NodeMetrics(this.getNodeManager()));
        MetricService.getInstance().addMetricSet((IMetricSet)new PartitionMetrics(this));
        this.getProcedureManager().addMetrics();
    }

    @Override
    public void removeMetrics() {
        MetricService.getInstance().removeMetricSet((IMetricSet)new NodeMetrics(this.getNodeManager()));
        MetricService.getInstance().removeMetricSet((IMetricSet)new PartitionMetrics(this));
        this.getProcedureManager().removeMetrics();
    }

    @Override
    public TSStatus createSchemaTemplate(TCreateSchemaTemplateReq req) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            CreateSchemaTemplatePlan createSchemaTemplatePlan = new CreateSchemaTemplatePlan(req.getSerializedTemplate());
            return this.clusterSchemaManager.createTemplate(createSchemaTemplatePlan);
        }
        return status;
    }

    @Override
    public TGetAllTemplatesResp getAllTemplates() {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.clusterSchemaManager.getAllTemplates();
        }
        return new TGetAllTemplatesResp().setStatus(status);
    }

    @Override
    public TGetTemplateResp getTemplate(String req) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.clusterSchemaManager.getTemplate(req);
        }
        return new TGetTemplateResp().setStatus(status);
    }

    @Override
    public synchronized TSStatus setSchemaTemplate(TSetSchemaTemplateReq req) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.procedureManager.setSchemaTemplate(req.getQueryId(), req.getName(), req.getPath(), req.isSetIsGeneratedByPipe() && req.isIsGeneratedByPipe());
        }
        return status;
    }

    @Override
    public TGetPathsSetTemplatesResp getPathsSetTemplate(TGetPathsSetTemplatesReq req) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            PathPatternTree scope = req.getScopePatternTree() == null ? SchemaConstant.ALL_MATCH_SCOPE : PathPatternTree.deserialize((ByteBuffer)ByteBuffer.wrap(req.getScopePatternTree()));
            return this.clusterSchemaManager.getPathsSetTemplate(req.getTemplateName(), scope);
        }
        return new TGetPathsSetTemplatesResp(status);
    }

    @Override
    public TSStatus deactivateSchemaTemplate(TDeactivateSchemaTemplateReq req) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return status;
        }
        PathPatternTree patternTree = PathPatternTree.deserialize((ByteBuffer)ByteBuffer.wrap(req.getPathPatternTree()));
        List patternList = patternTree.getAllPathPatterns();
        TemplateSetInfoResp templateSetInfoResp = this.clusterSchemaManager.getTemplateSetInfo(patternList);
        if (templateSetInfoResp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return templateSetInfoResp.getStatus();
        }
        Map<PartialPath, List<Template>> templateSetInfo = templateSetInfoResp.getPatternTemplateMap();
        if (templateSetInfo.isEmpty()) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.TEMPLATE_NOT_SET, (String)String.format("Device Template %s is not set on any prefix path of %s", req.getTemplateName(), patternList));
        }
        if (!req.getTemplateName().equals("*")) {
            HashMap<PartialPath, List<Template>> filteredTemplateSetInfo = new HashMap<PartialPath, List<Template>>();
            block0: for (Map.Entry<PartialPath, List<Template>> entry : templateSetInfo.entrySet()) {
                for (Template template : entry.getValue()) {
                    if (!template.getName().equals(req.getTemplateName())) continue;
                    filteredTemplateSetInfo.put(entry.getKey(), Collections.singletonList(template));
                    continue block0;
                }
            }
            if (filteredTemplateSetInfo.isEmpty()) {
                return RpcUtils.getStatus((TSStatusCode)TSStatusCode.TEMPLATE_NOT_SET, (String)String.format("Device Template %s is not set on any prefix path of %s", req.getTemplateName(), patternList));
            }
            templateSetInfo = filteredTemplateSetInfo;
        }
        return this.procedureManager.deactivateTemplate(req.getQueryId(), templateSetInfo, req.isSetIsGeneratedByPipe() && req.isIsGeneratedByPipe());
    }

    @Override
    public synchronized TSStatus unsetSchemaTemplate(TUnsetSchemaTemplateReq req) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return status;
        }
        Pair<TSStatus, Template> checkResult = this.clusterSchemaManager.checkIsTemplateSetOnPath(req.getTemplateName(), req.getPath());
        if (((TSStatus)checkResult.left).getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            try {
                return this.procedureManager.unsetSchemaTemplate(req.getQueryId(), (Template)checkResult.right, new PartialPath(req.getPath()), req.isSetIsGeneratedByPipe() && req.isIsGeneratedByPipe());
            }
            catch (IllegalPathException e) {
                return RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
            }
        }
        return (TSStatus)checkResult.left;
    }

    @Override
    public TSStatus dropSchemaTemplate(String templateName) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.clusterSchemaManager.dropSchemaTemplate(templateName);
        }
        return status;
    }

    @Override
    public TSStatus alterSchemaTemplate(TAlterSchemaTemplateReq req) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            ByteBuffer buffer = ByteBuffer.wrap(req.getTemplateAlterInfo());
            TemplateAlterOperationType operationType = TemplateAlterOperationUtil.parseOperationType((ByteBuffer)buffer);
            if (operationType.equals((Object)TemplateAlterOperationType.EXTEND_TEMPLATE)) {
                return this.clusterSchemaManager.extendSchemaTemplate(TemplateAlterOperationUtil.parseTemplateExtendInfo((ByteBuffer)buffer), false);
            }
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.UNSUPPORTED_OPERATION);
        }
        return status;
    }

    @Override
    public TSStatus deleteTimeSeries(TDeleteTimeSeriesReq req) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            String queryId = req.getQueryId();
            PathPatternTree rawPatternTree = PathPatternTree.deserialize((ByteBuffer)ByteBuffer.wrap(req.getPathPatternTree()));
            boolean isGeneratedByPipe = req.isSetIsGeneratedByPipe() && req.isIsGeneratedByPipe();
            boolean canOptimize = false;
            HashSet<TDatabaseSchema> deleteDatabaseSchemas = new HashSet<TDatabaseSchema>();
            ArrayList<PartialPath> deleteTimeSeriesPatternPaths = new ArrayList<PartialPath>();
            for (PartialPath path : rawPatternTree.getAllPathPatterns()) {
                Map<String, TDatabaseSchema> databaseSchemaMap;
                if (PathPatternUtil.isMultiLevelMatchWildcard((String)path.getMeasurement()) && !path.getDevicePath().hasWildcard() && !(databaseSchemaMap = this.getClusterSchemaManager().getMatchedDatabaseSchemasByPrefix(path.getDevicePath())).isEmpty()) {
                    deleteDatabaseSchemas.addAll(databaseSchemaMap.values());
                    canOptimize = true;
                    continue;
                }
                deleteTimeSeriesPatternPaths.add(path);
            }
            if (!canOptimize) {
                return this.procedureManager.deleteTimeSeries(queryId, rawPatternTree, isGeneratedByPipe);
            }
            if (!deleteTimeSeriesPatternPaths.isEmpty()) {
                PathPatternTree deleteTimeSeriesPatternTree = new PathPatternTree();
                for (PartialPath path : deleteTimeSeriesPatternPaths) {
                    deleteTimeSeriesPatternTree.appendPathPattern(path);
                }
                deleteTimeSeriesPatternTree.constructTree();
                status = this.procedureManager.deleteTimeSeries(queryId, deleteTimeSeriesPatternTree, isGeneratedByPipe);
            }
            if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                ArrayList<TSStatus> failedStatus = new ArrayList<TSStatus>();
                status = this.procedureManager.deleteDatabases(new ArrayList<TDatabaseSchema>(deleteDatabaseSchemas), isGeneratedByPipe);
                if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                    failedStatus.add(status);
                }
                for (TDatabaseSchema databaseSchema : deleteDatabaseSchemas) {
                    status = this.clusterSchemaManager.setDatabase(new DatabaseSchemaPlan(ConfigPhysicalPlanType.CreateDatabase, databaseSchema), isGeneratedByPipe);
                    if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
                    failedStatus.add(status);
                }
                status = !failedStatus.isEmpty() ? RpcUtils.squashResponseStatusList(failedStatus) : StatusUtils.OK;
            }
        }
        return status;
    }

    @Override
    public TSStatus deleteLogicalView(TDeleteLogicalViewReq req) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.procedureManager.deleteLogicalView(req);
        }
        return status;
    }

    @Override
    public TSStatus alterLogicalView(TAlterLogicalViewReq req) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.procedureManager.alterLogicalView(req);
        }
        return status;
    }

    @Override
    public TSStatus createPipe(TCreatePipeReq req) {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.pipeManager.getPipeTaskCoordinator().createPipe(req) : status;
    }

    @Override
    public TSStatus alterPipe(TAlterPipeReq req) {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.pipeManager.getPipeTaskCoordinator().alterPipe(req) : status;
    }

    @Override
    public TSStatus startPipe(String pipeName) {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.pipeManager.getPipeTaskCoordinator().startPipe(pipeName) : status;
    }

    @Override
    public TSStatus stopPipe(String pipeName) {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.pipeManager.getPipeTaskCoordinator().stopPipe(pipeName) : status;
    }

    @Override
    public TSStatus dropPipe(String pipeName) {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.pipeManager.getPipeTaskCoordinator().dropPipe(pipeName) : status;
    }

    @Override
    public TShowPipeResp showPipe(TShowPipeReq req) {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.pipeManager.getPipeTaskCoordinator().showPipes(req) : new TShowPipeResp().setStatus(status);
    }

    @Override
    public TGetAllPipeInfoResp getAllPipeInfo() {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.pipeManager.getPipeTaskCoordinator().getAllPipeInfo() : new TGetAllPipeInfoResp(status, Collections.emptyList());
    }

    @Override
    public TSStatus createTopic(TCreateTopicReq req) {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.subscriptionManager.getSubscriptionCoordinator().createTopic(req) : status;
    }

    @Override
    public TSStatus dropTopic(String topicName) {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.subscriptionManager.getSubscriptionCoordinator().dropTopic(topicName) : status;
    }

    @Override
    public TShowTopicResp showTopic(TShowTopicReq req) {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.subscriptionManager.getSubscriptionCoordinator().showTopic(req) : new TShowTopicResp().setStatus(status);
    }

    @Override
    public TGetAllTopicInfoResp getAllTopicInfo() {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.subscriptionManager.getSubscriptionCoordinator().getAllTopicInfo() : new TGetAllTopicInfoResp(status, Collections.emptyList());
    }

    @Override
    public TSStatus createConsumer(TCreateConsumerReq req) {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.subscriptionManager.getSubscriptionCoordinator().createConsumer(req) : status;
    }

    @Override
    public TSStatus closeConsumer(TCloseConsumerReq req) {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.subscriptionManager.getSubscriptionCoordinator().dropConsumer(req) : status;
    }

    @Override
    public TSStatus createSubscription(TSubscribeReq req) {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.subscriptionManager.getSubscriptionCoordinator().createSubscription(req) : status;
    }

    @Override
    public TSStatus dropSubscription(TUnsubscribeReq req) {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.subscriptionManager.getSubscriptionCoordinator().dropSubscription(req) : status;
    }

    @Override
    public TShowSubscriptionResp showSubscription(TShowSubscriptionReq req) {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.subscriptionManager.getSubscriptionCoordinator().showSubscription(req) : new TShowSubscriptionResp().setStatus(status);
    }

    @Override
    public TGetAllSubscriptionInfoResp getAllSubscriptionInfo() {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.subscriptionManager.getSubscriptionCoordinator().getAllSubscriptionInfo() : new TGetAllSubscriptionInfoResp(status, Collections.emptyList());
    }

    @Override
    public TPipeConfigTransferResp handleTransferConfigPlan(TPipeConfigTransferReq req) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return new TPipeConfigTransferResp(status);
        }
        TPipeTransferResp result = PipeConfigNodeAgent.receiver().receive(req.getClientId(), req.isAirGap ? new AirGapPseudoTPipeTransferRequest().setVersion(req.version).setType(req.type).setBody(req.body) : new TPipeTransferReq(req.version, req.type, req.body));
        return new TPipeConfigTransferResp(result.status).setBody(result.body);
    }

    @Override
    public TSStatus handleClientExit(String clientId) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return status;
        }
        PipeConfigNodeAgent.receiver().handleClientExit(clientId);
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    @Override
    public TGetRegionIdResp getRegionId(TGetRegionIdReq req) {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.partitionManager.getRegionId(req).convertToRpcGetRegionIdResp() : new TGetRegionIdResp(status);
    }

    @Override
    public TGetTimeSlotListResp getTimeSlotList(TGetTimeSlotListReq req) {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.partitionManager.getTimeSlotList(req).convertToRpcGetTimeSlotListResp() : new TGetTimeSlotListResp(status);
    }

    @Override
    public TCountTimeSlotListResp countTimeSlotList(TCountTimeSlotListReq req) {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.partitionManager.countTimeSlotList(req).convertToRpcCountTimeSlotListResp() : new TCountTimeSlotListResp(status);
    }

    @Override
    public TGetSeriesSlotListResp getSeriesSlotList(TGetSeriesSlotListReq req) {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.partitionManager.getSeriesSlotList(req).convertToRpcGetSeriesSlotListResp() : new TGetSeriesSlotListResp(status);
    }

    @Override
    public TSStatus migrateRegion(TMigrateRegionReq req) {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.procedureManager.migrateRegion(req) : status;
    }

    @Override
    public TSStatus createCQ(TCreateCQReq req) {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.cqManager.createCQ(req) : status;
    }

    @Override
    public TSStatus dropCQ(TDropCQReq req) {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.cqManager.dropCQ(req) : status;
    }

    @Override
    public TShowCQResp showCQ() {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.cqManager.showCQ() : new TShowCQResp(status, Collections.emptyList());
    }

    public Map<TConsensusGroupId, TRegionReplicaSet> getRelatedSchemaRegionGroup(PathPatternTree patternTree) {
        Map schemaPartitionTable = this.getSchemaPartition(patternTree).getSchemaPartitionTable();
        List<TRegionReplicaSet> allRegionReplicaSets = this.getPartitionManager().getAllReplicaSets();
        Set groupIdSet = schemaPartitionTable.values().stream().flatMap(m -> m.values().stream()).collect(Collectors.toSet());
        HashMap<TConsensusGroupId, TRegionReplicaSet> filteredRegionReplicaSets = new HashMap<TConsensusGroupId, TRegionReplicaSet>();
        for (TRegionReplicaSet regionReplicaSet : allRegionReplicaSets) {
            if (!groupIdSet.contains(regionReplicaSet.getRegionId())) continue;
            filteredRegionReplicaSets.put(regionReplicaSet.getRegionId(), regionReplicaSet);
        }
        return filteredRegionReplicaSets;
    }

    public Map<TConsensusGroupId, TRegionReplicaSet> getRelatedDataRegionGroup(PathPatternTree patternTree) {
        Map schemaPartitionTable = this.getSchemaPartition(patternTree).getSchemaPartitionTable();
        HashMap<String, Map<TSeriesPartitionSlot, TTimeSlotList>> partitionSlotsMap = new HashMap<String, Map<TSeriesPartitionSlot, TTimeSlotList>>();
        schemaPartitionTable.forEach((key, value) -> {
            HashMap slotListMap = new HashMap();
            value.keySet().forEach(slot -> slotListMap.put(slot, new TTimeSlotList(Collections.emptyList(), true, true)));
            partitionSlotsMap.put((String)key, slotListMap);
        });
        GetDataPartitionPlan getDataPartitionPlan = new GetDataPartitionPlan(partitionSlotsMap);
        Map dataPartitionTable = this.getDataPartition(getDataPartitionPlan).getDataPartitionTable();
        List<TRegionReplicaSet> allRegionReplicaSets = this.getPartitionManager().getAllReplicaSets();
        Set groupIdSet = dataPartitionTable.values().stream().flatMap(tSeriesPartitionSlotMapMap -> tSeriesPartitionSlotMapMap.values().stream().flatMap(tTimePartitionSlotListMap -> tTimePartitionSlotListMap.values().stream().flatMap(Collection::stream))).collect(Collectors.toSet());
        HashMap<TConsensusGroupId, TRegionReplicaSet> filteredRegionReplicaSets = new HashMap<TConsensusGroupId, TRegionReplicaSet>();
        for (TRegionReplicaSet regionReplicaSet : allRegionReplicaSets) {
            if (!groupIdSet.contains(regionReplicaSet.getRegionId())) continue;
            filteredRegionReplicaSets.put(regionReplicaSet.getRegionId(), regionReplicaSet);
        }
        return filteredRegionReplicaSets;
    }

    @Override
    public TSStatus transfer(List<TDataNodeLocation> newUnknownDataList) {
        HashMap<Integer, TDataNodeLocation> runningDataNodeLocationMap = new HashMap<Integer, TDataNodeLocation>();
        this.nodeManager.filterDataNodeThroughStatus(NodeStatus.Running).forEach(dataNodeConfiguration -> runningDataNodeLocationMap.put(dataNodeConfiguration.getLocation().getDataNodeId(), dataNodeConfiguration.getLocation()));
        if (runningDataNodeLocationMap.isEmpty()) {
            return new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
        }
        newUnknownDataList.forEach(dataNodeLocation -> runningDataNodeLocationMap.remove(dataNodeLocation.getDataNodeId()));
        LOGGER.info("Start transfer of {}", newUnknownDataList);
        TSStatus transferResult = this.triggerManager.transferTrigger(newUnknownDataList, runningDataNodeLocationMap);
        if (transferResult.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            LOGGER.warn("Fail to transfer because {}, will retry", (Object)transferResult.getMessage());
        }
        return transferResult;
    }

    @Override
    public TSStatus setSpaceQuota(TSetSpaceQuotaReq req) {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.clusterQuotaManager.setSpaceQuota(req) : status;
    }

    public TSpaceQuotaResp showSpaceQuota(List<String> databases) {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.clusterQuotaManager.showSpaceQuota(databases) : new TSpaceQuotaResp(status);
    }

    public TSpaceQuotaResp getSpaceQuota() {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.clusterQuotaManager.getSpaceQuota() : new TSpaceQuotaResp(status);
    }

    public TSStatus setThrottleQuota(TSetThrottleQuotaReq req) {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.clusterQuotaManager.setThrottleQuota(req) : status;
    }

    public TThrottleQuotaResp showThrottleQuota(TShowThrottleReq req) {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.clusterQuotaManager.showThrottleQuota(req) : new TThrottleQuotaResp(status);
    }

    public TThrottleQuotaResp getThrottleQuota() {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.clusterQuotaManager.getThrottleQuota() : new TThrottleQuotaResp(status);
    }
}

