/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write.subscription.topic;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.iotdb.confignode.consensus.request.write.subscription.topic.AlterTopicPlan;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class AlterMultipleTopicsPlan
extends ConfigPhysicalPlan {
    private List<AlterTopicPlan> subPlans;

    public AlterMultipleTopicsPlan() {
        super(ConfigPhysicalPlanType.AlterMultipleTopics);
    }

    public AlterMultipleTopicsPlan(List<AlterTopicPlan> subPlans) {
        super(ConfigPhysicalPlanType.AlterMultipleTopics);
        this.subPlans = subPlans;
    }

    public List<AlterTopicPlan> getSubPlans() {
        return this.subPlans;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeShort(this.getType().getPlanType());
        if (this.subPlans != null) {
            ReadWriteIOUtils.write((Boolean)true, (OutputStream)stream);
            ReadWriteIOUtils.write((int)this.subPlans.size(), (OutputStream)stream);
            for (AlterTopicPlan subPlan : this.subPlans) {
                subPlan.serializeImpl(stream);
            }
        } else {
            ReadWriteIOUtils.write((Boolean)false, (OutputStream)stream);
        }
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        if (ReadWriteIOUtils.readBool((ByteBuffer)buffer)) {
            this.subPlans = new ArrayList<AlterTopicPlan>();
            int size = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
            for (int i = 0; i < size; ++i) {
                ReadWriteIOUtils.readShort((ByteBuffer)buffer);
                AlterTopicPlan subPlan = new AlterTopicPlan();
                subPlan.deserializeImpl(buffer);
                this.subPlans.add(subPlan);
            }
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AlterMultipleTopicsPlan that = (AlterMultipleTopicsPlan)obj;
        return Objects.equals(this.subPlans, that.subPlans);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.subPlans);
    }

    public String toString() {
        return "AlterMultipleTopicPlan{subPlans='" + this.subPlans + "'}";
    }
}

