/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.auth;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.iotdb.commons.auth.AuthException;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.utils.BasicStructureSerDeUtil;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorPlan
extends ConfigPhysicalPlan {
    private static final Logger logger = LoggerFactory.getLogger(AuthorPlan.class);
    private ConfigPhysicalPlanType authorType;
    private String roleName;
    private String password;
    private String newPassword;
    private Set<Integer> permissions;
    private List<PartialPath> nodeNameList;
    private String userName;
    private boolean grantOpt;

    public AuthorPlan(ConfigPhysicalPlanType type) {
        super(type);
        this.authorType = type;
    }

    public AuthorPlan(ConfigPhysicalPlanType authorType, String userName, String roleName, String password, String newPassword, Set<Integer> permissions, boolean grantOpt, List<PartialPath> nodeNameList) throws AuthException {
        this(authorType);
        this.authorType = authorType;
        this.userName = userName;
        this.roleName = roleName;
        this.password = password;
        this.newPassword = newPassword;
        this.permissions = permissions;
        this.grantOpt = grantOpt;
        this.nodeNameList = nodeNameList;
    }

    public ConfigPhysicalPlanType getAuthorType() {
        return this.authorType;
    }

    public void setAuthorType(ConfigPhysicalPlanType authorType) {
        this.authorType = authorType;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getNewPassword() {
        return this.newPassword;
    }

    public void setNewPassword(String newPassword) {
        this.newPassword = newPassword;
    }

    public Set<Integer> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Set<Integer> permissions) {
        this.permissions = permissions;
    }

    public boolean getGrantOpt() {
        return this.grantOpt;
    }

    public void setGrantOpt(boolean grantOpt) {
        this.grantOpt = grantOpt;
    }

    public List<PartialPath> getNodeNameList() {
        return this.nodeNameList;
    }

    public void setNodeNameList(List<PartialPath> nodeNameList) {
        this.nodeNameList = nodeNameList;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((short)this.getPlanType(this.authorType), (OutputStream)stream);
        BasicStructureSerDeUtil.write((String)this.userName, (DataOutputStream)stream);
        BasicStructureSerDeUtil.write((String)this.roleName, (DataOutputStream)stream);
        BasicStructureSerDeUtil.write((String)this.password, (DataOutputStream)stream);
        BasicStructureSerDeUtil.write((String)this.newPassword, (DataOutputStream)stream);
        if (this.permissions == null) {
            stream.write(0);
        } else {
            stream.write(1);
            stream.writeInt(this.permissions.size());
            for (int permission : this.permissions) {
                stream.writeInt(permission);
            }
        }
        BasicStructureSerDeUtil.write((int)this.nodeNameList.size(), (DataOutputStream)stream);
        for (PartialPath partialPath : this.nodeNameList) {
            BasicStructureSerDeUtil.write((String)partialPath.getFullPath(), (DataOutputStream)stream);
        }
        BasicStructureSerDeUtil.write((int)(this.grantOpt ? 1 : 0), (DataOutputStream)stream);
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) {
        int i;
        this.userName = BasicStructureSerDeUtil.readString((ByteBuffer)buffer);
        this.roleName = BasicStructureSerDeUtil.readString((ByteBuffer)buffer);
        this.password = BasicStructureSerDeUtil.readString((ByteBuffer)buffer);
        this.newPassword = BasicStructureSerDeUtil.readString((ByteBuffer)buffer);
        byte hasPermissions = buffer.get();
        if (hasPermissions == 0) {
            this.permissions = null;
        } else {
            int permissionsSize = buffer.getInt();
            this.permissions = new HashSet<Integer>();
            for (i = 0; i < permissionsSize; ++i) {
                this.permissions.add(buffer.getInt());
            }
        }
        int nodeNameListSize = BasicStructureSerDeUtil.readInt((ByteBuffer)buffer);
        this.nodeNameList = new ArrayList<PartialPath>(nodeNameListSize);
        try {
            for (i = 0; i < nodeNameListSize; ++i) {
                this.nodeNameList.add(new PartialPath(BasicStructureSerDeUtil.readString((ByteBuffer)buffer)));
            }
        }
        catch (MetadataException e) {
            logger.error("Invalid path when deserialize authPlan: {}", this.nodeNameList, (Object)e);
        }
        this.grantOpt = false;
        if (this.authorType.ordinal() >= ConfigPhysicalPlanType.CreateUser.ordinal()) {
            this.grantOpt = BasicStructureSerDeUtil.readInt((ByteBuffer)buffer) > 0;
        }
    }

    private short getPlanType(ConfigPhysicalPlanType configPhysicalPlanType) {
        short type;
        switch (configPhysicalPlanType) {
            case CreateUser: {
                type = ConfigPhysicalPlanType.CreateUser.getPlanType();
                break;
            }
            case CreateRole: {
                type = ConfigPhysicalPlanType.CreateRole.getPlanType();
                break;
            }
            case DropUser: {
                type = ConfigPhysicalPlanType.DropUser.getPlanType();
                break;
            }
            case DropRole: {
                type = ConfigPhysicalPlanType.DropRole.getPlanType();
                break;
            }
            case GrantRole: {
                type = ConfigPhysicalPlanType.GrantRole.getPlanType();
                break;
            }
            case GrantUser: {
                type = ConfigPhysicalPlanType.GrantUser.getPlanType();
                break;
            }
            case GrantRoleToUser: {
                type = ConfigPhysicalPlanType.GrantRoleToUser.getPlanType();
                break;
            }
            case RevokeUser: {
                type = ConfigPhysicalPlanType.RevokeUser.getPlanType();
                break;
            }
            case RevokeRole: {
                type = ConfigPhysicalPlanType.RevokeRole.getPlanType();
                break;
            }
            case RevokeRoleFromUser: {
                type = ConfigPhysicalPlanType.RevokeRoleFromUser.getPlanType();
                break;
            }
            case UpdateUser: {
                type = ConfigPhysicalPlanType.UpdateUser.getPlanType();
                break;
            }
            case ListUser: {
                type = ConfigPhysicalPlanType.ListUser.getPlanType();
                break;
            }
            case ListRole: {
                type = ConfigPhysicalPlanType.ListRole.getPlanType();
                break;
            }
            case ListUserPrivilege: {
                type = ConfigPhysicalPlanType.ListUserPrivilege.getPlanType();
                break;
            }
            case ListRolePrivilege: {
                type = ConfigPhysicalPlanType.ListRolePrivilege.getPlanType();
                break;
            }
            case ListUserRoles: {
                type = ConfigPhysicalPlanType.ListUserRoles.getPlanType();
                break;
            }
            case ListRoleUsers: {
                type = ConfigPhysicalPlanType.ListRoleUsers.getPlanType();
                break;
            }
            case CreateUserWithRawPassword: {
                type = ConfigPhysicalPlanType.CreateUserWithRawPassword.getPlanType();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown operator: " + (Object)((Object)configPhysicalPlanType));
            }
        }
        return type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthorPlan that = (AuthorPlan)o;
        return Objects.equals((Object)this.authorType, (Object)that.authorType) && Objects.equals(this.userName, that.userName) && Objects.equals(this.roleName, that.roleName) && Objects.equals(this.password, that.password) && Objects.equals(this.newPassword, that.newPassword) && Objects.equals(this.permissions, that.permissions) && this.grantOpt == that.grantOpt && Objects.equals(this.nodeNameList, that.nodeNameList);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.authorType, this.userName, this.roleName, this.password, this.newPassword, this.permissions, this.nodeNameList, this.grantOpt});
    }

    public String toString() {
        return "[type:" + (Object)((Object)this.authorType) + ", username:" + this.userName + ", rolename:" + this.roleName + ", permissions:" + PrivilegeType.toPriType(this.permissions) + ", grant option:" + this.grantOpt + ", paths:" + this.nodeNameList + "]";
    }
}

