/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.client.async.handlers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.confignode.client.DataNodeRequestType;
import org.apache.iotdb.confignode.client.async.handlers.rpc.AbstractAsyncRPCHandler;
import org.apache.iotdb.confignode.client.async.handlers.rpc.AsyncTSStatusRPCHandler;
import org.apache.iotdb.confignode.client.async.handlers.rpc.CheckTimeSeriesExistenceRPCHandler;
import org.apache.iotdb.confignode.client.async.handlers.rpc.CountPathsUsingTemplateRPCHandler;
import org.apache.iotdb.confignode.client.async.handlers.rpc.FetchSchemaBlackListRPCHandler;
import org.apache.iotdb.confignode.client.async.handlers.rpc.PipeHeartbeatRPCHandler;
import org.apache.iotdb.confignode.client.async.handlers.rpc.PipePushMetaRPCHandler;
import org.apache.iotdb.confignode.client.async.handlers.rpc.SchemaUpdateRPCHandler;
import org.apache.iotdb.confignode.client.async.handlers.rpc.TransferLeaderRPCHandler;
import org.apache.iotdb.confignode.client.async.handlers.rpc.subscription.ConsumerGroupPushMetaRPCHandler;
import org.apache.iotdb.confignode.client.async.handlers.rpc.subscription.TopicPushMetaRPCHandler;

public class AsyncClientHandler<Q, R> {
    protected final DataNodeRequestType requestType;
    private final Map<Integer, Q> requestMap;
    private final Map<Integer, TDataNodeLocation> dataNodeLocationMap;
    private final Map<Integer, R> responseMap;
    private CountDownLatch countDownLatch;

    public AsyncClientHandler(DataNodeRequestType requestType) {
        this.requestType = requestType;
        this.requestMap = new ConcurrentHashMap<Integer, Q>();
        this.dataNodeLocationMap = new ConcurrentHashMap<Integer, TDataNodeLocation>();
        this.responseMap = new ConcurrentHashMap<Integer, R>();
    }

    public void putRequest(int requestId, Q request) {
        this.requestMap.put(requestId, request);
    }

    public void putDataNodeLocation(int requestId, TDataNodeLocation dataNodeLocation) {
        this.dataNodeLocationMap.put(requestId, dataNodeLocation);
    }

    public AsyncClientHandler(DataNodeRequestType requestType, Map<Integer, TDataNodeLocation> dataNodeLocationMap) {
        this.requestType = requestType;
        this.dataNodeLocationMap = dataNodeLocationMap;
        this.requestMap = new ConcurrentHashMap<Integer, Q>();
        this.responseMap = new ConcurrentHashMap<Integer, R>();
    }

    public AsyncClientHandler(DataNodeRequestType requestType, Q request, Map<Integer, TDataNodeLocation> dataNodeLocationMap) {
        this.requestType = requestType;
        this.dataNodeLocationMap = dataNodeLocationMap;
        this.requestMap = new ConcurrentHashMap<Integer, Q>();
        this.dataNodeLocationMap.keySet().forEach(dataNodeId -> this.requestMap.put((Integer)dataNodeId, request));
        this.responseMap = new ConcurrentHashMap<Integer, R>();
    }

    public DataNodeRequestType getRequestType() {
        return this.requestType;
    }

    public List<Integer> getRequestIndices() {
        return new ArrayList<Integer>(this.dataNodeLocationMap.keySet());
    }

    public Q getRequest(int requestId) {
        return this.requestMap.get(requestId);
    }

    public TDataNodeLocation getDataNodeLocation(int requestId) {
        return this.dataNodeLocationMap.get(requestId);
    }

    public List<R> getResponseList() {
        return new ArrayList<R>(this.responseMap.values());
    }

    public Map<Integer, R> getResponseMap() {
        return this.responseMap;
    }

    public void resetCountDownLatch() {
        this.countDownLatch = new CountDownLatch(this.dataNodeLocationMap.size());
    }

    public CountDownLatch getCountDownLatch() {
        return this.countDownLatch;
    }

    public AbstractAsyncRPCHandler<?> createAsyncRPCHandler(int requestId, TDataNodeLocation targetDataNode) {
        switch (this.requestType) {
            case CONSTRUCT_SCHEMA_BLACK_LIST: 
            case ROLLBACK_SCHEMA_BLACK_LIST: 
            case DELETE_DATA_FOR_DELETE_SCHEMA: 
            case DELETE_TIMESERIES: 
            case CONSTRUCT_SCHEMA_BLACK_LIST_WITH_TEMPLATE: 
            case ROLLBACK_SCHEMA_BLACK_LIST_WITH_TEMPLATE: 
            case DEACTIVATE_TEMPLATE: 
            case CONSTRUCT_VIEW_SCHEMA_BLACK_LIST: 
            case ROLLBACK_VIEW_SCHEMA_BLACK_LIST: 
            case DELETE_VIEW: 
            case ALTER_VIEW: {
                return new SchemaUpdateRPCHandler(this.requestType, requestId, targetDataNode, this.dataNodeLocationMap, this.responseMap, this.countDownLatch);
            }
            case FETCH_SCHEMA_BLACK_LIST: {
                return new FetchSchemaBlackListRPCHandler(this.requestType, requestId, targetDataNode, this.dataNodeLocationMap, this.responseMap, this.countDownLatch);
            }
            case COUNT_PATHS_USING_TEMPLATE: {
                return new CountPathsUsingTemplateRPCHandler(this.requestType, requestId, targetDataNode, this.dataNodeLocationMap, this.responseMap, this.countDownLatch);
            }
            case CHECK_TIMESERIES_EXISTENCE: {
                return new CheckTimeSeriesExistenceRPCHandler(this.requestType, requestId, targetDataNode, this.dataNodeLocationMap, this.responseMap, this.countDownLatch);
            }
            case PIPE_HEARTBEAT: {
                return new PipeHeartbeatRPCHandler(this.requestType, requestId, targetDataNode, this.dataNodeLocationMap, this.responseMap, this.countDownLatch);
            }
            case PIPE_PUSH_ALL_META: 
            case PIPE_PUSH_SINGLE_META: 
            case PIPE_PUSH_MULTI_META: {
                return new PipePushMetaRPCHandler(this.requestType, requestId, targetDataNode, this.dataNodeLocationMap, this.responseMap, this.countDownLatch);
            }
            case TOPIC_PUSH_ALL_META: 
            case TOPIC_PUSH_SINGLE_META: 
            case TOPIC_PUSH_MULTI_META: {
                return new TopicPushMetaRPCHandler(this.requestType, requestId, targetDataNode, this.dataNodeLocationMap, this.responseMap, this.countDownLatch);
            }
            case CONSUMER_GROUP_PUSH_ALL_META: 
            case CONSUMER_GROUP_PUSH_SINGLE_META: {
                return new ConsumerGroupPushMetaRPCHandler(this.requestType, requestId, targetDataNode, this.dataNodeLocationMap, this.responseMap, this.countDownLatch);
            }
            case CHANGE_REGION_LEADER: {
                return new TransferLeaderRPCHandler(this.requestType, requestId, targetDataNode, this.dataNodeLocationMap, this.responseMap, this.countDownLatch);
            }
        }
        return new AsyncTSStatusRPCHandler(this.requestType, requestId, targetDataNode, this.dataNodeLocationMap, this.responseMap, this.countDownLatch);
    }
}

