/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.pipe.api.customizer.parameter;

import java.util.Arrays;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.exception.PipeAttributeNotProvidedException;
import org.apache.iotdb.pipe.api.exception.PipeParameterNotValidException;

public class PipeParameterValidator {
    private final PipeParameters parameters;

    public PipeParameterValidator(PipeParameters parameters) {
        this.parameters = parameters;
    }

    public PipeParameters getParameters() {
        return this.parameters;
    }

    public PipeParameterValidator validateRequiredAttribute(String key) throws PipeAttributeNotProvidedException {
        if (!this.parameters.hasAttribute(key)) {
            throw new PipeAttributeNotProvidedException(key);
        }
        return this;
    }

    public PipeParameterValidator validateAttributeValueRange(String key, boolean canBeOptional, String ... optionalValues) throws PipeAttributeNotProvidedException {
        if (!this.parameters.hasAttribute(key)) {
            if (!canBeOptional) {
                throw new PipeParameterNotValidException(String.format("Parameter %s should be set.", key));
            }
            return this;
        }
        String actualValue = this.parameters.getStringByKeys(key);
        for (String optionalValue : optionalValues) {
            if (!actualValue.equals(optionalValue)) continue;
            return this;
        }
        throw new PipeParameterNotValidException(String.format("The value of %s should be one of %s", key, Arrays.toString(optionalValues)));
    }

    public PipeParameterValidator validate(SingleObjectValidationRule validationRule, String messageToThrow, Object argument) throws PipeParameterNotValidException {
        if (!validationRule.validate(argument)) {
            throw new PipeParameterNotValidException(messageToThrow);
        }
        return this;
    }

    public PipeParameterValidator validate(MultipleObjectsValidationRule validationRule, String messageToThrow, Object ... arguments) throws PipeParameterNotValidException {
        if (!validationRule.validate(arguments)) {
            throw new PipeParameterNotValidException(messageToThrow);
        }
        return this;
    }

    public static interface MultipleObjectsValidationRule {
        public boolean validate(Object ... var1);
    }

    public static interface SingleObjectValidationRule {
        public boolean validate(Object var1);
    }
}

