/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.subscription.broker;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.nio.ByteBuffer;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.pipe.resource.PipeResourceManager;
import org.apache.iotdb.db.pipe.resource.memory.PipeMemoryBlock;
import org.apache.iotdb.tsfile.utils.Pair;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class EnrichedTabletsBinaryCache {
    private final PipeMemoryBlock allocatedMemoryBlock = PipeResourceManager.memory().tryAllocate(Runtime.getRuntime().maxMemory() / 50L);
    private final LoadingCache<Long, Pair<ByteBuffer, EnrichedEvent>> cache = Caffeine.newBuilder().maximumWeight(this.allocatedMemoryBlock.getMemoryUsageInBytes()).weigher((id, enrichedTablets) -> ((ByteBuffer)enrichedTablets.left).limit()).build((CacheLoader)new CacheLoader<Long, Pair<ByteBuffer, EnrichedEvent>>(){

        public @Nullable Pair<ByteBuffer, EnrichedEvent> load(@NonNull Long aLong) throws Exception {
            return null;
        }
    });
}

