/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.plan.analyze.Analysis;
import org.apache.iotdb.db.queryengine.plan.analyze.ExpressionAnalyzer;
import org.apache.iotdb.db.queryengine.plan.analyze.TemplatedInfo;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.queryengine.plan.planner.LogicalPlanBuilder;
import org.apache.iotdb.db.queryengine.plan.planner.LogicalPlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.TemplatedLogicalPlanBuilder;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.InputLocation;
import org.apache.iotdb.db.queryengine.plan.statement.crud.QueryStatement;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;

public class TemplatedLogicalPlan {
    private final Analysis analysis;
    private final QueryStatement queryStatement;
    private final MPPQueryContext context;
    private final List<String> measurementList;
    private final List<IMeasurementSchema> schemaList;
    private final long limitValue;
    private static final long OFFSET_VALUE = 0L;
    private final Expression whereExpression;
    private List<String> newMeasurementList;
    private List<IMeasurementSchema> newSchemaList;
    private Map<String, List<InputLocation>> filterLayoutMap;

    public TemplatedLogicalPlan(Analysis analysis, QueryStatement queryStatement, MPPQueryContext context) {
        this.analysis = analysis;
        this.queryStatement = queryStatement;
        this.context = context;
        this.measurementList = analysis.getMeasurementList();
        this.schemaList = analysis.getMeasurementSchemaList();
        this.newMeasurementList = this.measurementList;
        this.newSchemaList = this.schemaList;
        this.limitValue = LogicalPlanVisitor.pushDownLimitToScanNode(queryStatement, analysis);
        this.whereExpression = analysis.getWhereExpression();
        this.initCommonVariables();
    }

    private void initCommonVariables() {
        if (this.whereExpression != null) {
            if (!this.analysis.isTemplateWildCardQuery()) {
                this.newMeasurementList = new ArrayList<String>(this.measurementList);
                this.newSchemaList = new ArrayList<IMeasurementSchema>(this.schemaList);
                HashSet<String> selectExpressions = new HashSet<String>(this.measurementList);
                List<Expression> whereSourceExpressions = ExpressionAnalyzer.searchSourceExpressions(this.whereExpression);
                for (Expression expression : whereSourceExpressions) {
                    if (!(expression instanceof TimeSeriesOperand)) continue;
                    String measurement = ((TimeSeriesOperand)expression).getPath().getMeasurement();
                    if (!this.analysis.getDeviceTemplate().getSchemaMap().containsKey(measurement) || selectExpressions.contains(measurement)) continue;
                    selectExpressions.add(measurement);
                    this.newMeasurementList.add(measurement);
                    this.newSchemaList.add(this.analysis.getDeviceTemplate().getSchema(measurement));
                }
            }
            this.filterLayoutMap = TemplatedInfo.makeLayout(this.newMeasurementList);
            this.analysis.getExpressionTypes().forEach((key, value) -> this.context.getTypeProvider().setType(((Expression)key.getNode()).getOutputSymbol(), (TSDataType)value));
        }
        this.context.getTypeProvider().setTemplatedInfo(new TemplatedInfo(this.newMeasurementList, this.newSchemaList, this.newSchemaList.stream().map(IMeasurementSchema::getType).collect(Collectors.toList()), this.queryStatement.getResultTimeOrder(), this.analysis.isLastLevelUseWildcard(), this.analysis.getDeviceViewOutputExpressions().stream().map(Expression::getExpressionString).collect(Collectors.toList()), this.analysis.getDeviceViewInputIndexesMap().values().iterator().next(), 0L, this.limitValue, this.whereExpression, this.queryStatement.isGroupByTime(), this.analysis.getDeviceTemplate().getSchemaMap(), this.filterLayoutMap, null));
    }

    public PlanNode visitQuery() {
        LogicalPlanBuilder planBuilder = new TemplatedLogicalPlanBuilder(this.analysis, this.context, this.measurementList, this.schemaList);
        LinkedHashMap<String, PlanNode> deviceToSubPlanMap = new LinkedHashMap<String, PlanNode>();
        for (PartialPath devicePath : this.analysis.getDeviceList()) {
            String deviceName = devicePath.getFullPath();
            PlanNode rootNode = this.visitQueryBody(devicePath);
            LogicalPlanBuilder subPlanBuilder = new TemplatedLogicalPlanBuilder(this.analysis, this.context, this.measurementList, this.schemaList).withNewRoot(rootNode);
            if (this.queryStatement.needPushDownSort()) {
                subPlanBuilder = subPlanBuilder.planOrderBy(this.analysis.getDeviceToOrderByExpressions().get(deviceName), this.analysis.getDeviceToSortItems().get(deviceName));
            }
            deviceToSubPlanMap.put(deviceName, subPlanBuilder.getRoot());
        }
        planBuilder = planBuilder.planDeviceView(deviceToSubPlanMap, this.analysis.getDeviceViewOutputExpressions(), this.analysis.getDeviceViewInputIndexesMap(), this.analysis.getSelectExpressions(), this.queryStatement, this.analysis);
        if (!this.queryStatement.needPushDownSort()) {
            planBuilder = planBuilder.planOrderBy(this.queryStatement, this.analysis);
        }
        planBuilder = planBuilder.planFill(this.analysis.getFillDescriptor(), this.queryStatement.getResultTimeOrder()).planOffset(this.queryStatement.getRowOffset());
        if (!this.analysis.isUseTopKNode() || this.queryStatement.hasOffset()) {
            planBuilder = planBuilder.planLimit(this.queryStatement.getRowLimit());
        }
        return planBuilder.getRoot();
    }

    public PlanNode visitQueryBody(PartialPath devicePath) {
        TemplatedLogicalPlanBuilder planBuilder = new TemplatedLogicalPlanBuilder(this.analysis, this.context, this.newMeasurementList, this.newSchemaList);
        planBuilder = planBuilder.planRawDataSource(devicePath, this.queryStatement.getResultTimeOrder(), 0L, this.limitValue, this.analysis.isLastLevelUseWildcard()).planFilter(this.whereExpression, this.queryStatement.isGroupByTime(), this.queryStatement.getResultTimeOrder());
        return planBuilder.getRoot();
    }
}

