/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.expression.visitor.cartesian;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.common.schematree.ISchemaTree;
import org.apache.iotdb.db.queryengine.plan.analyze.ExpressionUtils;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.ConstantOperand;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.NullOperand;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.TimestampOperand;
import org.apache.iotdb.db.queryengine.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.queryengine.plan.expression.visitor.cartesian.BindSchemaForExpressionVisitor;
import org.apache.iotdb.db.queryengine.plan.expression.visitor.cartesian.CartesianProductVisitor;

public class ConcatDeviceAndBindSchemaForPredicateVisitor
extends CartesianProductVisitor<Context> {
    @Override
    public List<Expression> visitFunctionExpression(FunctionExpression predicate, Context context) {
        if (predicate.isAggregationFunctionExpression() && context.isWhere()) {
            throw new SemanticException("aggregate functions are not supported in WHERE clause");
        }
        ArrayList extendedExpressions = new ArrayList();
        for (Expression suffixExpression : predicate.getExpressions()) {
            extendedExpressions.add((List)this.process(suffixExpression, context));
        }
        ArrayList<List<Expression>> childExpressionsList = new ArrayList<List<Expression>>();
        ExpressionUtils.cartesianProduct(extendedExpressions, childExpressionsList, 0, new ArrayList());
        return ExpressionUtils.reconstructFunctionExpressions(predicate, childExpressionsList);
    }

    @Override
    public List<Expression> visitTimeSeriesOperand(TimeSeriesOperand predicate, Context context) {
        PartialPath measurement = predicate.getPath();
        PartialPath concatPath = context.getDevicePath().concatPath(measurement);
        ArrayList<MeasurementPath> nonViewPathList = new ArrayList<MeasurementPath>();
        ArrayList<MeasurementPath> viewPathList = new ArrayList<MeasurementPath>();
        List actualPaths = (List)context.getSchemaTree().searchMeasurementPaths((PartialPath)concatPath).left;
        if (actualPaths.isEmpty()) {
            return Collections.singletonList(new NullOperand());
        }
        for (MeasurementPath measurementPath : actualPaths) {
            if (measurementPath.getMeasurementSchema().isLogicalView()) {
                viewPathList.add(measurementPath);
                continue;
            }
            nonViewPathList.add(measurementPath);
        }
        List<Expression> reconstructTimeSeriesOperands = ExpressionUtils.reconstructTimeSeriesOperands(predicate, nonViewPathList);
        for (MeasurementPath measurementPath : viewPathList) {
            Expression replacedExpression = BindSchemaForExpressionVisitor.transformViewPath(measurementPath, context.getSchemaTree());
            if (!(replacedExpression instanceof TimeSeriesOperand)) {
                throw new SemanticException("Only writable view timeseries are supported in ALIGN BY DEVICE queries.");
            }
            replacedExpression.setViewPath((PartialPath)measurementPath);
            reconstructTimeSeriesOperands.add(replacedExpression);
        }
        return reconstructTimeSeriesOperands;
    }

    @Override
    public List<Expression> visitTimeStampOperand(TimestampOperand timestampOperand, Context context) {
        return Collections.singletonList(timestampOperand);
    }

    @Override
    public List<Expression> visitConstantOperand(ConstantOperand constantOperand, Context context) {
        return Collections.singletonList(constantOperand);
    }

    public static class Context {
        private final PartialPath devicePath;
        private final ISchemaTree schemaTree;
        private final boolean isWhere;

        public Context(PartialPath devicePath, ISchemaTree schemaTree, boolean isWhere) {
            this.devicePath = devicePath;
            this.schemaTree = schemaTree;
            this.isWhere = isWhere;
        }

        public PartialPath getDevicePath() {
            return this.devicePath;
        }

        public ISchemaTree getSchemaTree() {
            return this.schemaTree;
        }

        public boolean isWhere() {
            return this.isWhere;
        }
    }
}

