/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.commons.path.AlignedPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.execution.fragment.QueryContext;
import org.apache.iotdb.db.queryengine.metric.SeriesScanCostMetricSet;
import org.apache.iotdb.db.storageengine.buffer.TimeSeriesMetadataCache;
import org.apache.iotdb.db.storageengine.dataregion.modification.Modification;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.chunk.metadata.DiskAlignedChunkMetadataLoader;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.chunk.metadata.DiskChunkMetadataLoader;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.chunk.metadata.MemAlignedChunkMetadataLoader;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.chunk.metadata.MemChunkMetadataLoader;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.tsfile.file.metadata.AlignedTimeSeriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.IDeviceID;
import org.apache.iotdb.tsfile.file.metadata.IMetadata;
import org.apache.iotdb.tsfile.file.metadata.ITimeSeriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.PlainDeviceID;
import org.apache.iotdb.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.iotdb.tsfile.read.controller.IChunkLoader;
import org.apache.iotdb.tsfile.read.controller.IChunkMetadataLoader;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.reader.IChunkReader;
import org.apache.iotdb.tsfile.read.reader.IPageReader;

public class FileLoaderUtils {
    private static final SeriesScanCostMetricSet SERIES_SCAN_COST_METRIC_SET = SeriesScanCostMetricSet.getInstance();

    private FileLoaderUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TimeseriesMetadata loadTimeSeriesMetadata(TsFileResource resource, PartialPath seriesPath, QueryContext context, Filter globalTimeFilter, Set<String> allSensors, boolean isSeq) throws IOException {
        long t1 = System.nanoTime();
        boolean loadFromMem = false;
        try {
            TimeseriesMetadata timeSeriesMetadata;
            block21: {
                if (resource.isClosed()) {
                    timeSeriesMetadata = TimeSeriesMetadataCache.getInstance().get(resource.getTsFilePath(), new TimeSeriesMetadataCache.TimeSeriesMetadataCacheKey(resource.getTsFileID(), (IDeviceID)new PlainDeviceID(seriesPath.getDevice()), seriesPath.getMeasurement()), allSensors, resource.getTimeIndexType() != 1, context.isDebug());
                    if (timeSeriesMetadata != null) {
                        List<Modification> pathModifications = context.getPathModifications(resource, seriesPath);
                        timeSeriesMetadata.setModified(!pathModifications.isEmpty());
                        timeSeriesMetadata.setChunkMetadataLoader((IChunkMetadataLoader)new DiskChunkMetadataLoader(resource, context, globalTimeFilter, pathModifications));
                    }
                } else {
                    loadFromMem = true;
                    timeSeriesMetadata = (TimeseriesMetadata)resource.getTimeSeriesMetadata(seriesPath);
                    if (timeSeriesMetadata != null) {
                        timeSeriesMetadata.setChunkMetadataLoader((IChunkMetadataLoader)new MemChunkMetadataLoader(resource, seriesPath, context, globalTimeFilter));
                    }
                }
                if (timeSeriesMetadata != null) {
                    long t2 = System.nanoTime();
                    if (timeSeriesMetadata.getStatistics().getStartTime() > timeSeriesMetadata.getStatistics().getEndTime()) {
                        TimeseriesMetadata timeseriesMetadata = null;
                        return timeseriesMetadata;
                    }
                    if (globalTimeFilter == null || !globalTimeFilter.canSkip((IMetadata)timeSeriesMetadata)) break block21;
                    TimeseriesMetadata timeseriesMetadata = null;
                    return timeseriesMetadata;
                    finally {
                        SERIES_SCAN_COST_METRIC_SET.recordSeriesScanCost("timeseries_metadata_modification_non_aligned", System.nanoTime() - t2);
                    }
                }
            }
            TimeseriesMetadata timeseriesMetadata = timeSeriesMetadata;
            return timeseriesMetadata;
        }
        finally {
            long costTime = System.nanoTime() - t1;
            if (loadFromMem) {
                if (isSeq) {
                    context.getQueryStatistics().loadTimeSeriesMetadataMemSeqCount.getAndAdd(1L);
                    context.getQueryStatistics().loadTimeSeriesMetadataMemSeqTime.getAndAdd(costTime);
                } else {
                    context.getQueryStatistics().loadTimeSeriesMetadataMemUnSeqCount.getAndAdd(1L);
                    context.getQueryStatistics().loadTimeSeriesMetadataMemUnSeqTime.getAndAdd(costTime);
                }
            } else if (isSeq) {
                context.getQueryStatistics().loadTimeSeriesMetadataDiskSeqCount.getAndAdd(1L);
                context.getQueryStatistics().loadTimeSeriesMetadataDiskSeqTime.getAndAdd(costTime);
            } else {
                context.getQueryStatistics().loadTimeSeriesMetadataDiskUnSeqCount.getAndAdd(1L);
                context.getQueryStatistics().loadTimeSeriesMetadataDiskUnSeqTime.getAndAdd(costTime);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AlignedTimeSeriesMetadata loadAlignedTimeSeriesMetadata(TsFileResource resource, AlignedPath alignedPath, QueryContext context, Filter globalTimeFilter, boolean isSeq) throws IOException {
        long t1 = System.nanoTime();
        boolean loadFromMem = false;
        try {
            AlignedTimeSeriesMetadata alignedTimeSeriesMetadata;
            block20: {
                if (resource.isClosed()) {
                    alignedTimeSeriesMetadata = FileLoaderUtils.loadAlignedTimeSeriesMetadataFromDisk(resource, alignedPath, context, globalTimeFilter);
                } else {
                    loadFromMem = true;
                    alignedTimeSeriesMetadata = (AlignedTimeSeriesMetadata)resource.getTimeSeriesMetadata((PartialPath)alignedPath);
                    if (alignedTimeSeriesMetadata != null) {
                        alignedTimeSeriesMetadata.setChunkMetadataLoader((IChunkMetadataLoader)new MemAlignedChunkMetadataLoader(resource, (PartialPath)alignedPath, context, globalTimeFilter));
                    }
                }
                if (alignedTimeSeriesMetadata != null) {
                    long t2 = System.nanoTime();
                    if (alignedTimeSeriesMetadata.getTimeseriesMetadata().getStatistics().getStartTime() > alignedTimeSeriesMetadata.getTimeseriesMetadata().getStatistics().getEndTime()) {
                        AlignedTimeSeriesMetadata alignedTimeSeriesMetadata2 = null;
                        return alignedTimeSeriesMetadata2;
                    }
                    if (globalTimeFilter == null || !globalTimeFilter.canSkip((IMetadata)alignedTimeSeriesMetadata)) break block20;
                    AlignedTimeSeriesMetadata alignedTimeSeriesMetadata3 = null;
                    return alignedTimeSeriesMetadata3;
                    finally {
                        SERIES_SCAN_COST_METRIC_SET.recordSeriesScanCost("timeseries_metadata_modification_aligned", System.nanoTime() - t2);
                    }
                }
            }
            AlignedTimeSeriesMetadata alignedTimeSeriesMetadata4 = alignedTimeSeriesMetadata;
            return alignedTimeSeriesMetadata4;
        }
        finally {
            long costTime = System.nanoTime() - t1;
            if (loadFromMem) {
                if (isSeq) {
                    context.getQueryStatistics().loadTimeSeriesMetadataAlignedMemSeqCount.getAndAdd(1L);
                    context.getQueryStatistics().loadTimeSeriesMetadataAlignedMemSeqTime.getAndAdd(costTime);
                } else {
                    context.getQueryStatistics().loadTimeSeriesMetadataAlignedMemUnSeqCount.getAndAdd(1L);
                    context.getQueryStatistics().loadTimeSeriesMetadataAlignedMemUnSeqTime.getAndAdd(costTime);
                }
            } else if (isSeq) {
                context.getQueryStatistics().loadTimeSeriesMetadataAlignedDiskSeqCount.getAndAdd(1L);
                context.getQueryStatistics().loadTimeSeriesMetadataAlignedDiskSeqTime.getAndAdd(costTime);
            } else {
                context.getQueryStatistics().loadTimeSeriesMetadataAlignedDiskUnSeqCount.getAndAdd(1L);
                context.getQueryStatistics().loadTimeSeriesMetadataAlignedDiskUnSeqTime.getAndAdd(costTime);
            }
        }
    }

    private static AlignedTimeSeriesMetadata loadAlignedTimeSeriesMetadataFromDisk(TsFileResource resource, AlignedPath alignedPath, QueryContext context, Filter globalTimeFilter) throws IOException {
        AlignedTimeSeriesMetadata alignedTimeSeriesMetadata = null;
        TimeSeriesMetadataCache cache = TimeSeriesMetadataCache.getInstance();
        List valueMeasurementList = alignedPath.getMeasurementList();
        HashSet<String> allSensors = new HashSet<String>(valueMeasurementList);
        allSensors.add("");
        boolean isDebug = context.isDebug();
        String filePath = resource.getTsFilePath();
        IDeviceID deviceId = alignedPath.getIDeviceID();
        TimeseriesMetadata timeColumn = cache.get(filePath, new TimeSeriesMetadataCache.TimeSeriesMetadataCacheKey(resource.getTsFileID(), deviceId, ""), allSensors, resource.getTimeIndexType() != 1, isDebug);
        if (timeColumn != null) {
            if (valueMeasurementList.isEmpty()) {
                alignedTimeSeriesMetadata = new AlignedTimeSeriesMetadata(timeColumn, Collections.emptyList());
                alignedTimeSeriesMetadata.setChunkMetadataLoader((IChunkMetadataLoader)new DiskAlignedChunkMetadataLoader(resource, context, globalTimeFilter, Collections.emptyList()));
            } else {
                ArrayList<TimeseriesMetadata> valueTimeSeriesMetadataList = new ArrayList<TimeseriesMetadata>(valueMeasurementList.size());
                boolean exist = false;
                for (String valueMeasurement : valueMeasurementList) {
                    TimeseriesMetadata valueColumn = cache.get(filePath, new TimeSeriesMetadataCache.TimeSeriesMetadataCacheKey(resource.getTsFileID(), deviceId, valueMeasurement), allSensors, resource.getTimeIndexType() != 1, isDebug);
                    exist = exist || valueColumn != null;
                    valueTimeSeriesMetadataList.add(valueColumn);
                }
                if (exist) {
                    alignedTimeSeriesMetadata = new AlignedTimeSeriesMetadata(timeColumn, valueTimeSeriesMetadataList);
                    List<List<Modification>> pathModifications = FileLoaderUtils.setModifications(resource, alignedTimeSeriesMetadata, alignedPath, context);
                    alignedTimeSeriesMetadata.setChunkMetadataLoader((IChunkMetadataLoader)new DiskAlignedChunkMetadataLoader(resource, context, globalTimeFilter, pathModifications));
                }
            }
        }
        return alignedTimeSeriesMetadata;
    }

    private static List<List<Modification>> setModifications(TsFileResource resource, AlignedTimeSeriesMetadata alignedTimeSeriesMetadata, AlignedPath alignedPath, QueryContext context) {
        List valueTimeSeriesMetadataList = alignedTimeSeriesMetadata.getValueTimeseriesMetadataList();
        ArrayList<List<Modification>> res = new ArrayList<List<Modification>>();
        boolean modified = false;
        for (int i = 0; i < valueTimeSeriesMetadataList.size(); ++i) {
            if (valueTimeSeriesMetadataList.get(i) != null) {
                List<Modification> pathModifications = context.getPathModifications(resource, alignedPath.getPathWithMeasurement(i));
                ((TimeseriesMetadata)valueTimeSeriesMetadataList.get(i)).setModified(!pathModifications.isEmpty());
                res.add(pathModifications);
                modified = modified || !pathModifications.isEmpty();
                continue;
            }
            res.add(Collections.emptyList());
        }
        alignedTimeSeriesMetadata.getTimeseriesMetadata().setModified(modified);
        return res;
    }

    public static List<IChunkMetadata> loadChunkMetadataList(ITimeSeriesMetadata timeSeriesMetadata) {
        return timeSeriesMetadata.loadChunkMetadataList();
    }

    public static List<IPageReader> loadPageReaderList(IChunkMetadata chunkMetaData, Filter globalTimeFilter) throws IOException {
        Preconditions.checkArgument((chunkMetaData != null ? 1 : 0) != 0, (Object)"Can't init null chunkMeta");
        IChunkLoader chunkLoader = chunkMetaData.getChunkLoader();
        IChunkReader chunkReader = chunkLoader.getChunkReader(chunkMetaData, globalTimeFilter);
        return chunkReader.loadPageReaderList();
    }
}

