/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.join;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.ProcessOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.TimeComparator;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumn;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumnBuilder;

public class LeftOuterTimeJoinOperator
implements ProcessOperator {
    private final OperatorContext operatorContext;
    private final int outputColumnCount;
    private final TimeComparator comparator;
    private final TsBlockBuilder resultBuilder;
    private final Operator left;
    private final int leftColumnCount;
    private TsBlock leftTsBlock;
    private int leftIndex;
    private final Operator right;
    private TsBlock rightTsBlock;
    private int rightIndex;
    private boolean rightFinished = false;
    private final long maxReturnSize = TSFileDescriptor.getInstance().getConfig().getMaxTsBlockSizeInBytes();

    public LeftOuterTimeJoinOperator(OperatorContext operatorContext, Operator leftChild, int leftColumnCount, Operator rightChild, List<TSDataType> dataTypes, TimeComparator comparator) {
        this.operatorContext = operatorContext;
        this.resultBuilder = new TsBlockBuilder(dataTypes);
        this.outputColumnCount = dataTypes.size();
        this.comparator = comparator;
        this.left = leftChild;
        this.leftColumnCount = leftColumnCount;
        this.right = rightChild;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        ListenableFuture<?> leftBlocked = this.left.isBlocked();
        ListenableFuture<?> rightBlocked = this.right.isBlocked();
        if (leftBlocked.isDone()) {
            return rightBlocked;
        }
        if (rightBlocked.isDone()) {
            return leftBlocked;
        }
        return Futures.successfulAsList((ListenableFuture[])new ListenableFuture[]{leftBlocked, rightBlocked});
    }

    @Override
    public TsBlock next() throws Exception {
        long maxRuntime = this.operatorContext.getMaxRunTime().roundTo(TimeUnit.NANOSECONDS);
        long start = System.nanoTime();
        if (!this.prepareInput(start, maxRuntime)) {
            return null;
        }
        if (System.nanoTime() - start < maxRuntime) {
            long currentEndTime = this.rightFinished ? this.leftTsBlock.getEndTime() : this.comparator.getCurrentEndTime(this.leftTsBlock.getEndTime(), this.rightTsBlock.getEndTime());
            long time = this.leftTsBlock.getTimeByIndex(this.leftIndex);
            if (!this.rightFinished && this.comparator.largerThan(time, this.rightTsBlock.getEndTime())) {
                this.rightTsBlock = null;
                this.rightIndex = 0;
            } else if (this.rightFinished || this.comparator.lessThan(this.leftTsBlock.getEndTime(), this.rightTsBlock.getTimeByIndex(this.rightIndex))) {
                this.appendAllLeftTableAndFillNullForRightTable();
            } else {
                int leftRowSize = this.leftTsBlock.getPositionCount();
                TimeColumnBuilder timeColumnBuilder = this.resultBuilder.getTimeColumnBuilder();
                while (this.comparator.canContinueInclusive(time, currentEndTime) && !this.resultBuilder.isFull() && this.appendRightTableRow(time)) {
                    timeColumnBuilder.writeLong(time);
                    this.resultBuilder.declarePosition();
                    this.appendLeftTableRow();
                    if (this.leftIndex < leftRowSize) {
                        time = this.leftTsBlock.getTimeByIndex(this.leftIndex);
                        continue;
                    }
                    this.leftTsBlock = null;
                    this.leftIndex = 0;
                    break;
                }
            }
        }
        TsBlock res = this.resultBuilder.build();
        this.resultBuilder.reset();
        return res;
    }

    private boolean prepareInput(long start, long maxRuntime) throws Exception {
        if ((this.leftTsBlock == null || this.leftTsBlock.getPositionCount() == this.leftIndex) && this.left.hasNextWithTimer()) {
            this.leftTsBlock = this.left.nextWithTimer();
            this.leftIndex = 0;
        }
        if (!(System.nanoTime() - start >= maxRuntime || this.rightFinished || this.rightTsBlock != null && this.rightTsBlock.getPositionCount() != this.rightIndex)) {
            if (this.right.hasNextWithTimer()) {
                this.rightTsBlock = this.right.nextWithTimer();
                this.rightIndex = 0;
            } else {
                this.rightFinished = true;
            }
        }
        return this.tsBlockIsNotEmpty(this.leftTsBlock, this.leftIndex) && (this.rightFinished || this.tsBlockIsNotEmpty(this.rightTsBlock, this.rightIndex));
    }

    private boolean tsBlockIsNotEmpty(TsBlock tsBlock, int index) {
        return tsBlock != null && index < tsBlock.getPositionCount();
    }

    private void appendLeftTableRow() {
        for (int i = 0; i < this.leftColumnCount; ++i) {
            Column leftColumn = this.leftTsBlock.getColumn(i);
            ColumnBuilder columnBuilder = this.resultBuilder.getColumnBuilder(i);
            if (leftColumn.isNull(this.leftIndex)) {
                columnBuilder.appendNull();
                continue;
            }
            columnBuilder.write(leftColumn, this.leftIndex);
        }
        ++this.leftIndex;
    }

    private boolean appendRightTableRow(long time) {
        int rowCount = this.rightTsBlock.getPositionCount();
        while (this.rightIndex < rowCount && this.comparator.lessThan(this.rightTsBlock.getTimeByIndex(this.rightIndex), time)) {
            ++this.rightIndex;
        }
        if (this.rightIndex == rowCount) {
            this.rightTsBlock = null;
            this.rightIndex = 0;
            return false;
        }
        if (this.rightTsBlock.getTimeByIndex(this.rightIndex) == time) {
            for (int i = this.leftColumnCount; i < this.outputColumnCount; ++i) {
                Column rightColumn = this.rightTsBlock.getColumn(i - this.leftColumnCount);
                ColumnBuilder columnBuilder = this.resultBuilder.getColumnBuilder(i);
                if (rightColumn.isNull(this.rightIndex)) {
                    columnBuilder.appendNull();
                    continue;
                }
                columnBuilder.write(rightColumn, this.rightIndex);
            }
            ++this.rightIndex;
        } else {
            for (int i = this.leftColumnCount; i < this.outputColumnCount; ++i) {
                this.resultBuilder.getColumnBuilder(i).appendNull();
            }
        }
        return true;
    }

    private void appendAllLeftTableAndFillNullForRightTable() {
        int rowSize = this.leftTsBlock.getPositionCount();
        TimeColumnBuilder timeColumnBuilder = this.resultBuilder.getTimeColumnBuilder();
        TimeColumn leftTimeColumn = this.leftTsBlock.getTimeColumn();
        for (int i = this.leftIndex; i < rowSize; ++i) {
            timeColumnBuilder.writeLong(leftTimeColumn.getLong(i));
        }
        this.resultBuilder.declarePositions(rowSize - this.leftIndex);
        this.appendValueColumnForLeftTable(rowSize);
        this.appendNullForRightTable(rowSize);
        this.leftTsBlock = null;
        this.leftIndex = 0;
    }

    private void appendValueColumnForLeftTable(int rowSize) {
        for (int i = 0; i < this.leftColumnCount; ++i) {
            int rowIndex;
            ColumnBuilder columnBuilder = this.resultBuilder.getColumnBuilder(i);
            Column valueColumn = this.leftTsBlock.getColumn(i);
            if (valueColumn.mayHaveNull()) {
                for (rowIndex = this.leftIndex; rowIndex < rowSize; ++rowIndex) {
                    if (valueColumn.isNull(rowIndex)) {
                        columnBuilder.appendNull();
                        continue;
                    }
                    columnBuilder.write(valueColumn, rowIndex);
                }
                continue;
            }
            for (rowIndex = this.leftIndex; rowIndex < rowSize; ++rowIndex) {
                columnBuilder.write(valueColumn, rowIndex);
            }
        }
    }

    private void appendNullForRightTable(int rowSize) {
        int nullCount = rowSize - this.leftIndex;
        for (int i = this.leftColumnCount; i < this.outputColumnCount; ++i) {
            ColumnBuilder columnBuilder = this.resultBuilder.getColumnBuilder(i);
            columnBuilder.appendNull(nullCount);
        }
    }

    @Override
    public boolean hasNext() throws Exception {
        return this.tsBlockIsNotEmpty(this.leftTsBlock, this.leftIndex) || this.left.hasNextWithTimer();
    }

    @Override
    public void close() throws Exception {
        if (this.left != null) {
            this.left.close();
        }
        if (this.right != null) {
            this.right.close();
        }
    }

    @Override
    public boolean isFinished() throws Exception {
        return !this.tsBlockIsNotEmpty(this.leftTsBlock, this.leftIndex) && this.left.isFinished();
    }

    @Override
    public long calculateMaxPeekMemory() {
        return Math.max(Math.max(this.left.calculateMaxPeekMemoryWithCounter(), this.right.calculateMaxPeekMemoryWithCounter()), this.calculateRetainedSizeAfterCallingNext() + this.calculateMaxReturnSize());
    }

    @Override
    public long calculateMaxReturnSize() {
        return this.maxReturnSize;
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return this.left.calculateMaxReturnSize() + this.left.calculateRetainedSizeAfterCallingNext() + this.right.calculateMaxReturnSize() + this.right.calculateRetainedSizeAfterCallingNext();
    }
}

