/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.task.stage;

import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.pipe.config.plugin.configuraion.PipeTaskRuntimeConfiguration;
import org.apache.iotdb.commons.pipe.config.plugin.env.PipeTaskProcessorRuntimeEnvironment;
import org.apache.iotdb.commons.pipe.plugin.builtin.BuiltinPipePlugin;
import org.apache.iotdb.commons.pipe.task.EventSupplier;
import org.apache.iotdb.commons.pipe.task.connection.BoundedBlockingPendingQueue;
import org.apache.iotdb.commons.pipe.task.meta.PipeTaskMeta;
import org.apache.iotdb.commons.pipe.task.stage.PipeTaskStage;
import org.apache.iotdb.commons.pipe.task.subtask.PipeSubtask;
import org.apache.iotdb.db.pipe.agent.PipeAgent;
import org.apache.iotdb.db.pipe.execution.PipeProcessorSubtaskExecutor;
import org.apache.iotdb.db.pipe.task.connection.PipeEventCollector;
import org.apache.iotdb.db.pipe.task.subtask.processor.PipeProcessorSubtask;
import org.apache.iotdb.db.storageengine.StorageEngine;
import org.apache.iotdb.pipe.api.PipeProcessor;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeProcessorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeRuntimeEnvironment;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.exception.PipeException;

public class PipeTaskProcessorStage
extends PipeTaskStage {
    private final PipeProcessorSubtaskExecutor executor;
    private final PipeProcessorSubtask pipeProcessorSubtask;

    public PipeTaskProcessorStage(String pipeName, long creationTime, PipeParameters pipeProcessorParameters, int regionId, EventSupplier pipeExtractorInputEventSupplier, BoundedBlockingPendingQueue<Event> pipeConnectorOutputPendingQueue, PipeProcessorSubtaskExecutor executor, PipeTaskMeta pipeTaskMeta) {
        PipeTaskRuntimeConfiguration runtimeConfiguration = new PipeTaskRuntimeConfiguration((PipeRuntimeEnvironment)new PipeTaskProcessorRuntimeEnvironment(pipeName, creationTime, regionId, pipeTaskMeta));
        PipeProcessor pipeProcessor = StorageEngine.getInstance().getAllDataRegionIds().contains(new DataRegionId(regionId)) ? PipeAgent.plugin().dataRegion().getConfiguredProcessor(pipeProcessorParameters.getStringOrDefault("processor", BuiltinPipePlugin.DO_NOTHING_PROCESSOR.getPipePluginName()), pipeProcessorParameters, (PipeProcessorRuntimeConfiguration)runtimeConfiguration) : PipeAgent.plugin().schemaRegion().getConfiguredProcessor(pipeProcessorParameters.getStringOrDefault("processor", BuiltinPipePlugin.DO_NOTHING_PROCESSOR.getPipePluginName()), pipeProcessorParameters, (PipeProcessorRuntimeConfiguration)runtimeConfiguration);
        String taskId = pipeName + "_" + regionId + "_" + creationTime;
        PipeEventCollector pipeConnectorOutputEventCollector = new PipeEventCollector(pipeConnectorOutputPendingQueue, creationTime, regionId);
        this.pipeProcessorSubtask = new PipeProcessorSubtask(taskId, creationTime, pipeName, regionId, pipeExtractorInputEventSupplier, pipeProcessor, pipeConnectorOutputEventCollector);
        this.executor = executor;
    }

    public void createSubtask() throws PipeException {
        this.executor.register((PipeSubtask)this.pipeProcessorSubtask);
    }

    public void startSubtask() throws PipeException {
        this.executor.start(this.pipeProcessorSubtask.getTaskID());
    }

    public void stopSubtask() throws PipeException {
        this.executor.stop(this.pipeProcessorSubtask.getTaskID());
    }

    public void dropSubtask() throws PipeException {
        this.executor.deregister(this.pipeProcessorSubtask.getTaskID());
    }
}

