/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.processor.twostage.exchange.payload;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferResp;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class FetchCombineResultResponse
extends TPipeTransferResp {
    private Map<String, CombineResultType> combineId2ResultType = new HashMap<String, CombineResultType>();

    private FetchCombineResultResponse() {
    }

    public Map<String, CombineResultType> getCombineId2ResultType() {
        return this.combineId2ResultType;
    }

    public static FetchCombineResultResponse toTPipeTransferResp(Map<String, CombineResultType> combineId2ResultType) throws IOException {
        FetchCombineResultResponse response = new FetchCombineResultResponse();
        response.combineId2ResultType = combineId2ResultType;
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();
             DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);){
            ReadWriteIOUtils.write((int)combineId2ResultType.size(), (OutputStream)outputStream);
            for (Map.Entry<String, CombineResultType> entry : combineId2ResultType.entrySet()) {
                ReadWriteIOUtils.write((String)entry.getKey(), (OutputStream)outputStream);
                ReadWriteIOUtils.write((int)entry.getValue().ordinal(), (OutputStream)outputStream);
            }
            response.body = ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
        }
        response.status = RpcUtils.SUCCESS_STATUS;
        return response;
    }

    public static FetchCombineResultResponse fromTPipeTransferResp(TPipeTransferResp transferResp) {
        FetchCombineResultResponse response = new FetchCombineResultResponse();
        response.status = transferResp.status;
        response.body = transferResp.body;
        response.combineId2ResultType = new HashMap<String, CombineResultType>();
        if (response.isSetBody()) {
            int size = ReadWriteIOUtils.readInt((ByteBuffer)transferResp.body);
            for (int i = 0; i < size; ++i) {
                String combineId = ReadWriteIOUtils.readString((ByteBuffer)transferResp.body);
                CombineResultType resultType = CombineResultType.values()[ReadWriteIOUtils.readInt((ByteBuffer)transferResp.body)];
                response.combineId2ResultType.put(combineId, resultType);
            }
        }
        return response;
    }

    public String toString() {
        return "FetchCombineResultResponse{combineId2ResultType=" + this.combineId2ResultType + '}';
    }

    public static enum CombineResultType {
        SUCCESS,
        INCOMPLETE,
        OUTDATED;

    }
}

