/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.event.common.tsfile;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.pipe.pattern.PipePattern;
import org.apache.iotdb.commons.pipe.task.meta.PipeTaskMeta;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeRawTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tsfile.TsFileInsertionDataTabletIterator;
import org.apache.iotdb.db.pipe.resource.PipeResourceManager;
import org.apache.iotdb.db.pipe.resource.memory.PipeMemoryBlock;
import org.apache.iotdb.db.pipe.resource.memory.PipeMemoryWeighUtil;
import org.apache.iotdb.db.pipe.resource.tsfile.PipeTsFileResourceManager;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.tsfile.file.metadata.IDeviceID;
import org.apache.iotdb.tsfile.file.metadata.PlainDeviceID;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.TsFileDeviceIterator;
import org.apache.iotdb.tsfile.read.TsFileReader;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.expression.IExpression;
import org.apache.iotdb.tsfile.read.expression.impl.BinaryExpression;
import org.apache.iotdb.tsfile.read.expression.impl.GlobalTimeExpression;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.factory.TimeFilterApi;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.record.Tablet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileInsertionDataContainer
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(TsFileInsertionDataContainer.class);
    private final PipePattern pattern;
    private final IExpression timeFilterExpression;
    private final PipeTaskMeta pipeTaskMeta;
    private final EnrichedEvent sourceEvent;
    private final PipeMemoryBlock allocatedMemoryBlock;
    private final TsFileSequenceReader tsFileSequenceReader;
    private final TsFileReader tsFileReader;
    private final Iterator<Map.Entry<IDeviceID, List<String>>> deviceMeasurementsMapIterator;
    private final Map<IDeviceID, Boolean> deviceIsAlignedMap;
    private final Map<String, TSDataType> measurementDataTypeMap;
    private boolean shouldParsePattern = false;

    public TsFileInsertionDataContainer(File tsFile, PipePattern pattern, long startTime, long endTime) throws IOException {
        this(tsFile, pattern, startTime, endTime, null, null);
    }

    public TsFileInsertionDataContainer(File tsFile, PipePattern pattern, long startTime, long endTime, PipeTaskMeta pipeTaskMeta, EnrichedEvent sourceEvent) throws IOException {
        this.pattern = pattern;
        this.timeFilterExpression = startTime == Long.MIN_VALUE && endTime == Long.MAX_VALUE ? null : BinaryExpression.and((IExpression)new GlobalTimeExpression((Filter)TimeFilterApi.gtEq((long)startTime)), (IExpression)new GlobalTimeExpression((Filter)TimeFilterApi.ltEq((long)endTime)));
        this.pipeTaskMeta = pipeTaskMeta;
        this.sourceEvent = sourceEvent;
        try {
            Map deviceMeasurementsMap;
            PipeTsFileResourceManager tsFileResourceManager = PipeResourceManager.tsfile();
            long memoryRequiredInBytes = PipeConfig.getInstance().getPipeMemoryAllocateForTsFileSequenceReaderInBytes();
            this.tsFileSequenceReader = new TsFileSequenceReader(tsFile.getPath(), true, true);
            this.tsFileReader = new TsFileReader(this.tsFileSequenceReader);
            if (tsFileResourceManager.cacheObjectsIfAbsent(tsFile)) {
                this.deviceIsAlignedMap = tsFileResourceManager.getDeviceIsAlignedMapFromCache(tsFile);
                this.measurementDataTypeMap = tsFileResourceManager.getMeasurementDataTypeMapFromCache(tsFile);
                deviceMeasurementsMap = tsFileResourceManager.getDeviceMeasurementsMapFromCache(tsFile);
            } else {
                this.deviceIsAlignedMap = this.readDeviceIsAlignedMap();
                memoryRequiredInBytes += PipeMemoryWeighUtil.memoryOfIDeviceId2Bool(this.deviceIsAlignedMap);
                this.measurementDataTypeMap = this.tsFileSequenceReader.getFullPathDataTypeMap();
                memoryRequiredInBytes += PipeMemoryWeighUtil.memoryOfStr2TSDataType(this.measurementDataTypeMap);
                deviceMeasurementsMap = this.tsFileSequenceReader.getDeviceMeasurementsMap();
                memoryRequiredInBytes += PipeMemoryWeighUtil.memoryOfIDeviceID2StrList(deviceMeasurementsMap);
            }
            this.allocatedMemoryBlock = PipeResourceManager.memory().forceAllocate(memoryRequiredInBytes);
            this.deviceMeasurementsMapIterator = this.filterDeviceMeasurementsMapByPattern(deviceMeasurementsMap).entrySet().iterator();
            this.tsFileSequenceReader.clearCachedDeviceMetadata();
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
    }

    private Map<IDeviceID, List<String>> filterDeviceMeasurementsMapByPattern(Map<IDeviceID, List<String>> originalDeviceMeasurementsMap) {
        HashMap<IDeviceID, List<String>> filteredDeviceMeasurementsMap = new HashMap<IDeviceID, List<String>>();
        for (Map.Entry<IDeviceID, List<String>> entry : originalDeviceMeasurementsMap.entrySet()) {
            String deviceId = ((PlainDeviceID)entry.getKey()).toStringID();
            if (Objects.isNull(this.pattern) || this.pattern.isRoot() || this.pattern.coversDevice(deviceId)) {
                if (entry.getValue().isEmpty()) continue;
                filteredDeviceMeasurementsMap.put((IDeviceID)new PlainDeviceID(deviceId), entry.getValue());
                continue;
            }
            if (this.pattern.mayOverlapWithDevice(deviceId)) {
                ArrayList<String> filteredMeasurements = new ArrayList<String>();
                for (String measurement : entry.getValue()) {
                    if (this.pattern.matchesMeasurement(deviceId, measurement)) {
                        filteredMeasurements.add(measurement);
                        continue;
                    }
                    this.shouldParsePattern = true;
                }
                if (filteredMeasurements.isEmpty()) continue;
                filteredDeviceMeasurementsMap.put((IDeviceID)new PlainDeviceID(deviceId), filteredMeasurements);
                continue;
            }
            this.shouldParsePattern = true;
        }
        return filteredDeviceMeasurementsMap;
    }

    private Map<IDeviceID, Boolean> readDeviceIsAlignedMap() throws IOException {
        HashMap<IDeviceID, Boolean> deviceIsAlignedResultMap = new HashMap<IDeviceID, Boolean>();
        TsFileDeviceIterator deviceIsAlignedIterator = this.tsFileSequenceReader.getAllDevicesIteratorWithIsAligned();
        while (deviceIsAlignedIterator.hasNext()) {
            Pair deviceIsAlignedPair = deviceIsAlignedIterator.next();
            deviceIsAlignedResultMap.put((IDeviceID)deviceIsAlignedPair.getLeft(), (Boolean)deviceIsAlignedPair.getRight());
        }
        return deviceIsAlignedResultMap;
    }

    public Iterable<TabletInsertionEvent> toTabletInsertionEvents() {
        return () -> new Iterator<TabletInsertionEvent>(){
            private TsFileInsertionDataTabletIterator tabletIterator = null;

            @Override
            public boolean hasNext() {
                while (this.tabletIterator == null || !this.tabletIterator.hasNext()) {
                    if (!TsFileInsertionDataContainer.this.deviceMeasurementsMapIterator.hasNext()) {
                        TsFileInsertionDataContainer.this.close();
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)TsFileInsertionDataContainer.this.deviceMeasurementsMapIterator.next();
                    try {
                        this.tabletIterator = new TsFileInsertionDataTabletIterator(TsFileInsertionDataContainer.this.tsFileReader, TsFileInsertionDataContainer.this.measurementDataTypeMap, ((PlainDeviceID)entry.getKey()).toStringID(), (List)entry.getValue(), TsFileInsertionDataContainer.this.timeFilterExpression);
                    }
                    catch (IOException e) {
                        TsFileInsertionDataContainer.this.close();
                        throw new PipeException("failed to create TsFileInsertionDataTabletIterator", (Throwable)e);
                    }
                }
                return true;
            }

            @Override
            public TabletInsertionEvent next() {
                PipeRawTabletInsertionEvent next;
                if (!this.hasNext()) {
                    TsFileInsertionDataContainer.this.close();
                    throw new NoSuchElementException();
                }
                Tablet tablet = this.tabletIterator.next();
                boolean isAligned = TsFileInsertionDataContainer.this.deviceIsAlignedMap.getOrDefault(new PlainDeviceID(tablet.deviceId), false);
                if (!this.hasNext()) {
                    next = new PipeRawTabletInsertionEvent(tablet, isAligned, TsFileInsertionDataContainer.this.sourceEvent != null ? TsFileInsertionDataContainer.this.sourceEvent.getPipeName() : null, TsFileInsertionDataContainer.this.pipeTaskMeta, TsFileInsertionDataContainer.this.sourceEvent, true);
                    TsFileInsertionDataContainer.this.close();
                } else {
                    next = new PipeRawTabletInsertionEvent(tablet, isAligned, TsFileInsertionDataContainer.this.sourceEvent != null ? TsFileInsertionDataContainer.this.sourceEvent.getPipeName() : null, TsFileInsertionDataContainer.this.pipeTaskMeta, TsFileInsertionDataContainer.this.sourceEvent, false);
                }
                return next;
            }
        };
    }

    public boolean shouldParsePattern() {
        return this.shouldParsePattern;
    }

    @Override
    public void close() {
        try {
            if (this.tsFileReader != null) {
                this.tsFileReader.close();
            }
        }
        catch (IOException e) {
            LOGGER.warn("Failed to close TsFileReader", (Throwable)e);
        }
        try {
            if (this.tsFileSequenceReader != null) {
                this.tsFileSequenceReader.close();
            }
        }
        catch (IOException e) {
            LOGGER.warn("Failed to close TsFileSequenceReader", (Throwable)e);
        }
        if (this.allocatedMemoryBlock != null) {
            this.allocatedMemoryBlock.close();
        }
    }
}

