/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.protocol.websocket;

import java.util.Arrays;
import java.util.Optional;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.pipe.connector.protocol.websocket.WebSocketConnectorServer;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeInsertNodeTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeRawTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tsfile.PipeTsFileInsertionEvent;
import org.apache.iotdb.pipe.api.PipeConnector;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeConnectorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.event.dml.insertion.TsFileInsertionEvent;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketConnector
implements PipeConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSocketConnector.class);
    private Integer port;
    private WebSocketConnectorServer server;
    private String pipeName;

    public void validate(PipeParameterValidator validator) throws Exception {
        PipeParameters parameters = validator.getParameters();
        this.port = parameters.getIntOrDefault(Arrays.asList("connector.websocket.port", "sink.websocket.port"), 8080);
        this.server = WebSocketConnectorServer.getOrCreateInstance(this.port);
        if (this.server.getPort() != this.port.intValue()) {
            throw new PipeException(String.format("The websocket server has already been created with port = %d. Please set the option cdc.port = %d.", this.server.getPort(), this.server.getPort()));
        }
    }

    public void customize(PipeParameters parameters, PipeConnectorRuntimeConfiguration configuration) {
        this.pipeName = configuration.getRuntimeEnvironment().getPipeName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handshake() {
        this.server = WebSocketConnectorServer.getOrCreateInstance(this.port);
        this.server.register(this);
        if (this.server.isStarted()) return;
        Class<WebSocketConnectorServer> clazz = WebSocketConnectorServer.class;
        synchronized (WebSocketConnectorServer.class) {
            if (this.server.isStarted()) return;
            this.server.start();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void heartbeat() throws Exception {
    }

    public void transfer(TabletInsertionEvent tabletInsertionEvent) {
        if (!(tabletInsertionEvent instanceof PipeInsertNodeTabletInsertionEvent) && !(tabletInsertionEvent instanceof PipeRawTabletInsertionEvent)) {
            LOGGER.warn("WebsocketConnector only support PipeInsertNodeTabletInsertionEvent and PipeRawTabletInsertionEvent. Current event: {}.", (Object)tabletInsertionEvent);
            return;
        }
        if (tabletInsertionEvent instanceof PipeInsertNodeTabletInsertionEvent) {
            PipeInsertNodeTabletInsertionEvent event = (PipeInsertNodeTabletInsertionEvent)tabletInsertionEvent;
            for (PipeRawTabletInsertionEvent rawTabletInsertionEvent : event.toRawTabletInsertionEvents()) {
                event.skipReportOnCommit();
                this.transfer(rawTabletInsertionEvent);
            }
            return;
        }
        ((EnrichedEvent)tabletInsertionEvent).increaseReferenceCount(WebSocketConnector.class.getName());
        this.server.addEvent((Event)tabletInsertionEvent, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transfer(TsFileInsertionEvent tsFileInsertionEvent) throws Exception {
        if (!(tsFileInsertionEvent instanceof PipeTsFileInsertionEvent)) {
            LOGGER.warn("WebsocketConnector only support PipeTsFileInsertionEvent. Current event: {}.", (Object)tsFileInsertionEvent);
            return;
        }
        try {
            for (TabletInsertionEvent event : tsFileInsertionEvent.toTabletInsertionEvents()) {
                ((PipeTsFileInsertionEvent)tsFileInsertionEvent).skipReportOnCommit();
                this.transfer(event);
            }
        }
        finally {
            tsFileInsertionEvent.close();
        }
    }

    public void transfer(Event event) throws Exception {
    }

    public void close() throws Exception {
        if (this.server != null) {
            this.server.unregister(this);
        }
    }

    public void commit(EnrichedEvent enrichedEvent) {
        Optional.ofNullable(enrichedEvent).ifPresent(event -> event.decreaseReferenceCount(WebSocketConnector.class.getName(), true));
    }

    public String getPipeName() {
        return this.pipeName;
    }
}

