/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.protocol.thrift.async.handler;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.client.async.AsyncPipeDataTransferServiceClient;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.builder.IoTDBThriftAsyncPipeTransferBatchReqBuilder;
import org.apache.iotdb.db.pipe.connector.protocol.thrift.async.IoTDBDataRegionAsyncConnector;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferResp;
import org.apache.thrift.TException;
import org.apache.thrift.async.AsyncMethodCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeTransferTabletBatchEventHandler
implements AsyncMethodCallback<TPipeTransferResp> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeTransferTabletBatchEventHandler.class);
    private final List<Long> requestCommitIds;
    private final List<Event> events;
    private final TPipeTransferReq req;
    private final IoTDBDataRegionAsyncConnector connector;

    public PipeTransferTabletBatchEventHandler(IoTDBThriftAsyncPipeTransferBatchReqBuilder batchBuilder, IoTDBDataRegionAsyncConnector connector) throws IOException {
        this.requestCommitIds = batchBuilder.deepCopyRequestCommitIds();
        this.events = batchBuilder.deepCopyEvents();
        this.req = batchBuilder.toTPipeTransferReq();
        this.connector = connector;
    }

    public void transfer(AsyncPipeDataTransferServiceClient client) throws TException {
        client.pipeTransfer(this.req, (AsyncMethodCallback)this);
    }

    public void onComplete(TPipeTransferResp response) {
        if (response == null) {
            this.onError((Exception)((Object)new PipeException("TPipeTransferResp is null")));
            return;
        }
        try {
            TSStatus status = response.getStatus();
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode() && status.getCode() != TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()) {
                this.connector.statusHandler().handle(status, response.getStatus().getMessage(), this.events.toString());
            }
            for (Event event : this.events) {
                if (!(event instanceof EnrichedEvent)) continue;
                ((EnrichedEvent)event).decreaseReferenceCount(PipeTransferTabletBatchEventHandler.class.getName(), true);
            }
        }
        catch (Exception e) {
            this.onError(e);
        }
    }

    public void onError(Exception exception) {
        LOGGER.warn("Failed to transfer TabletInsertionEvent batch {} (request commit ids={}).", new Object[]{this.events.stream().map(event -> event instanceof EnrichedEvent ? ((EnrichedEvent)event).coreReportMessage() : event.toString()).collect(Collectors.toList()), this.requestCommitIds, exception});
        this.connector.addFailureEventsToRetryQueue(this.events);
    }
}

