/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.agent.runtime;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.commons.consensus.SchemaRegionId;
import org.apache.iotdb.db.pipe.extractor.schemaregion.SchemaRegionListeningQueue;

public class PipeSchemaRegionListenerManager {
    private final Map<SchemaRegionId, PipeSchemaRegionListener> id2StatusMap = new ConcurrentHashMap<SchemaRegionId, PipeSchemaRegionListener>();

    public synchronized Set<SchemaRegionId> regionIds() {
        return this.id2StatusMap.keySet();
    }

    public synchronized SchemaRegionListeningQueue listener(SchemaRegionId schemaRegionId) {
        return this.id2StatusMap.computeIfAbsent(schemaRegionId, k -> new PipeSchemaRegionListener()).listeningQueue;
    }

    public synchronized int increaseAndGetReferenceCount(SchemaRegionId schemaRegionId) {
        return this.id2StatusMap.computeIfAbsent(schemaRegionId, k -> new PipeSchemaRegionListener()).listeningQueueReferenceCount.incrementAndGet();
    }

    public synchronized int decreaseAndGetReferenceCount(SchemaRegionId schemaRegionId) {
        return this.id2StatusMap.computeIfAbsent(schemaRegionId, k -> new PipeSchemaRegionListener()).listeningQueueReferenceCount.updateAndGet(v -> v > 0 ? v - 1 : 0);
    }

    public synchronized void notifyLeaderReady(SchemaRegionId schemaRegionId) {
        this.id2StatusMap.computeIfAbsent(schemaRegionId, k -> new PipeSchemaRegionListener()).notifyLeaderReady();
    }

    public synchronized void notifyLeaderUnavailable(SchemaRegionId schemaRegionId) {
        this.id2StatusMap.computeIfAbsent(schemaRegionId, k -> new PipeSchemaRegionListener()).notifyLeaderUnavailable();
    }

    public synchronized boolean isLeaderReady(SchemaRegionId schemaRegionId) {
        return this.id2StatusMap.computeIfAbsent(schemaRegionId, k -> new PipeSchemaRegionListener()).isLeaderReady();
    }

    private static class PipeSchemaRegionListener {
        private final SchemaRegionListeningQueue listeningQueue = new SchemaRegionListeningQueue();
        private final AtomicInteger listeningQueueReferenceCount = new AtomicInteger(0);
        private final AtomicBoolean isLeaderReady = new AtomicBoolean(false);

        private PipeSchemaRegionListener() {
        }

        private boolean isLeaderReady() {
            return this.isLeaderReady.get();
        }

        private void notifyLeaderReady() {
            this.isLeaderReady.set(true);
        }

        private void notifyLeaderUnavailable() {
            this.isLeaderReady.set(false);
        }
    }
}

