/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.subscription.subscription;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.pipe.task.meta.PipeStaticMeta;
import org.apache.iotdb.commons.subscription.meta.consumer.ConsumerGroupMeta;
import org.apache.iotdb.commons.subscription.meta.topic.TopicMeta;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.task.DropPipePlanV2;
import org.apache.iotdb.confignode.consensus.request.write.pipe.task.OperateMultiplePipesPlanV2;
import org.apache.iotdb.confignode.consensus.request.write.subscription.topic.AlterMultipleTopicsPlan;
import org.apache.iotdb.confignode.consensus.request.write.subscription.topic.AlterTopicPlan;
import org.apache.iotdb.confignode.persistence.subscription.SubscriptionInfo;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.impl.pipe.AbstractOperatePipeProcedureV2;
import org.apache.iotdb.confignode.procedure.impl.pipe.task.DropPipeProcedureV2;
import org.apache.iotdb.confignode.procedure.impl.subscription.SubscriptionOperation;
import org.apache.iotdb.confignode.procedure.impl.subscription.consumer.AlterConsumerGroupProcedure;
import org.apache.iotdb.confignode.procedure.impl.subscription.subscription.AbstractOperateSubscriptionAndPipeProcedure;
import org.apache.iotdb.confignode.procedure.impl.subscription.topic.AlterTopicProcedure;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.apache.iotdb.confignode.rpc.thrift.TUnsubscribeReq;
import org.apache.iotdb.consensus.exception.ConsensusException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.rpc.subscription.exception.SubscriptionException;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropSubscriptionProcedure
extends AbstractOperateSubscriptionAndPipeProcedure {
    private static final Logger LOGGER = LoggerFactory.getLogger(DropSubscriptionProcedure.class);
    private TUnsubscribeReq unsubscribeReq;
    private AlterConsumerGroupProcedure alterConsumerGroupProcedure;
    private List<AlterTopicProcedure> alterTopicProcedures = new ArrayList<AlterTopicProcedure>();
    private List<DropPipeProcedureV2> dropPipeProcedures = new ArrayList<DropPipeProcedureV2>();
    private int alterTopicProcedureFailIndexOnCN = -1;
    private int dropPipeProcedureFailIndexOnCN = -1;

    public DropSubscriptionProcedure() {
    }

    public DropSubscriptionProcedure(TUnsubscribeReq unsubscribeReq) {
        this.unsubscribeReq = unsubscribeReq;
    }

    @Override
    protected SubscriptionOperation getOperation() {
        return SubscriptionOperation.DROP_SUBSCRIPTION;
    }

    @Override
    protected void executeFromValidate(ConfigNodeProcedureEnv env) throws SubscriptionException {
        LOGGER.info("DropSubscriptionProcedure: executeFromValidate");
        ((SubscriptionInfo)this.subscriptionInfo.get()).validateBeforeUnsubscribe(this.unsubscribeReq);
        ConsumerGroupMeta updatedConsumerGroupMeta = ((SubscriptionInfo)this.subscriptionInfo.get()).deepCopyConsumerGroupMeta(this.unsubscribeReq.getConsumerGroupId());
        Set topicsUnsubByGroup = updatedConsumerGroupMeta.removeSubscription(this.unsubscribeReq.getConsumerId(), this.unsubscribeReq.getTopicNames());
        this.alterConsumerGroupProcedure = new AlterConsumerGroupProcedure(updatedConsumerGroupMeta, this.subscriptionInfo);
        for (String topic : this.unsubscribeReq.getTopicNames()) {
            if (!topicsUnsubByGroup.contains(topic)) continue;
            TopicMeta updatedTopicMeta = ((SubscriptionInfo)this.subscriptionInfo.get()).deepCopyTopicMeta(topic);
            updatedTopicMeta.removeSubscribedConsumerGroup(this.unsubscribeReq.getConsumerGroupId());
            this.alterTopicProcedures.add(new AlterTopicProcedure(updatedTopicMeta, this.subscriptionInfo));
            this.dropPipeProcedures.add(new DropPipeProcedureV2(PipeStaticMeta.generateSubscriptionPipeName((String)topic, (String)this.unsubscribeReq.getConsumerGroupId()), this.pipeTaskInfo));
        }
        this.alterConsumerGroupProcedure.executeFromValidate(env);
        for (AlterTopicProcedure alterTopicProcedure : this.alterTopicProcedures) {
            alterTopicProcedure.executeFromValidate(env);
        }
        for (DropPipeProcedureV2 dropPipeProcedure : this.dropPipeProcedures) {
            dropPipeProcedure.executeFromValidateTask(env);
            dropPipeProcedure.executeFromCalculateInfoForTask(env);
        }
    }

    @Override
    protected void executeFromOperateOnConfigNodes(ConfigNodeProcedureEnv env) throws SubscriptionException {
        TSStatus response;
        LOGGER.info("DropSubscriptionProcedure: executeFromOperateOnConfigNodes");
        this.alterConsumerGroupProcedure.executeFromOperateOnConfigNodes(env);
        List<AlterTopicPlan> alterTopicPlans = this.alterTopicProcedures.stream().map(AlterTopicProcedure::getUpdatedTopicMeta).map(AlterTopicPlan::new).collect(Collectors.toList());
        try {
            response = env.getConfigManager().getConsensusManager().write(new AlterMultipleTopicsPlan(alterTopicPlans));
        }
        catch (ConsensusException e) {
            LOGGER.warn("Failed in the write API executing the consensus layer due to: ", (Throwable)e);
            response = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            response.setMessage(e.getMessage());
        }
        if (response.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode() && response.getSubStatusSize() > 0) {
            this.alterTopicProcedureFailIndexOnCN = response.getSubStatusSize() - 1;
        }
        List<ConfigPhysicalPlan> dropPipePlans = this.dropPipeProcedures.stream().map(proc -> new DropPipePlanV2(proc.getPipeName())).collect(Collectors.toList());
        try {
            response = env.getConfigManager().getConsensusManager().write(new OperateMultiplePipesPlanV2(dropPipePlans));
        }
        catch (ConsensusException e) {
            LOGGER.warn("Failed in the write API executing the consensus layer due to: ", (Throwable)e);
            response = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            response.setMessage(e.getMessage());
        }
        if (response.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode() && response.getSubStatusSize() > 0) {
            this.dropPipeProcedureFailIndexOnCN = response.getSubStatusSize() - 1;
        }
    }

    @Override
    protected void executeFromOperateOnDataNodes(ConfigNodeProcedureEnv env) throws SubscriptionException, IOException {
        List<String> pipeNames;
        String exceptionMessage;
        LOGGER.info("DropSubscriptionProcedure: executeFromOperateOnDataNodes");
        this.alterConsumerGroupProcedure.executeFromOperateOnDataNodes(env);
        ArrayList<ByteBuffer> topicMetaBinaryList = new ArrayList<ByteBuffer>();
        for (AlterTopicProcedure alterTopicProcedure : this.alterTopicProcedures) {
            topicMetaBinaryList.add(alterTopicProcedure.getUpdatedTopicMeta().serialize());
        }
        if (DropSubscriptionProcedure.pushTopicMetaHasException(env.pushMultiTopicMetaToDataNodes(topicMetaBinaryList))) {
            LOGGER.warn("Failed to alter topics when creating subscription, metadata will be synchronized later.");
        }
        if (!(exceptionMessage = AbstractOperatePipeProcedureV2.parsePushPipeMetaExceptionForPipe(null, this.dropMultiPipeOnDataNodes(pipeNames = this.dropPipeProcedures.stream().map(DropPipeProcedureV2::getPipeName).collect(Collectors.toList()), env))).isEmpty()) {
            LOGGER.warn("Failed to drop pipes {} when dropping subscription, details: {}, metadata will be synchronized later.", pipeNames, (Object)exceptionMessage);
        }
    }

    @Override
    protected void rollbackFromValidate(ConfigNodeProcedureEnv env) {
        LOGGER.info("DropSubscriptionProcedure: rollbackFromLock");
    }

    @Override
    protected void rollbackFromOperateOnConfigNodes(ConfigNodeProcedureEnv env) {
        TSStatus response;
        LOGGER.info("DropSubscriptionProcedure: rollbackFromOperateOnConfigNodes");
        this.alterConsumerGroupProcedure.rollbackFromOperateOnConfigNodes(env);
        ArrayList<AlterTopicPlan> alterTopicRollbackPlans = new ArrayList<AlterTopicPlan>();
        for (int i = 0; i <= Math.min(this.alterTopicProcedureFailIndexOnCN, this.alterTopicProcedures.size()); ++i) {
            alterTopicRollbackPlans.add(new AlterTopicPlan(this.alterTopicProcedures.get(i).getExistedTopicMeta()));
        }
        try {
            response = env.getConfigManager().getConsensusManager().write(new AlterMultipleTopicsPlan(alterTopicRollbackPlans));
        }
        catch (ConsensusException e) {
            LOGGER.warn("Failed in the write API executing the consensus layer due to: ", (Throwable)e);
            response = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            response.setMessage(e.getMessage());
        }
        if (response.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new SubscriptionException(response.getMessage());
        }
    }

    @Override
    protected void rollbackFromOperateOnDataNodes(ConfigNodeProcedureEnv env) throws IOException {
        String exceptionMessage;
        LOGGER.info("DropSubscriptionProcedure: rollbackFromOperateOnDataNodes");
        this.alterConsumerGroupProcedure.rollbackFromOperateOnDataNodes(env);
        if (DropSubscriptionProcedure.pushTopicMetaHasException(this.pushTopicMetaToDataNodes(env))) {
            LOGGER.warn("Failed to rollback alter topics when dropping subscription, metadata will be synchronized later.");
        }
        if (!(exceptionMessage = AbstractOperatePipeProcedureV2.parsePushPipeMetaExceptionForPipe(null, AbstractOperatePipeProcedureV2.pushPipeMetaToDataNodes(env, this.pipeTaskInfo))).isEmpty()) {
            LOGGER.warn("Failed to rollback create pipes when dropping subscription, details: {}, metadata will be synchronized later.", (Object)exceptionMessage);
        }
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeShort(ProcedureType.DROP_SUBSCRIPTION_PROCEDURE.getTypeCode());
        super.serialize(stream);
        ReadWriteIOUtils.write((String)this.unsubscribeReq.getConsumerId(), (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.unsubscribeReq.getConsumerGroupId(), (OutputStream)stream);
        int size = this.unsubscribeReq.getTopicNamesSize();
        ReadWriteIOUtils.write((int)size, (OutputStream)stream);
        if (size != 0) {
            for (String string : this.unsubscribeReq.getTopicNames()) {
                ReadWriteIOUtils.write((String)string, (OutputStream)stream);
            }
        }
        if (this.alterConsumerGroupProcedure != null) {
            ReadWriteIOUtils.write((Boolean)true, (OutputStream)stream);
            this.alterConsumerGroupProcedure.serialize(stream);
        } else {
            ReadWriteIOUtils.write((Boolean)false, (OutputStream)stream);
        }
        if (this.alterTopicProcedures != null) {
            ReadWriteIOUtils.write((Boolean)true, (OutputStream)stream);
            ReadWriteIOUtils.write((int)this.alterTopicProcedures.size(), (OutputStream)stream);
            for (AlterTopicProcedure alterTopicProcedure : this.alterTopicProcedures) {
                alterTopicProcedure.serialize(stream);
            }
        } else {
            ReadWriteIOUtils.write((Boolean)false, (OutputStream)stream);
        }
        if (this.dropPipeProcedures != null) {
            ReadWriteIOUtils.write((Boolean)true, (OutputStream)stream);
            ReadWriteIOUtils.write((int)this.dropPipeProcedures.size(), (OutputStream)stream);
            for (AbstractOperatePipeProcedureV2 abstractOperatePipeProcedureV2 : this.dropPipeProcedures) {
                abstractOperatePipeProcedureV2.serialize(stream);
            }
        } else {
            ReadWriteIOUtils.write((Boolean)false, (OutputStream)stream);
        }
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        int i;
        super.deserialize(byteBuffer);
        this.unsubscribeReq = new TUnsubscribeReq().setConsumerId(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer)).setConsumerGroupId(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer)).setTopicNames(new HashSet());
        int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        for (i = 0; i < size; ++i) {
            this.unsubscribeReq.getTopicNames().add(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer));
        }
        if (ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer)) {
            ReadWriteIOUtils.readShort((ByteBuffer)byteBuffer);
            this.alterConsumerGroupProcedure = new AlterConsumerGroupProcedure();
            this.alterConsumerGroupProcedure.deserialize(byteBuffer);
        }
        if (ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer)) {
            size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
            for (i = 0; i < size; ++i) {
                ReadWriteIOUtils.readShort((ByteBuffer)byteBuffer);
                AlterTopicProcedure topicProcedure = new AlterTopicProcedure();
                topicProcedure.deserialize(byteBuffer);
                this.alterTopicProcedures.add(topicProcedure);
            }
        }
        if (ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer)) {
            size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
            for (i = 0; i < size; ++i) {
                short typeCode = ReadWriteIOUtils.readShort((ByteBuffer)byteBuffer);
                if (typeCode != ProcedureType.DROP_PIPE_PROCEDURE_V2.getTypeCode()) continue;
                DropPipeProcedureV2 dropPipeProcedureV2 = new DropPipeProcedureV2();
                dropPipeProcedureV2.deserialize(byteBuffer);
                this.dropPipeProcedures.add(dropPipeProcedureV2);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DropSubscriptionProcedure that = (DropSubscriptionProcedure)o;
        return Objects.equals(this.getProcId(), that.getProcId()) && Objects.equals(this.getCurrentState(), that.getCurrentState()) && this.getCycles() == that.getCycles() && Objects.equals(this.unsubscribeReq, that.unsubscribeReq) && Objects.equals(this.alterConsumerGroupProcedure, that.alterConsumerGroupProcedure) && Objects.equals(this.alterTopicProcedures, that.alterTopicProcedures) && Objects.equals(this.dropPipeProcedures, that.dropPipeProcedures);
    }

    public int hashCode() {
        return Objects.hash(this.getProcId(), this.getCurrentState(), this.getCycles(), this.unsubscribeReq, this.alterConsumerGroupProcedure, this.alterTopicProcedures, this.dropPipeProcedures);
    }

    public void setAlterConsumerGroupProcedure(AlterConsumerGroupProcedure alterConsumerGroupProcedure) {
        this.alterConsumerGroupProcedure = alterConsumerGroupProcedure;
    }

    public AlterConsumerGroupProcedure getAlterConsumerGroupProcedure() {
        return this.alterConsumerGroupProcedure;
    }

    public void setAlterTopicProcedures(List<AlterTopicProcedure> alterTopicProcedures) {
        this.alterTopicProcedures = alterTopicProcedures;
    }

    public List<AlterTopicProcedure> getAlterTopicProcedures() {
        return this.alterTopicProcedures;
    }

    public void setDropPipeProcedures(List<DropPipeProcedureV2> dropPipeProcedures) {
        this.dropPipeProcedures = dropPipeProcedures;
    }

    public List<DropPipeProcedureV2> getDropPipeProcedures() {
        return this.dropPipeProcedures;
    }
}

