/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.pipe.event;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.pipe.event.PipeWritePlanEvent;
import org.apache.iotdb.commons.pipe.pattern.PipePattern;
import org.apache.iotdb.commons.pipe.task.meta.PipeTaskMeta;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.manager.pipe.event.PipeConfigSerializableEventType;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class PipeConfigRegionWritePlanEvent
extends PipeWritePlanEvent {
    private ConfigPhysicalPlan configPhysicalPlan;

    public PipeConfigRegionWritePlanEvent() {
        this(null, false);
    }

    public PipeConfigRegionWritePlanEvent(ConfigPhysicalPlan configPhysicalPlan, boolean isGeneratedByPipe) {
        this(configPhysicalPlan, null, null, null, isGeneratedByPipe);
    }

    public PipeConfigRegionWritePlanEvent(ConfigPhysicalPlan configPhysicalPlan, String pipeName, PipeTaskMeta pipeTaskMeta, PipePattern pattern, boolean isGeneratedByPipe) {
        super(pipeName, pipeTaskMeta, pattern, isGeneratedByPipe);
        this.configPhysicalPlan = configPhysicalPlan;
    }

    public ConfigPhysicalPlan getConfigPhysicalPlan() {
        return this.configPhysicalPlan;
    }

    public EnrichedEvent shallowCopySelfAndBindPipeTaskMetaForProgressReport(String pipeName, PipeTaskMeta pipeTaskMeta, PipePattern pattern, long startTime, long endTime) {
        return new PipeConfigRegionWritePlanEvent(this.configPhysicalPlan, pipeName, pipeTaskMeta, pattern, false);
    }

    public ByteBuffer serializeToByteBuffer() {
        ByteBuffer planBuffer = this.configPhysicalPlan.serializeToByteBuffer();
        ByteBuffer result = ByteBuffer.allocate(2 + planBuffer.limit());
        ReadWriteIOUtils.write((byte)PipeConfigSerializableEventType.CONFIG_WRITE_PLAN.getType(), (ByteBuffer)result);
        ReadWriteIOUtils.write((Boolean)this.isGeneratedByPipe, (ByteBuffer)result);
        result.put(planBuffer);
        return result;
    }

    public void deserializeFromByteBuffer(ByteBuffer buffer) throws IOException {
        this.isGeneratedByPipe = ReadWriteIOUtils.readBool((ByteBuffer)buffer);
        this.configPhysicalPlan = ConfigPhysicalPlan.Factory.create(buffer);
    }

    public String toString() {
        return String.format("PipeConfigRegionWritePlanEvent{configPhysicalPlan=%s}", this.configPhysicalPlan) + " - " + super.toString();
    }

    public String coreReportMessage() {
        return String.format("PipeConfigRegionWritePlanEvent{configPhysicalPlan=%s}", this.configPhysicalPlan) + " - " + super.coreReportMessage();
    }
}

