/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write.pipe.payload;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class PipeDeleteTimeSeriesPlan
extends ConfigPhysicalPlan {
    private ByteBuffer patternTreeBytes;

    public PipeDeleteTimeSeriesPlan() {
        super(ConfigPhysicalPlanType.PipeDeleteTimeSeries);
    }

    public PipeDeleteTimeSeriesPlan(ByteBuffer patternTreeBytes) {
        super(ConfigPhysicalPlanType.PipeDeleteTimeSeries);
        patternTreeBytes.flip();
        this.patternTreeBytes = patternTreeBytes;
    }

    public ByteBuffer getPatternTreeBytes() {
        return this.patternTreeBytes;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeShort(this.getType().getPlanType());
        ReadWriteIOUtils.write((ByteBuffer)this.patternTreeBytes, (OutputStream)stream);
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        this.patternTreeBytes = ByteBuffer.wrap(ReadWriteIOUtils.readBinary((ByteBuffer)buffer).getValues());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PipeDeleteTimeSeriesPlan that = (PipeDeleteTimeSeriesPlan)obj;
        return Arrays.equals(this.patternTreeBytes.array(), that.patternTreeBytes.array());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.patternTreeBytes);
    }

    public String toString() {
        return "PipeDeleteTimeSeriesPlan{patternTreeBytes='" + Arrays.toString(this.patternTreeBytes.array()) + "'}";
    }
}

