/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write.partition;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.commons.utils.ThriftCommonsSerDeUtils;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;

public class RemoveRegionLocationPlan
extends ConfigPhysicalPlan {
    TConsensusGroupId regionId;
    TDataNodeLocation deprecatedLocation;

    public RemoveRegionLocationPlan() {
        super(ConfigPhysicalPlanType.RemoveRegionLocation);
    }

    public RemoveRegionLocationPlan(TConsensusGroupId regionId, TDataNodeLocation deprecatedLocation) {
        this();
        this.regionId = regionId;
        this.deprecatedLocation = deprecatedLocation;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeShort(this.getType().getPlanType());
        ThriftCommonsSerDeUtils.serializeTConsensusGroupId((TConsensusGroupId)this.regionId, (DataOutputStream)stream);
        ThriftCommonsSerDeUtils.serializeTDataNodeLocation((TDataNodeLocation)this.deprecatedLocation, (DataOutputStream)stream);
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        this.regionId = ThriftCommonsSerDeUtils.deserializeTConsensusGroupId((ByteBuffer)buffer);
        this.deprecatedLocation = ThriftCommonsSerDeUtils.deserializeTDataNodeLocation((ByteBuffer)buffer);
    }

    @Override
    public ConfigPhysicalPlanType getType() {
        return super.getType();
    }

    public TConsensusGroupId getRegionId() {
        return this.regionId;
    }

    public TDataNodeLocation getDeprecatedLocation() {
        return this.deprecatedLocation;
    }
}

