/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.filter.operator;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.exception.NotImplementedException;
import org.apache.iotdb.tsfile.file.metadata.IMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.filter.basic.DisableStatisticsValueFilter;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.basic.OperatorType;
import org.apache.iotdb.tsfile.read.filter.basic.ValueFilter;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public final class ValueFilterOperators {
    private static final String CONSTANT_CANNOT_BE_NULL_MSG = "constant cannot be null";
    public static final String CANNOT_PUSH_DOWN_MSG = " operator can not be pushed down.";
    private static final String OPERATOR_TO_STRING_FORMAT = "measurements[%s] %s %s";

    private ValueFilterOperators() {
    }

    private static boolean statisticsNotAvailable(Statistics<?> statistics) {
        return statistics.getType() == TSDataType.TEXT || statistics.getType() == TSDataType.BOOLEAN || statistics.isEmpty();
    }

    private static class MatcherInput
    implements CharSequence {
        private final CharSequence value;
        private final AccessCount access;

        public MatcherInput(CharSequence value, AccessCount access) {
            this.value = value;
            this.access = access;
        }

        @Override
        public char charAt(int index) {
            this.access.check();
            return this.value.charAt(index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return new MatcherInput(this.value.subSequence(start, end), this.access);
        }

        @Override
        public int length() {
            return this.value.length();
        }

        @Override
        public String toString() {
            return this.value.toString();
        }
    }

    private static class AccessCount {
        private int count;
        private final int accessThreshold = TSFileDescriptor.getInstance().getConfig().getPatternMatchingThreshold();

        private AccessCount() {
        }

        public void check() throws IllegalStateException {
            if (this.count++ > this.accessThreshold) {
                throw new IllegalStateException("Pattern access threshold exceeded");
            }
        }
    }

    public static final class ValueNotRegexp
    extends ValueColumnPatternMatchFilter {
        public ValueNotRegexp(int measurementIndex, Pattern pattern) {
            super(measurementIndex, pattern);
        }

        public ValueNotRegexp(ByteBuffer buffer) {
            super(buffer);
        }

        @Override
        public boolean valueSatisfy(Object value) {
            return !this.pattern.matcher(new MatcherInput(value.toString(), new AccessCount())).find();
        }

        @Override
        public Filter reverse() {
            return new ValueRegexp(this.measurementIndex, this.pattern);
        }

        @Override
        public OperatorType getOperatorType() {
            return OperatorType.VALUE_NOT_REGEXP;
        }
    }

    public static final class ValueRegexp
    extends ValueColumnPatternMatchFilter {
        public ValueRegexp(int measurementIndex, Pattern pattern) {
            super(measurementIndex, pattern);
        }

        public ValueRegexp(ByteBuffer buffer) {
            super(buffer);
        }

        @Override
        public boolean valueSatisfy(Object value) {
            return this.pattern.matcher(new MatcherInput(value.toString(), new AccessCount())).find();
        }

        @Override
        public Filter reverse() {
            return new ValueNotRegexp(this.measurementIndex, this.pattern);
        }

        @Override
        public OperatorType getOperatorType() {
            return OperatorType.VALUE_REGEXP;
        }
    }

    static abstract class ValueColumnPatternMatchFilter
    extends DisableStatisticsValueFilter {
        protected final Pattern pattern;

        protected ValueColumnPatternMatchFilter(int measurementIndex, Pattern pattern) {
            super(measurementIndex);
            this.pattern = Objects.requireNonNull(pattern, "pattern cannot be null");
        }

        protected ValueColumnPatternMatchFilter(ByteBuffer buffer) {
            super(buffer);
            this.pattern = Pattern.compile(Objects.requireNonNull(ReadWriteIOUtils.readString(buffer), "pattern cannot be null"));
        }

        @Override
        public void serialize(DataOutputStream outputStream) throws IOException {
            super.serialize(outputStream);
            ReadWriteIOUtils.write(this.pattern.pattern(), (OutputStream)outputStream);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ValueColumnPatternMatchFilter that = (ValueColumnPatternMatchFilter)o;
            return this.pattern.pattern().equals(that.pattern.pattern());
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.pattern.pattern());
        }

        public String toString() {
            return String.format(ValueFilterOperators.OPERATOR_TO_STRING_FORMAT, this.measurementIndex, this.getOperatorType().getSymbol(), this.pattern);
        }
    }

    public static final class ValueNotIn<T>
    extends ValueColumnSetFilter<T> {
        public ValueNotIn(int measurementIndex, Set<T> candidates) {
            super(measurementIndex, candidates);
        }

        public ValueNotIn(ByteBuffer buffer) {
            super(buffer);
        }

        @Override
        public boolean valueSatisfy(Object value) {
            return !this.candidates.contains(value);
        }

        @Override
        public Filter reverse() {
            return new ValueIn(this.measurementIndex, this.candidates);
        }

        @Override
        public OperatorType getOperatorType() {
            return OperatorType.VALUE_NOT_IN;
        }
    }

    public static final class ValueIn<T>
    extends ValueColumnSetFilter<T> {
        public ValueIn(int measurementIndex, Set<T> candidates) {
            super(measurementIndex, candidates);
        }

        public ValueIn(ByteBuffer buffer) {
            super(buffer);
        }

        @Override
        public boolean valueSatisfy(Object value) {
            return this.candidates.contains(value);
        }

        @Override
        public Filter reverse() {
            return new ValueNotIn(this.measurementIndex, this.candidates);
        }

        @Override
        public OperatorType getOperatorType() {
            return OperatorType.VALUE_IN;
        }
    }

    static abstract class ValueColumnSetFilter<T>
    extends DisableStatisticsValueFilter {
        protected final Set<T> candidates;

        protected ValueColumnSetFilter(int measurementIndex, Set<T> candidates) {
            super(measurementIndex);
            this.candidates = Objects.requireNonNull(candidates, "candidates cannot be null");
        }

        protected ValueColumnSetFilter(ByteBuffer buffer) {
            super(buffer);
            this.candidates = ReadWriteIOUtils.readObjectSet(buffer);
        }

        @Override
        public void serialize(DataOutputStream outputStream) throws IOException {
            super.serialize(outputStream);
            ReadWriteIOUtils.writeObjectSet(this.candidates, outputStream);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ValueColumnSetFilter that = (ValueColumnSetFilter)o;
            return this.candidates.equals(that.candidates);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.candidates);
        }

        public String toString() {
            return String.format(ValueFilterOperators.OPERATOR_TO_STRING_FORMAT, this.measurementIndex, this.getOperatorType().getSymbol(), this.candidates);
        }
    }

    public static final class ValueIsNotNull
    extends ValueCompareNullFilter {
        public ValueIsNotNull(int measurementIndex) {
            super(measurementIndex);
        }

        public ValueIsNotNull(ByteBuffer buffer) {
            super(buffer);
        }

        @Override
        public boolean valueSatisfy(Object value) {
            return value != null;
        }

        @Override
        public boolean canSkip(IMetadata metadata) {
            Optional<Statistics<? extends Serializable>> statistics = metadata.getMeasurementStatistics(this.measurementIndex);
            if (!statistics.isPresent()) {
                return true;
            }
            return this.isAllNulls(statistics.get());
        }

        @Override
        public boolean canSkip(Statistics<? extends Serializable> statistics) {
            throw new NotImplementedException();
        }

        @Override
        public boolean allSatisfy(IMetadata metadata) {
            Optional<Statistics<? extends Serializable>> statistics = metadata.getMeasurementStatistics(this.measurementIndex);
            if (!statistics.isPresent()) {
                return false;
            }
            return !metadata.hasNullValue(this.measurementIndex);
        }

        @Override
        public boolean allSatisfy(Statistics<? extends Serializable> statistics) {
            throw new NotImplementedException();
        }

        @Override
        public Filter reverse() {
            return new ValueIsNull(this.measurementIndex);
        }

        @Override
        public OperatorType getOperatorType() {
            return OperatorType.VALUE_IS_NOT_NULL;
        }

        private boolean isAllNulls(Statistics<? extends Serializable> statistics) {
            return statistics.getCount() == 0L;
        }
    }

    public static final class ValueIsNull
    extends ValueCompareNullFilter {
        public ValueIsNull(int measurementIndex) {
            super(measurementIndex);
        }

        public ValueIsNull(ByteBuffer buffer) {
            super(buffer);
        }

        @Override
        public boolean satisfy(long time, Object value) {
            throw new IllegalArgumentException(this.getOperatorType().getSymbol() + ValueFilterOperators.CANNOT_PUSH_DOWN_MSG);
        }

        @Override
        public boolean satisfyRow(long time, Object[] values) {
            throw new IllegalArgumentException(this.getOperatorType().getSymbol() + ValueFilterOperators.CANNOT_PUSH_DOWN_MSG);
        }

        @Override
        public boolean valueSatisfy(Object value) {
            throw new IllegalArgumentException(this.getOperatorType().getSymbol() + ValueFilterOperators.CANNOT_PUSH_DOWN_MSG);
        }

        @Override
        public boolean canSkip(IMetadata metadata) {
            throw new IllegalArgumentException(this.getOperatorType().getSymbol() + ValueFilterOperators.CANNOT_PUSH_DOWN_MSG);
        }

        @Override
        public boolean canSkip(Statistics<? extends Serializable> statistics) {
            throw new IllegalArgumentException(this.getOperatorType().getSymbol() + ValueFilterOperators.CANNOT_PUSH_DOWN_MSG);
        }

        @Override
        public boolean allSatisfy(Statistics<? extends Serializable> statistics) {
            throw new IllegalArgumentException(this.getOperatorType().getSymbol() + ValueFilterOperators.CANNOT_PUSH_DOWN_MSG);
        }

        @Override
        public boolean allSatisfy(IMetadata metadata) {
            throw new IllegalArgumentException(this.getOperatorType().getSymbol() + ValueFilterOperators.CANNOT_PUSH_DOWN_MSG);
        }

        @Override
        public Filter reverse() {
            return new ValueIsNotNull(this.measurementIndex);
        }

        @Override
        public OperatorType getOperatorType() {
            return OperatorType.VALUE_IS_NULL;
        }
    }

    static abstract class ValueCompareNullFilter
    extends ValueFilter {
        protected ValueCompareNullFilter(int measurementIndex) {
            super(measurementIndex);
        }

        protected ValueCompareNullFilter(ByteBuffer buffer) {
            super(buffer);
        }

        public String toString() {
            return String.format("measurements[%s] %s", this.measurementIndex, this.getOperatorType().getSymbol());
        }
    }

    public static final class ValueNotBetweenAnd<T extends Comparable<T>>
    extends ValueColumnRangeFilter<T> {
        public ValueNotBetweenAnd(int measurementIndex, T min, T max) {
            super(measurementIndex, min, max);
        }

        public ValueNotBetweenAnd(ByteBuffer buffer) {
            super(buffer);
        }

        @Override
        public boolean valueSatisfy(Object value) {
            return this.min.compareTo((Comparable)value) > 0 || this.max.compareTo((Comparable)value) < 0;
        }

        @Override
        public boolean canSkip(Statistics<? extends Serializable> statistics) {
            if (ValueFilterOperators.statisticsNotAvailable(statistics)) {
                return false;
            }
            return ((Comparable)((Object)statistics.getMinValue())).compareTo(this.min) >= 0 && ((Comparable)((Object)statistics.getMaxValue())).compareTo(this.max) <= 0;
        }

        @Override
        public boolean allSatisfy(Statistics<? extends Serializable> statistics) {
            if (ValueFilterOperators.statisticsNotAvailable(statistics)) {
                return false;
            }
            return ((Comparable)((Object)statistics.getMinValue())).compareTo(this.max) > 0 || ((Comparable)((Object)statistics.getMaxValue())).compareTo(this.min) < 0;
        }

        @Override
        public Filter reverse() {
            return new ValueBetweenAnd<Comparable>(this.measurementIndex, this.min, this.max);
        }

        @Override
        public OperatorType getOperatorType() {
            return OperatorType.VALUE_NOT_BETWEEN_AND;
        }
    }

    public static final class ValueBetweenAnd<T extends Comparable<T>>
    extends ValueColumnRangeFilter<T> {
        public ValueBetweenAnd(int measurementIndex, T min, T max) {
            super(measurementIndex, min, max);
        }

        public ValueBetweenAnd(ByteBuffer buffer) {
            super(buffer);
        }

        @Override
        public boolean valueSatisfy(Object value) {
            return this.min.compareTo((Comparable)value) <= 0 && this.max.compareTo((Comparable)value) >= 0;
        }

        @Override
        public boolean canSkip(Statistics<? extends Serializable> statistics) {
            if (ValueFilterOperators.statisticsNotAvailable(statistics)) {
                return false;
            }
            return ((Comparable)((Object)statistics.getMaxValue())).compareTo(this.min) < 0 || ((Comparable)((Object)statistics.getMinValue())).compareTo(this.max) > 0;
        }

        @Override
        public boolean allSatisfy(Statistics<? extends Serializable> statistics) {
            if (ValueFilterOperators.statisticsNotAvailable(statistics)) {
                return false;
            }
            return ((Comparable)((Object)statistics.getMinValue())).compareTo(this.min) >= 0 && ((Comparable)((Object)statistics.getMaxValue())).compareTo(this.max) <= 0;
        }

        @Override
        public Filter reverse() {
            return new ValueNotBetweenAnd<Comparable>(this.measurementIndex, this.min, this.max);
        }

        @Override
        public OperatorType getOperatorType() {
            return OperatorType.VALUE_BETWEEN_AND;
        }
    }

    static abstract class ValueColumnRangeFilter<T extends Comparable<T>>
    extends ValueFilter {
        protected final T min;
        protected final T max;

        protected ValueColumnRangeFilter(int measurementIndex, T min, T max) {
            super(measurementIndex);
            this.min = (Comparable)Objects.requireNonNull(min, "min cannot be null");
            this.max = (Comparable)Objects.requireNonNull(max, "max cannot be null");
        }

        protected ValueColumnRangeFilter(ByteBuffer buffer) {
            super(buffer);
            this.min = Objects.requireNonNull((Comparable)ReadWriteIOUtils.readObject(buffer), "min cannot be null");
            this.max = Objects.requireNonNull((Comparable)ReadWriteIOUtils.readObject(buffer), "max cannot be null");
        }

        @Override
        public void serialize(DataOutputStream outputStream) throws IOException {
            super.serialize(outputStream);
            ReadWriteIOUtils.writeObject(this.min, outputStream);
            ReadWriteIOUtils.writeObject(this.max, outputStream);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ValueColumnRangeFilter that = (ValueColumnRangeFilter)o;
            return this.min.equals(that.min) && this.max.equals(that.max);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.min, this.max);
        }

        public String toString() {
            return String.format("measurements[%s] %s %s AND %s", this.measurementIndex, this.getOperatorType().getSymbol(), this.min, this.max);
        }
    }

    public static final class ValueGtEq<T extends Comparable<T>>
    extends ValueColumnCompareFilter<T> {
        public ValueGtEq(int measurementIndex, T constant) {
            super(measurementIndex, constant);
        }

        public ValueGtEq(ByteBuffer buffer) {
            super(buffer);
        }

        @Override
        public boolean valueSatisfy(Object value) {
            return this.constant.compareTo((Comparable)value) <= 0;
        }

        @Override
        public boolean canSkip(Statistics<? extends Serializable> statistics) {
            if (ValueFilterOperators.statisticsNotAvailable(statistics)) {
                return false;
            }
            return this.constant.compareTo((Comparable)((Object)statistics.getMaxValue())) > 0;
        }

        @Override
        public boolean allSatisfy(Statistics<? extends Serializable> statistics) {
            if (ValueFilterOperators.statisticsNotAvailable(statistics)) {
                return false;
            }
            return this.constant.compareTo((Comparable)((Object)statistics.getMinValue())) <= 0;
        }

        @Override
        public Filter reverse() {
            return new ValueLt<Comparable>(this.measurementIndex, this.constant);
        }

        @Override
        public OperatorType getOperatorType() {
            return OperatorType.VALUE_GTEQ;
        }
    }

    public static final class ValueGt<T extends Comparable<T>>
    extends ValueColumnCompareFilter<T> {
        public ValueGt(int measurementIndex, T constant) {
            super(measurementIndex, constant);
        }

        public ValueGt(ByteBuffer buffer) {
            super(buffer);
        }

        @Override
        public boolean valueSatisfy(Object value) {
            return this.constant.compareTo((Comparable)value) < 0;
        }

        @Override
        public boolean canSkip(Statistics<? extends Serializable> statistics) {
            if (ValueFilterOperators.statisticsNotAvailable(statistics)) {
                return false;
            }
            return this.constant.compareTo((Comparable)((Object)statistics.getMaxValue())) >= 0;
        }

        @Override
        public boolean allSatisfy(Statistics<? extends Serializable> statistics) {
            if (ValueFilterOperators.statisticsNotAvailable(statistics)) {
                return false;
            }
            return this.constant.compareTo((Comparable)((Object)statistics.getMinValue())) < 0;
        }

        @Override
        public Filter reverse() {
            return new ValueLtEq<Comparable>(this.measurementIndex, this.constant);
        }

        @Override
        public OperatorType getOperatorType() {
            return OperatorType.VALUE_GT;
        }
    }

    public static final class ValueLtEq<T extends Comparable<T>>
    extends ValueColumnCompareFilter<T> {
        public ValueLtEq(int measurementIndex, T constant) {
            super(measurementIndex, constant);
        }

        public ValueLtEq(ByteBuffer buffer) {
            super(buffer);
        }

        @Override
        public boolean valueSatisfy(Object value) {
            return this.constant.compareTo((Comparable)value) >= 0;
        }

        @Override
        public boolean canSkip(Statistics<? extends Serializable> statistics) {
            if (ValueFilterOperators.statisticsNotAvailable(statistics)) {
                return false;
            }
            return this.constant.compareTo((Comparable)((Object)statistics.getMinValue())) < 0;
        }

        @Override
        public boolean allSatisfy(Statistics<? extends Serializable> statistics) {
            if (ValueFilterOperators.statisticsNotAvailable(statistics)) {
                return false;
            }
            return this.constant.compareTo((Comparable)((Object)statistics.getMaxValue())) >= 0;
        }

        @Override
        public Filter reverse() {
            return new ValueGt<Comparable>(this.measurementIndex, this.constant);
        }

        @Override
        public OperatorType getOperatorType() {
            return OperatorType.VALUE_LTEQ;
        }
    }

    public static final class ValueLt<T extends Comparable<T>>
    extends ValueColumnCompareFilter<T> {
        public ValueLt(int measurementIndex, T constant) {
            super(measurementIndex, constant);
        }

        public ValueLt(ByteBuffer buffer) {
            super(buffer);
        }

        @Override
        public boolean valueSatisfy(Object value) {
            return this.constant.compareTo((Comparable)value) > 0;
        }

        @Override
        public boolean canSkip(Statistics<? extends Serializable> statistics) {
            if (ValueFilterOperators.statisticsNotAvailable(statistics)) {
                return false;
            }
            return this.constant.compareTo((Comparable)((Object)statistics.getMinValue())) <= 0;
        }

        @Override
        public boolean allSatisfy(Statistics<? extends Serializable> statistics) {
            if (ValueFilterOperators.statisticsNotAvailable(statistics)) {
                return false;
            }
            return this.constant.compareTo((Comparable)((Object)statistics.getMaxValue())) > 0;
        }

        @Override
        public Filter reverse() {
            return new ValueGtEq<Comparable>(this.measurementIndex, this.constant);
        }

        @Override
        public OperatorType getOperatorType() {
            return OperatorType.VALUE_LT;
        }
    }

    public static final class ValueNotEq<T extends Comparable<T>>
    extends ValueColumnCompareFilter<T> {
        public ValueNotEq(int measurementIndex, T constant) {
            super(measurementIndex, constant);
        }

        public ValueNotEq(ByteBuffer buffer) {
            super(buffer);
        }

        @Override
        public boolean valueSatisfy(Object value) {
            return !this.constant.equals(value);
        }

        @Override
        public boolean canSkip(Statistics<? extends Serializable> statistics) {
            if (ValueFilterOperators.statisticsNotAvailable(statistics)) {
                return false;
            }
            return this.constant.compareTo((Comparable)((Object)statistics.getMinValue())) == 0 && this.constant.compareTo((Comparable)((Object)statistics.getMaxValue())) == 0;
        }

        @Override
        public boolean allSatisfy(Statistics<? extends Serializable> statistics) {
            if (ValueFilterOperators.statisticsNotAvailable(statistics)) {
                return false;
            }
            return this.constant.compareTo((Comparable)((Object)statistics.getMinValue())) < 0 || this.constant.compareTo((Comparable)((Object)statistics.getMaxValue())) > 0;
        }

        @Override
        public Filter reverse() {
            return new ValueEq<Comparable>(this.measurementIndex, this.constant);
        }

        @Override
        public OperatorType getOperatorType() {
            return OperatorType.VALUE_NEQ;
        }
    }

    public static final class ValueEq<T extends Comparable<T>>
    extends ValueColumnCompareFilter<T> {
        public ValueEq(int measurementIndex, T constant) {
            super(measurementIndex, constant);
        }

        public ValueEq(ByteBuffer buffer) {
            super(buffer);
        }

        @Override
        public boolean valueSatisfy(Object value) {
            return this.constant.equals(value);
        }

        @Override
        public boolean canSkip(Statistics<? extends Serializable> statistics) {
            if (ValueFilterOperators.statisticsNotAvailable(statistics)) {
                return false;
            }
            return this.constant.compareTo((Comparable)((Object)statistics.getMinValue())) < 0 || this.constant.compareTo((Comparable)((Object)statistics.getMaxValue())) > 0;
        }

        @Override
        public boolean allSatisfy(Statistics<? extends Serializable> statistics) {
            if (ValueFilterOperators.statisticsNotAvailable(statistics)) {
                return false;
            }
            return this.constant.compareTo((Comparable)((Object)statistics.getMinValue())) == 0 && this.constant.compareTo((Comparable)((Object)statistics.getMaxValue())) == 0;
        }

        @Override
        public Filter reverse() {
            return new ValueNotEq<Comparable>(this.measurementIndex, this.constant);
        }

        @Override
        public OperatorType getOperatorType() {
            return OperatorType.VALUE_EQ;
        }
    }

    static abstract class ValueColumnCompareFilter<T extends Comparable<T>>
    extends ValueFilter {
        protected final T constant;

        protected ValueColumnCompareFilter(int measurementIndex, T constant) {
            super(measurementIndex);
            this.constant = (Comparable)Objects.requireNonNull(constant, ValueFilterOperators.CONSTANT_CANNOT_BE_NULL_MSG);
        }

        protected ValueColumnCompareFilter(ByteBuffer buffer) {
            super(buffer);
            this.constant = Objects.requireNonNull((Comparable)ReadWriteIOUtils.readObject(buffer), ValueFilterOperators.CONSTANT_CANNOT_BE_NULL_MSG);
        }

        @Override
        public void serialize(DataOutputStream outputStream) throws IOException {
            super.serialize(outputStream);
            ReadWriteIOUtils.writeObject(this.constant, outputStream);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ValueColumnCompareFilter that = (ValueColumnCompareFilter)o;
            return Objects.equals(this.constant, that.constant);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.constant);
        }

        public String toString() {
            return String.format(ValueFilterOperators.OPERATOR_TO_STRING_FORMAT, this.measurementIndex, this.getOperatorType().getSymbol(), this.constant);
        }
    }
}

