/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.filter.factory;

import java.util.Set;
import java.util.regex.Pattern;
import org.apache.iotdb.tsfile.read.filter.operator.ValueFilterOperators;
import org.apache.iotdb.tsfile.utils.RegexUtils;

public class ValueFilterApi {
    private static final int DEFAULT_MEASUREMENT_INDEX = 0;

    private ValueFilterApi() {
    }

    public static <T extends Comparable<T>> ValueFilterOperators.ValueGt<T> gt(T value) {
        return new ValueFilterOperators.ValueGt<T>(0, value);
    }

    public static <T extends Comparable<T>> ValueFilterOperators.ValueGt<T> gt(int measurementIndex, T value) {
        return new ValueFilterOperators.ValueGt<T>(measurementIndex, value);
    }

    public static <T extends Comparable<T>> ValueFilterOperators.ValueGtEq<T> gtEq(T value) {
        return new ValueFilterOperators.ValueGtEq<T>(0, value);
    }

    public static <T extends Comparable<T>> ValueFilterOperators.ValueGtEq<T> gtEq(int measurementIndex, T value) {
        return new ValueFilterOperators.ValueGtEq<T>(measurementIndex, value);
    }

    public static <T extends Comparable<T>> ValueFilterOperators.ValueLt<T> lt(T value) {
        return new ValueFilterOperators.ValueLt<T>(0, value);
    }

    public static <T extends Comparable<T>> ValueFilterOperators.ValueLt<T> lt(int measurementIndex, T value) {
        return new ValueFilterOperators.ValueLt<T>(measurementIndex, value);
    }

    public static <T extends Comparable<T>> ValueFilterOperators.ValueLtEq<T> ltEq(T value) {
        return new ValueFilterOperators.ValueLtEq<T>(0, value);
    }

    public static <T extends Comparable<T>> ValueFilterOperators.ValueLtEq<T> ltEq(int measurementIndex, T value) {
        return new ValueFilterOperators.ValueLtEq<T>(measurementIndex, value);
    }

    public static <T extends Comparable<T>> ValueFilterOperators.ValueEq<T> eq(T value) {
        return new ValueFilterOperators.ValueEq<T>(0, value);
    }

    public static <T extends Comparable<T>> ValueFilterOperators.ValueEq<T> eq(int measurementIndex, T value) {
        return new ValueFilterOperators.ValueEq<T>(measurementIndex, value);
    }

    public static <T extends Comparable<T>> ValueFilterOperators.ValueNotEq<T> notEq(T value) {
        return new ValueFilterOperators.ValueNotEq<T>(0, value);
    }

    public static <T extends Comparable<T>> ValueFilterOperators.ValueNotEq<T> notEq(int measurementIndex, T value) {
        return new ValueFilterOperators.ValueNotEq<T>(measurementIndex, value);
    }

    public static ValueFilterOperators.ValueIsNull isNull() {
        return new ValueFilterOperators.ValueIsNull(0);
    }

    public static ValueFilterOperators.ValueIsNull isNull(int measurementIndex) {
        return new ValueFilterOperators.ValueIsNull(measurementIndex);
    }

    public static ValueFilterOperators.ValueIsNotNull isNotNull() {
        return new ValueFilterOperators.ValueIsNotNull(0);
    }

    public static ValueFilterOperators.ValueIsNotNull isNotNull(int measurementIndex) {
        return new ValueFilterOperators.ValueIsNotNull(measurementIndex);
    }

    public static <T extends Comparable<T>> ValueFilterOperators.ValueBetweenAnd<T> between(T value1, T value2) {
        return new ValueFilterOperators.ValueBetweenAnd<T>(0, value1, value2);
    }

    public static <T extends Comparable<T>> ValueFilterOperators.ValueBetweenAnd<T> between(int measurementIndex, T value1, T value2) {
        return new ValueFilterOperators.ValueBetweenAnd<T>(measurementIndex, value1, value2);
    }

    public static <T extends Comparable<T>> ValueFilterOperators.ValueNotBetweenAnd<T> notBetween(T value1, T value2) {
        return new ValueFilterOperators.ValueNotBetweenAnd<T>(0, value1, value2);
    }

    public static <T extends Comparable<T>> ValueFilterOperators.ValueNotBetweenAnd<T> notBetween(int measurementIndex, T value1, T value2) {
        return new ValueFilterOperators.ValueNotBetweenAnd<T>(measurementIndex, value1, value2);
    }

    public static ValueFilterOperators.ValueRegexp like(String likePattern) {
        return ValueFilterApi.regexp(0, RegexUtils.parseLikePatternToRegex(likePattern));
    }

    public static ValueFilterOperators.ValueRegexp like(int measurementIndex, String likePattern) {
        return ValueFilterApi.regexp(measurementIndex, RegexUtils.parseLikePatternToRegex(likePattern));
    }

    public static ValueFilterOperators.ValueRegexp like(int measurementIndex, Pattern pattern) {
        return ValueFilterApi.regexp(measurementIndex, pattern);
    }

    public static ValueFilterOperators.ValueNotRegexp notLike(String likePattern) {
        return ValueFilterApi.notRegexp(0, RegexUtils.parseLikePatternToRegex(likePattern));
    }

    public static ValueFilterOperators.ValueNotRegexp notLike(int measurementIndex, String likePattern) {
        return ValueFilterApi.notRegexp(measurementIndex, RegexUtils.parseLikePatternToRegex(likePattern));
    }

    public static ValueFilterOperators.ValueNotRegexp notLike(int measurementIndex, Pattern pattern) {
        return ValueFilterApi.notRegexp(measurementIndex, pattern);
    }

    public static ValueFilterOperators.ValueRegexp regexp(String regex) {
        return new ValueFilterOperators.ValueRegexp(0, RegexUtils.compileRegex(regex));
    }

    public static ValueFilterOperators.ValueRegexp regexp(int measurementIndex, String regex) {
        return new ValueFilterOperators.ValueRegexp(measurementIndex, RegexUtils.compileRegex(regex));
    }

    public static ValueFilterOperators.ValueRegexp regexp(int measurementIndex, Pattern pattern) {
        return new ValueFilterOperators.ValueRegexp(measurementIndex, pattern);
    }

    public static ValueFilterOperators.ValueNotRegexp notRegexp(String regex) {
        return new ValueFilterOperators.ValueNotRegexp(0, RegexUtils.compileRegex(regex));
    }

    public static ValueFilterOperators.ValueNotRegexp notRegexp(int measurementIndex, String regex) {
        return new ValueFilterOperators.ValueNotRegexp(measurementIndex, RegexUtils.compileRegex(regex));
    }

    public static ValueFilterOperators.ValueNotRegexp notRegexp(int measurementIndex, Pattern pattern) {
        return new ValueFilterOperators.ValueNotRegexp(measurementIndex, pattern);
    }

    public static <T extends Comparable<T>> ValueFilterOperators.ValueIn<T> in(Set<T> values) {
        return new ValueFilterOperators.ValueIn<T>(0, values);
    }

    public static <T extends Comparable<T>> ValueFilterOperators.ValueIn<T> in(int measurementIndex, Set<T> values) {
        return new ValueFilterOperators.ValueIn<T>(measurementIndex, values);
    }

    public static <T extends Comparable<T>> ValueFilterOperators.ValueNotIn<T> notIn(Set<T> values) {
        return new ValueFilterOperators.ValueNotIn<T>(0, values);
    }

    public static <T extends Comparable<T>> ValueFilterOperators.ValueNotIn<T> notIn(int measurementIndex, Set<T> values) {
        return new ValueFilterOperators.ValueNotIn<T>(measurementIndex, values);
    }
}

