/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.task.subtask;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeConnectorCriticalException;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.pipe.execution.scheduler.PipeSubtaskScheduler;
import org.apache.iotdb.commons.pipe.task.DecoratingLock;
import org.apache.iotdb.commons.pipe.task.subtask.PipeReportableSubtask;
import org.apache.iotdb.pipe.api.PipeConnector;
import org.apache.iotdb.pipe.api.exception.PipeConnectionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PipeAbstractConnectorSubtask
extends PipeReportableSubtask {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeAbstractConnectorSubtask.class);
    protected PipeConnector outputPipeConnector;
    protected final DecoratingLock callbackDecoratingLock = new DecoratingLock();
    protected ExecutorService subtaskCallbackListeningExecutor;
    protected volatile boolean isSubmitted = false;

    protected PipeAbstractConnectorSubtask(String taskID, long creationTime, PipeConnector outputPipeConnector) {
        super(taskID, creationTime);
        this.outputPipeConnector = outputPipeConnector;
    }

    @Override
    public void bindExecutors(ListeningExecutorService subtaskWorkerThreadPoolExecutor, ExecutorService subtaskCallbackListeningExecutor, PipeSubtaskScheduler subtaskScheduler) {
        this.subtaskWorkerThreadPoolExecutor = subtaskWorkerThreadPoolExecutor;
        this.subtaskCallbackListeningExecutor = subtaskCallbackListeningExecutor;
        this.subtaskScheduler = subtaskScheduler;
    }

    @Override
    public Boolean call() throws Exception {
        boolean hasAtLeastOneEventProcessed = super.call();
        this.callbackDecoratingLock.waitForDecorated();
        return hasAtLeastOneEventProcessed;
    }

    @Override
    public synchronized void onSuccess(Boolean hasAtLeastOneEventProcessed) {
        this.isSubmitted = false;
        super.onSuccess(hasAtLeastOneEventProcessed);
    }

    @Override
    public synchronized void onFailure(Throwable throwable) {
        this.isSubmitted = false;
        if (this.isClosed.get()) {
            LOGGER.info("onFailure in pipe transfer, ignored because pipe is dropped.", throwable);
            this.clearReferenceCountAndReleaseLastEvent();
            return;
        }
        if (throwable instanceof PipeConnectionException && this.onPipeConnectionException(throwable)) {
            return;
        }
        super.onFailure((Throwable)(throwable instanceof PipeRuntimeConnectorCriticalException ? throwable : new PipeRuntimeConnectorCriticalException(throwable.getMessage())));
    }

    private boolean onPipeConnectionException(Throwable throwable) {
        LOGGER.warn("PipeConnectionException occurred, {} retries to handshake with the target system.", (Object)this.outputPipeConnector.getClass().getName(), (Object)throwable);
        int retry = 0;
        while (retry < 5) {
            try {
                this.outputPipeConnector.handshake();
                LOGGER.info("{} handshakes with the target system successfully.", (Object)this.outputPipeConnector.getClass().getName());
                break;
            }
            catch (Exception e) {
                LOGGER.warn("{} failed to handshake with the target system for {} times, will retry at most {} times.", new Object[]{this.outputPipeConnector.getClass().getName(), ++retry, 5, e});
                try {
                    Thread.sleep((long)retry * PipeConfig.getInstance().getPipeConnectorRetryIntervalMs());
                }
                catch (InterruptedException interruptedException) {
                    LOGGER.info("Interrupted while sleeping, will retry to handshake with the target system.", (Throwable)interruptedException);
                    Thread.currentThread().interrupt();
                }
            }
        }
        if (retry == 5 && this.lastEvent instanceof EnrichedEvent) {
            this.report((EnrichedEvent)this.lastEvent, new PipeRuntimeConnectorCriticalException(throwable.getMessage() + ", root cause: " + this.getRootCause(throwable)));
            LOGGER.warn("{} failed to handshake with the target system after {} times, stopping current subtask {} (creation time: {}, simple class: {}). Status shown when query the pipe will be 'STOPPED'. Please restart the task by executing 'START PIPE' manually if needed.", new Object[]{this.outputPipeConnector.getClass().getName(), 5, this.taskID, this.creationTime, this.getClass().getSimpleName(), throwable});
            return true;
        }
        return false;
    }

    @Override
    public synchronized void submitSelf() {
        if (this.shouldStopSubmittingSelf.get() || this.isSubmitted) {
            return;
        }
        this.callbackDecoratingLock.markAsDecorating();
        try {
            ListenableFuture nextFuture = this.subtaskWorkerThreadPoolExecutor.submit((Callable)this);
            Futures.addCallback((ListenableFuture)nextFuture, (FutureCallback)this, (Executor)this.subtaskCallbackListeningExecutor);
            this.isSubmitted = true;
        }
        finally {
            this.callbackDecoratingLock.markAsDecorated();
        }
    }
}

